/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import gollorum.signpost.compat.ExternalWaystoneLibrary;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public interface WaystoneHandle {
    public static final StreamCodec<ByteBuf, WaystoneHandle> STREAM_CODEC = ByteBufCodecs.STRING_UTF8.dispatch(WaystoneHandle::typeTag, type -> {
        if (type.equals("vanilla")) {
            return Vanilla.STREAM_CODEC;
        }
        return ExternalWaystoneLibrary.getInstance().getStreamCodec((String)type).orElseThrow();
    });
    public static final MapCodec<WaystoneHandle> MAP_CODEC = Codec.STRING.dispatchMap("type", WaystoneHandle::typeTag, type -> {
        if (type.equals("vanilla")) {
            return Vanilla.CODEC;
        }
        return ExternalWaystoneLibrary.getInstance().getCodec((String)type).orElseGet(() -> MapCodec.unit((Object)Vanilla.NIL));
    });

    public String typeTag();

    public record Vanilla(UUID id) implements WaystoneHandle
    {
        public static final String typeTag = "vanilla";
        public static final Vanilla NIL = new Vanilla(Util.NIL_UUID);
        public static final MapCodec<Vanilla> CODEC = UUIDUtil.CODEC.fieldOf("Id").xmap(Vanilla::new, Vanilla::id);
        public static final StreamCodec<ByteBuf, Vanilla> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, Vanilla::id, Vanilla::new);

        @Override
        public String typeTag() {
            return typeTag;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Vanilla that = (Vanilla)o;
            return Objects.equals(this.id, that.id);
        }

        @Override
        public int hashCode() {
            return this.id.hashCode();
        }
    }
}

