/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blockpartdata.types;

import com.mojang.blaze3d.vertex.PoseStack;
import gollorum.signpost.Signpost;
import gollorum.signpost.blockpartdata.types.LargeSignBlockPart;
import gollorum.signpost.blockpartdata.types.PostBlockPart;
import gollorum.signpost.blockpartdata.types.SmallShortSignBlockPart;
import gollorum.signpost.blockpartdata.types.SmallWideSignBlockPart;
import gollorum.signpost.blockpartdata.types.WaystoneBlockPart;
import gollorum.signpost.blockpartdata.types.renderers.LargeSignRenderer;
import gollorum.signpost.blockpartdata.types.renderers.PostRenderer;
import gollorum.signpost.blockpartdata.types.renderers.ShortSignRenderer;
import gollorum.signpost.blockpartdata.types.renderers.WaystoneRenderer;
import gollorum.signpost.blockpartdata.types.renderers.WideSignRenderer;
import gollorum.signpost.utils.BlockPart;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public abstract class BlockPartRenderer<T extends BlockPart<T>> {
    private static final Map<Class<?>, BlockPartRenderer<?>> renderers = new ConcurrentHashMap();

    public static <T extends BlockPart<T>> void register(Class<T> blockPartClass, BlockPartRenderer<T> renderer) {
        renderers.put(blockPartClass, renderer);
    }

    private static <T extends BlockPart<T>> Optional<BlockPartRenderer<T>> getFor(Class<T> blockPartClass) {
        BlockPartRenderer<?> renderer = renderers.get(blockPartClass);
        return renderer == null ? Optional.empty() : Optional.of(renderer);
    }

    public static <T extends BlockPart<T>> void renderDynamic(T part, Level level, BlockPos pos, PoseStack blockToView, SubmitNodeCollector nodeCollector, MaterialSet materials, int combinedLights, int combinedOverlay, Function<ResourceLocation, RenderType> renderTypeFactory, ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        Optional<BlockPartRenderer<?>> renderer = BlockPartRenderer.getFor(part.getClass());
        if (renderer.isPresent()) {
            renderer.get().render(part, level, pos, blockToView, nodeCollector, materials, combinedLights, combinedOverlay, renderTypeFactory, crumblingOverlay);
        } else {
            Signpost.LOGGER.error("Block part renderer was not found for " + String.valueOf(part.getClass()));
        }
    }

    public abstract void render(T var1, Level var2, BlockPos var3, PoseStack var4, SubmitNodeCollector var5, MaterialSet var6, int var7, int var8, Function<ResourceLocation, RenderType> var9, ModelFeatureRenderer.CrumblingOverlay var10);

    static {
        BlockPartRenderer.register(PostBlockPart.class, new PostRenderer());
        BlockPartRenderer.register(SmallWideSignBlockPart.class, new WideSignRenderer());
        BlockPartRenderer.register(SmallShortSignBlockPart.class, new ShortSignRenderer());
        BlockPartRenderer.register(LargeSignBlockPart.class, new LargeSignRenderer());
        BlockPartRenderer.register(WaystoneBlockPart.class, new WaystoneRenderer());
    }
}

