/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blockpartdata.types.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.blockpartdata.Overlay;
import gollorum.signpost.blockpartdata.types.SmallShortSignBlockPart;
import gollorum.signpost.blockpartdata.types.renderers.SignRenderer;
import gollorum.signpost.minecraft.gui.utils.Colors;
import gollorum.signpost.minecraft.models.ShortSignModel;
import gollorum.signpost.minecraft.models.modelGeneration.QuadModel;
import gollorum.signpost.minecraft.rendering.RenderingUtil;
import gollorum.signpost.utils.math.MathUtils;
import java.util.Optional;
import java.util.Random;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.network.chat.Component;
import org.joml.AxisAngle4d;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ShortSignRenderer
extends SignRenderer<SmallShortSignBlockPart> {
    private static final float TEXT_OFFSET_RIGHT = -0.1875f;
    private static final float TEXT_OFFSET_LEFT = 0.84375f;
    private static final float MAXIMUM_TEXT_WIDTH = 0.65625f;
    private static final float TEXT_RATIO = 1.3f;
    private static final float FONT_SIZE_VOXELS = 1.5384616f;

    @Override
    protected QuadModel makeMainModel(SmallShortSignBlockPart sign) {
        return sign.isFlipped() ? ShortSignModel.MODEL_MAIN_FLIPPED : ShortSignModel.MODEL_MAIN;
    }

    @Override
    protected QuadModel makeSecondaryModel(SmallShortSignBlockPart sign) {
        return sign.isFlipped() ? ShortSignModel.MODEL_SECONDARY_FLIPPED : ShortSignModel.MODEL_SECONDARY;
    }

    @Override
    protected QuadModel makeBakedOverlayModel(SmallShortSignBlockPart sign, Overlay overlay) {
        return sign.isFlipped() ? ShortSignModel.MODEL_OVERLAY_FLIPPED : ShortSignModel.MODEL_OVERLAY;
    }

    @Override
    protected void renderText(SmallShortSignBlockPart sign, PoseStack matrix, Font fontRenderer, SubmitNodeCollector nodeCollector, int combinedLights) {
        this.renderText(true, sign, matrix, fontRenderer, nodeCollector, combinedLights);
        this.renderText(false, sign, matrix, fontRenderer, nodeCollector, combinedLights);
    }

    private void renderText(boolean isFlipped, SmallShortSignBlockPart sign, PoseStack matrix, Font fontRenderer, SubmitNodeCollector nodeCollector, int combinedLights) {
        RenderingUtil.wrapInMatrixEntry(matrix, () -> {
            Optional overrideName;
            String text = sign.getText().get();
            if (sign.isMarkedForGeneration() && (overrideName = WaystoneLibrary.getInstance().getAllWaystoneNames(true).flatMap(s -> s.stream().skip(new Random().nextInt(s.size())).findFirst())).isPresent()) {
                text = (String)overrideName.get();
            }
            float scale = 0.012019231f;
            float MAX_WIDTH_FRAC = (float)fontRenderer.width(text) * scale / 0.65625f;
            scale /= Math.max(1.0f, MAX_WIDTH_FRAC);
            boolean flipped = isFlipped ^ sign.isFlipped();
            if (isFlipped) {
                matrix.mulPose((Quaternionfc)new Quaternionf(new AxisAngle4d(Math.PI, new Vector3f(0.0f, 1.0f, 0.0f))));
            }
            float offset = MathUtils.lerp(-0.1875f, -0.515625f, 1.0f - Math.min(1.0f, MAX_WIDTH_FRAC));
            matrix.translate(flipped ? (double)(offset - (float)fontRenderer.width(text) * scale) : (double)(-offset), (double)(-scale * 4.0f * 1.3f), -0.0315625);
            matrix.scale(scale, scale * 1.3f, scale);
            nodeCollector.submitText(matrix, 0.0f, 0.0f, Component.literal((String)text).getVisualOrderText(), false, Font.DisplayMode.POLYGON_OFFSET, combinedLights, Colors.withAlpha(sign.getColor(), 255), 0, 0);
        });
    }
}

