/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blockpartdata.types.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.blockpartdata.Overlay;
import gollorum.signpost.blockpartdata.types.SmallWideSignBlockPart;
import gollorum.signpost.blockpartdata.types.renderers.SignRenderer;
import gollorum.signpost.minecraft.gui.utils.Colors;
import gollorum.signpost.minecraft.models.WideSignModel;
import gollorum.signpost.minecraft.models.modelGeneration.QuadModel;
import gollorum.signpost.minecraft.rendering.RenderingUtil;
import java.util.Optional;
import java.util.Random;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.network.chat.Component;

public class WideSignRenderer
extends SignRenderer<SmallWideSignBlockPart> {
    private static final float TEXT_OFFSET_RIGHT = 0.4375f;
    private static final float TEXT_OFFSET_LEFT = 0.6875f;
    private static final float MAXIMUM_TEXT_WIDTH = 1.125f;
    private static final float TEXT_RATIO = 1.3f;
    private static final float FONT_SIZE_VOXELS = 1.5384616f;

    @Override
    protected QuadModel makeMainModel(SmallWideSignBlockPart sign) {
        return sign.isFlipped() ? WideSignModel.MODEL_MAIN_FLIPPED : WideSignModel.MODEL_MAIN;
    }

    @Override
    protected QuadModel makeSecondaryModel(SmallWideSignBlockPart sign) {
        return sign.isFlipped() ? WideSignModel.MODEL_SECONDARY_FLIPPED : WideSignModel.MODEL_SECONDARY;
    }

    @Override
    protected QuadModel makeBakedOverlayModel(SmallWideSignBlockPart sign, Overlay overlay) {
        return sign.isFlipped() ? WideSignModel.MODEL_OVERLAY_FLIPPED : WideSignModel.MODEL_OVERLAY;
    }

    @Override
    protected void renderText(SmallWideSignBlockPart sign, PoseStack matrix, Font fontRenderer, SubmitNodeCollector nodeCollector, int combinedLights) {
        RenderingUtil.wrapInMatrixEntry(matrix, () -> {
            Optional overrideName;
            String text = sign.getText().get();
            if (sign.isMarkedForGeneration() && (overrideName = WaystoneLibrary.getInstance().getAllWaystoneNames(true).flatMap(s -> !s.isEmpty() ? (s.size() == 1 ? s.stream() : s.stream().skip(new Random().nextInt(s.size() - 1))).findFirst() : Optional.empty())).isPresent()) {
                text = (String)overrideName.get();
            }
            float scale = 0.012019231f;
            float MAX_WIDTH_FRAC = (float)fontRenderer.width(text) * scale / 1.125f;
            float offset = 0.4375f * Math.min(1.0f, MAX_WIDTH_FRAC);
            matrix.translate(sign.isFlipped() ? (double)(offset - (float)fontRenderer.width(text) * (scale /= Math.max(1.0f, MAX_WIDTH_FRAC))) : (double)(-offset), (double)(-scale * 4.0f * 1.3f), -0.1878125);
            matrix.scale(scale, scale * 1.3f, scale);
            nodeCollector.submitText(matrix, 0.0f, 0.0f, Component.literal((String)text).getVisualOrderText(), false, Font.DisplayMode.POLYGON_OFFSET, combinedLights, Colors.withAlpha(sign.getColor(), 255), 0, 0);
        });
    }
}

