/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.config;

import gollorum.signpost.config.PermissionConfig;
import gollorum.signpost.config.TeleportConfig;
import gollorum.signpost.config.WorldGenConfig;
import gollorum.signpost.minecraft.block.ModelWaystone;
import gollorum.signpost.minecraft.config.IConfig;
import gollorum.signpost.minecraft.config.IPermissionConfig;
import gollorum.signpost.minecraft.config.ITeleportConfig;
import gollorum.signpost.minecraft.config.IWorldGenConfig;
import gollorum.signpost.utils.Tuple;
import java.util.List;
import java.util.stream.Collectors;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class Config
implements IConfig {
    public static final Config INSTANCE = new Config();
    public final Server Server;
    public final ModConfigSpec ServerConfig;
    public final Common Common;
    private final ModConfigSpec CommonConfig;
    public final Client Client;
    private final ModConfigSpec ClientConfig;

    @Override
    public IConfig.IServer getServer() {
        return this.Server;
    }

    @Override
    public IConfig.ICommon getCommon() {
        return this.Common;
    }

    @Override
    public IConfig.IClient getClient() {
        return this.Client;
    }

    public Config() {
        Tuple commonTuple = Tuple.from(new ModConfigSpec.Builder().configure(Common::new));
        this.Common = (Common)commonTuple._1();
        this.CommonConfig = (ModConfigSpec)commonTuple._2();
        Tuple serverTuple = Tuple.from(new ModConfigSpec.Builder().configure(builder -> new Server(this, (ModConfigSpec.Builder)builder, this.Common)));
        this.Server = (Server)serverTuple._1();
        this.ServerConfig = (ModConfigSpec)serverTuple._2();
        Tuple clientTuple = Tuple.from(new ModConfigSpec.Builder().configure(Client::new));
        this.Client = (Client)clientTuple._1();
        this.ClientConfig = (ModConfigSpec)clientTuple._2();
    }

    public void register() {
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)this.ServerConfig);
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)this.CommonConfig);
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)this.ClientConfig);
    }

    public class Server
    implements IConfig.IServer {
        private final ITeleportConfig teleport;
        private final IWorldGenConfig worldGen;
        private final PermissionConfig permissions;
        private final ModConfigSpec.ConfigValue<List<? extends String>> allowedWaystones;

        @Override
        public List<? extends String> allowedWaystones() {
            return (List)this.allowedWaystones.get();
        }

        @Override
        public IPermissionConfig permissions() {
            return this.permissions;
        }

        @Override
        public IWorldGenConfig worldGen() {
            return this.worldGen;
        }

        @Override
        public boolean isLoaded() {
            return Config.INSTANCE.ServerConfig.isLoaded();
        }

        @Override
        public ITeleportConfig teleport() {
            return this.teleport;
        }

        public Server(Config this$0, ModConfigSpec.Builder builder, Common commonConfig) {
            builder.push("teleport");
            this.teleport = new TeleportConfig(builder);
            builder.pop();
            this.allowedWaystones = builder.comment(new String[]{"You can define which waystone models are enabled.", "Disabled types are still in the game but disappear from the creative menu. Use data packs to remove the stonecutter recipes as well.", "The available variants are: " + ModelWaystone.variants.stream().map(v -> "\"" + v.name + "\"").collect(Collectors.joining(", ")), "Check out the curseforge page to see what they look like: https://www.curseforge.com/minecraft/mc-mods/signpost/pages/waystone-models"}).worldRestart().defineList("allowed_waystone_models", ModelWaystone.variants.stream().map(v -> v.name).collect(Collectors.toList()), n -> n instanceof String && ModelWaystone.variants.contains(new ModelWaystone.Variant((String)n, null, null, 0.0f)));
            builder.push("permissions");
            this.permissions = new PermissionConfig(builder);
            builder.pop();
            builder.push("world_gen");
            this.worldGen = new WorldGenConfig(builder, true, commonConfig);
            builder.pop();
        }
    }

    public static class Common
    implements IConfig.ICommon {
        public final WorldGenConfig worldGenDefaults;

        public Common(ModConfigSpec.Builder builder) {
            builder.push("world_gen_defaults");
            this.worldGenDefaults = new WorldGenConfig(builder, false, this);
            builder.pop();
        }
    }

    public static class Client
    implements IConfig.IClient {
        private final ModConfigSpec.BooleanValue enableConfirmationScreen;

        @Override
        public boolean enableConfirmationScreen() {
            return (Boolean)this.enableConfirmationScreen.get();
        }

        public Client(ModConfigSpec.Builder builder) {
            builder.push("teleport");
            this.enableConfirmationScreen = builder.comment(new String[]{"Defines whether the confirmation screen pops when using a sign to teleport.", "CAUTION 1: The necessary items will be removed without notice if costs are involved.", "CAUTION 2: The only way to edit a sign with destination is through this screen.", "This should probably never be turned off. Why did I make it an option? No idea."}).define("enable_confirmation_screen", true);
            builder.pop();
        }
    }
}

