/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.data;

import com.google.common.collect.ImmutableList;
import gollorum.signpost.minecraft.block.ModelWaystone;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.block.WaystoneBlock;
import gollorum.signpost.minecraft.data.PostData;
import gollorum.signpost.minecraft.data.WaystoneHandleData;
import gollorum.signpost.minecraft.loot.PermissionCheck;
import gollorum.signpost.minecraft.loot.PostBlockPartDropLoot;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.advancements.critereon.DataComponentMatchers;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.predicates.DataComponentPredicate;
import net.minecraft.core.component.predicates.DataComponentPredicates;
import net.minecraft.core.component.predicates.EnchantmentsPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.packs.VanillaLootTableProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.AllOfCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class LootTables
extends LootTableProvider {
    public LootTables(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registryAccess) {
        super(packOutput, Set.of(), VanillaLootTableProvider.create((PackOutput)packOutput, registryAccess).getTables(), registryAccess);
    }

    public List<LootTableProvider.SubProviderEntry> getTables() {
        return ImmutableList.of((Object)new LootTableProvider.SubProviderEntry(registryAccess -> builder -> this.generateBlockLootTables((HolderLookup.Provider)registryAccess, builder), LootContextParamSets.BLOCK));
    }

    private void generateBlockLootTables(HolderLookup.Provider registryAccess, BiConsumer<ResourceKey<LootTable>, LootTable.Builder> builder) {
        for (PostBlock.Variant variant : PostBlock.AllVariants) {
            builder.accept((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)("blocks/" + BuiltInRegistries.BLOCK.getKey((Object)variant.getBlock()).getPath()))), this.mkPostLootTable(registryAccess, variant));
        }
        builder.accept((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)("blocks/" + BuiltInRegistries.BLOCK.getKey((Object)WaystoneBlock.getInstance()).getPath()))), this.mkWaystoneLootTable(registryAccess, (Block)WaystoneBlock.getInstance()));
        for (ModelWaystone.Variant variant : ModelWaystone.variants) {
            builder.accept((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)("blocks/" + BuiltInRegistries.BLOCK.getKey((Object)variant.getBlock()).getPath()))), this.mkWaystoneLootTable(registryAccess, (Block)variant.getBlock()));
        }
    }

    private LootTable.Builder mkWaystoneLootTable(HolderLookup.Provider registryAccess, Block block) {
        AllOfCondition.Builder includeDataCondition = this.hasSilkTouch(registryAccess).and((LootItemCondition.Builder)new PermissionCheck.Builder(PermissionCheck.Type.CanPickWaystone));
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponentsFromBlockEntity((ContextKey)new ContextKey(ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)"waystone"))).include(WaystoneHandleData.TYPE).include(DataComponents.CUSTOM_NAME)).when((LootItemCondition.Builder)includeDataCondition)).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block))));
    }

    private LootTable.Builder mkPostLootTable(HolderLookup.Provider registryAccess, PostBlock.Variant variant) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)variant.getBlock()).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponentsFromBlockEntity((ContextKey)new ContextKey(ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)"post"))).include(WaystoneHandleData.TYPE).include(DataComponents.CUSTOM_NAME).include(PostData.TYPE)).when(this.hasSilkTouch(registryAccess))).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)variant.getBlock())))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(PostBlockPartDropLoot.createBuilder().when(this.hasSilkTouch(registryAccess).invert())));
    }

    private LootItemCondition.Builder hasSilkTouch(HolderLookup.Provider registryAccess) {
        HolderLookup.RegistryLookup registrylookup = registryAccess.lookupOrThrow(Registries.ENCHANTMENT);
        return MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().withComponents(DataComponentMatchers.Builder.components().partial(DataComponentPredicates.ENCHANTMENTS, (DataComponentPredicate)EnchantmentsPredicate.enchantments(List.of(new EnchantmentPredicate((Holder)registrylookup.getOrThrow(Enchantments.SILK_TOUCH), MinMaxBounds.Ints.atLeast((int)1))))).build()));
    }
}

