/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.data;

import gollorum.signpost.data.ItemTags;
import gollorum.signpost.minecraft.block.ModelWaystone;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.block.WaystoneBlock;
import gollorum.signpost.minecraft.crafting.CutWaystoneRecipe;
import gollorum.signpost.registry.ItemRegistry;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class Recipes
extends RecipeProvider {
    protected Recipes(HolderLookup.Provider registries, RecipeOutput output) {
        super(registries, output);
    }

    protected void buildRecipes() {
        this.registerBrush();
        this.registerPosts();
        this.registerWaystones();
        this.registerWrench();
    }

    private void registerBrush() {
        this.shaped(RecipeCategory.TOOLS, (ItemLike)ItemRegistry.BRUSH.get()).define(Character.valueOf('w'), net.minecraft.tags.ItemTags.WOOL).define(Character.valueOf('i'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('s'), (ItemLike)Items.STICK).pattern("w").pattern("i").pattern("s").unlockedBy("has_signpost", this.has(ItemTags.SignpostTag)).save(this.output);
    }

    public void registerPosts() {
        for (PostBlock.Variant variant : PostBlock.AllVariants) {
            this.shaped(RecipeCategory.DECORATIONS, (ItemLike)variant.getBlock(), 2).define(Character.valueOf('s'), variant.type.signIngredient.apply(this.registries)).define(Character.valueOf('b'), variant.type.baseIngredient.apply(this.registries)).pattern("s").pattern("s").pattern("b").unlockedBy("has_sign", this.has(net.minecraft.tags.ItemTags.SIGNS)).unlockedBy("has_signpost", this.has(ItemTags.SignpostTag)).unlockedBy("has_waystone", this.has((ItemLike)WaystoneBlock.getInstance())).group("Signpost").save(this.output);
        }
    }

    public void registerWaystones() {
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)WaystoneBlock.getInstance()).define(Character.valueOf('s'), (ItemLike)Items.STONE).define(Character.valueOf('e'), (ItemLike)Items.ENDER_PEARL).pattern("sss").pattern("ses").pattern("sss").unlockedBy("has_ender_pearl", this.has((ItemLike)Items.ENDER_PEARL)).unlockedBy("has_signpost", this.has(ItemTags.SignpostTag)).save(this.output);
        for (ModelWaystone.Variant v : ModelWaystone.variants) {
            new SingleItemRecipeBuilder(RecipeCategory.DECORATIONS, CutWaystoneRecipe::new, this.tag(ItemTags.WaystoneTag), (ItemLike)v.getBlock(), 1).unlockedBy("has_waystone", this.has(ItemTags.WaystoneTag)).save(this.output, ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)("cut_into_" + v.name))));
        }
        new SingleItemRecipeBuilder(RecipeCategory.DECORATIONS, CutWaystoneRecipe::new, this.tag(ItemTags.WaystoneTag), (ItemLike)WaystoneBlock.getInstance(), 1).unlockedBy("has_waystone", this.has(ItemTags.WaystoneTag)).save(this.output, ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)"cut_into_full_block")));
    }

    public void registerWrench() {
        this.shaped(RecipeCategory.TOOLS, (ItemLike)ItemRegistry.WRENCH.get(), 1).define(Character.valueOf('s'), net.minecraft.tags.ItemTags.SIGNS).define(Character.valueOf('i'), (ItemLike)Items.IRON_INGOT).pattern("i ").pattern("ii").pattern("s ").unlockedBy("has_signpost", this.has(ItemTags.SignpostTag)).save(this.output);
    }

    public static class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(output, lookupProvider);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider registries, RecipeOutput output) {
            return new Recipes(registries, output);
        }

        public String getName() {
            return "Signpost Recipes";
        }
    }
}

