/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.data.blocks;

import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.rendering.PostItemRenderer;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class PostModel {
    public static void register(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
        for (PostBlock.Variant variant : PostBlock.AllVariants) {
            PostBlock postBlock = variant.getBlock();
            blockModels.createParticleOnlyBlock((Block)postBlock, switch (variant.type.name) {
                case "acacia" -> Blocks.ACACIA_LOG;
                case "birch" -> Blocks.BIRCH_LOG;
                case "iron" -> Blocks.IRON_BLOCK;
                case "jungle" -> Blocks.JUNGLE_LOG;
                case "oak" -> Blocks.OAK_LOG;
                case "darkoak" -> Blocks.DARK_OAK_LOG;
                case "spruce" -> Blocks.SPRUCE_LOG;
                case "mangrove" -> Blocks.MANGROVE_LOG;
                case "bamboo" -> Blocks.BAMBOO_BLOCK;
                case "cherry" -> Blocks.CHERRY_LOG;
                case "stone" -> Blocks.STONE;
                case "red_mushroom" -> Blocks.RED_MUSHROOM_BLOCK;
                case "brown_mushroom" -> Blocks.BROWN_MUSHROOM_BLOCK;
                case "warped" -> Blocks.WARPED_STEM;
                case "crimson" -> Blocks.CRIMSON_STEM;
                case "sandstone" -> Blocks.SANDSTONE;
                default -> throw new IllegalStateException("Unexpected value: " + variant.type.name);
            });
            itemModels.itemModelOutput.accept(variant.getBlock().asItem(), ItemModelUtils.specialModel((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"block/cube_all"), (SpecialModelRenderer.Unbaked)new PostItemRenderer.Unbaked(variant.type)));
        }
    }
}

