/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.data.blocks;

import com.mojang.math.Quadrant;
import gollorum.signpost.minecraft.block.ModelWaystone;
import gollorum.signpost.minecraft.gui.utils.TextureResource;
import gollorum.signpost.registry.BlockRegistry;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.blockstates.MultiPartGenerator;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.blockstates.PropertyDispatch;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.data.models.model.TexturedModel;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class WaystoneModel {
    public static void register(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
        ResourceLocation waystoneTexture = TextureResource.waystoneTextureLocation.location();
        blockModels.createTrivialBlock((Block)BlockRegistry.WaystoneBlock.get(), TexturedModel.createDefault(block -> new TextureMapping().put(TextureSlot.ALL, waystoneTexture), (ModelTemplate)ModelTemplates.CUBE_ALL));
        for (ModelWaystone.Variant variant : ModelWaystone.variants) {
            Variant model = BlockModelGenerators.plainModel((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)("block/" + variant.registryName)));
            MultiVariantGenerator foo = MultiVariantGenerator.dispatch((Block)variant.getBlock()).with(PropertyDispatch.initial(ModelWaystone.Facing).generate(dir -> switch (dir) {
                case Direction.SOUTH -> BlockModelGenerators.variant((Variant)model);
                case Direction.WEST -> BlockModelGenerators.variant((Variant)model.withYRot(Quadrant.R90));
                case Direction.NORTH -> BlockModelGenerators.variant((Variant)model.withYRot(Quadrant.R180));
                case Direction.EAST -> BlockModelGenerators.variant((Variant)model.withYRot(Quadrant.R270));
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(dir));
            }));
            MultiPartGenerator blockStateDefinition = MultiPartGenerator.multiPart((Block)variant.getBlock()).with(BlockModelGenerators.condition().term(ModelWaystone.Facing, (Comparable)Direction.SOUTH).build(), BlockModelGenerators.variant((Variant)model)).with(BlockModelGenerators.condition().term(ModelWaystone.Facing, (Comparable)Direction.WEST).build(), BlockModelGenerators.variant((Variant)model.withYRot(Quadrant.R90))).with(BlockModelGenerators.condition().term(ModelWaystone.Facing, (Comparable)Direction.NORTH).build(), BlockModelGenerators.variant((Variant)model.withYRot(Quadrant.R180))).with(BlockModelGenerators.condition().term(ModelWaystone.Facing, (Comparable)Direction.EAST).build(), BlockModelGenerators.variant((Variant)model.withYRot(Quadrant.R270)));
            blockModels.blockStateOutput.accept(foo);
        }
    }
}

