/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gollorum.signpost.PlayerHandle;
import gollorum.signpost.Signpost;
import gollorum.signpost.blockpartdata.types.PostBlockPart;
import gollorum.signpost.interactions.Interactable;
import gollorum.signpost.interactions.InteractionInfo;
import gollorum.signpost.minecraft.block.PropertiesUtil;
import gollorum.signpost.minecraft.block.WaystoneBlock;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.data.PostData;
import gollorum.signpost.minecraft.gui.RequestSignGui;
import gollorum.signpost.minecraft.utils.Texture;
import gollorum.signpost.minecraft.utils.TileEntityUtils;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.utils.BlockPartInstance;
import gollorum.signpost.utils.IDelay;
import gollorum.signpost.utils.WorldLocation;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;

public final class PostBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<Direction> Facing = BlockStateProperties.HORIZONTAL_FACING;
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final String REGISTRY_NAME = "post";
    public static final Variant STONE = new Variant(PropertiesUtil.STONE, ModelType.Stone, "stone", Variant.RequiredTool.Pickaxe);
    public static final Variant IRON = new Variant(PropertiesUtil.IRON, ModelType.Iron, "iron", Variant.RequiredTool.Pickaxe);
    public static final Variant OAK = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.Oak), ModelType.Oak, "oak", Variant.RequiredTool.Axe);
    public static final Variant DARK_OAK = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.DarkOak), ModelType.DarkOak, "dark_oak", Variant.RequiredTool.Axe);
    public static final Variant SPRUCE = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.Spruce), ModelType.Spruce, "spruce", Variant.RequiredTool.Axe);
    public static final Variant BIRCH = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.Birch), ModelType.Birch, "birch", Variant.RequiredTool.Axe);
    public static final Variant JUNGLE = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.Jungle), ModelType.Jungle, "jungle", Variant.RequiredTool.Axe);
    public static final Variant ACACIA = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.Acacia), ModelType.Acacia, "acacia", Variant.RequiredTool.Axe);
    public static final Variant MANGROVE = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.Mangrove), ModelType.Mangrove, "mangrove", Variant.RequiredTool.Axe);
    public static final Variant BAMBOO = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.Bamboo), ModelType.Bamboo, "bamboo", Variant.RequiredTool.Axe);
    public static final Variant CHERRY = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.Cherry), ModelType.Cherry, "cherry", Variant.RequiredTool.Axe);
    public static final Variant WARPED = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.Warped), ModelType.Warped, "warped", Variant.RequiredTool.Axe);
    public static final Variant CRIMSON = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.Crimson), ModelType.Crimson, "crimson", Variant.RequiredTool.Axe);
    public static final Variant SANDSTONE = new Variant(PropertiesUtil.STONE, ModelType.Sandstone, "sandstone", Variant.RequiredTool.Pickaxe);
    public static final Variant BROWN_MUSHROOM = new Variant(PropertiesUtil.mushroom(MapColor.DIRT), ModelType.BrownMushroom, "brown_mushroom", Variant.RequiredTool.Axe);
    public static final Variant RED_MUSHROOM = new Variant(PropertiesUtil.mushroom(MapColor.COLOR_RED), ModelType.RedMushroom, "red_mushroom", Variant.RequiredTool.Axe);
    public static final List<Variant> AllVariants = Arrays.asList(OAK, BIRCH, SPRUCE, JUNGLE, DARK_OAK, ACACIA, MANGROVE, BAMBOO, CHERRY, STONE, IRON, WARPED, CRIMSON, SANDSTONE, BROWN_MUSHROOM, RED_MUSHROOM);
    public final ModelType type;
    public final Variant variant;

    public boolean hasDynamicShape() {
        return true;
    }

    public static Block[] getAllBlocks() {
        return (Block[])AllVariants.stream().map(Variant::getBlock).toArray(Block[]::new);
    }

    public PostBlock(BlockBehaviour.Properties properties, ModelType type, Variant variant) {
        super(properties.noOcclusion());
        this.type = type;
        this.variant = variant;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack currentStack) {
        super.setPlacedBy(world, pos, state, placer, currentStack);
        ItemStack stack = currentStack.copy();
        IDelay.forFrames(6, world.isClientSide(), () -> TileEntityUtils.delayUntilTileEntityExists((LevelAccessor)world, pos, PostTile.getBlockEntityType(), tile -> {
            tile.setSignpostOwner(Optional.of(PlayerHandle.from((Entity)placer)));
            boolean shouldAddNewSign = placer instanceof ServerPlayer;
            if (!world.isClientSide()) {
                PostData customData = (PostData)stack.get(PostData.TYPE);
                if (customData != null) {
                    tile.readData(customData);
                    shouldAddNewSign = false;
                    tile.getWaystonePart().ifPresent(waystone -> WaystoneBlock.registerOwnerAndSeeIfHasName(tile, world, pos, placer, stack));
                } else {
                    tile.addPart(new BlockPartInstance(new PostBlockPart(this.type.postTexture), Vector3.ZERO), ItemStack.EMPTY, PlayerHandle.from((Entity)placer));
                }
                tile.setChanged();
                world.sendBlockUpdated(pos, state, state, 3);
                if (shouldAddNewSign) {
                    PacketHandler.getInstance().sendToPlayer((ServerPlayer)placer, RequestSignGui.ForNewSign.Package.from(WorldLocation.from(pos, world), tile.modelType, new Vector3(0.0f, 1.0f, 0.0f), ItemStack.EMPTY));
                }
            }
        }, 100, Optional.of(() -> Signpost.LOGGER.error("Could not initialize placed signpost: BlockEntity never appeared."))));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getInteractionShape(state, world, pos);
    }

    protected VoxelShape getInteractionShape(BlockState state, BlockGetter level, BlockPos pos) {
        BlockEntity t = level.getBlockEntity(pos);
        return t instanceof PostTile ? ((PostTile)t).getBounds() : Shapes.empty();
    }

    protected VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getInteractionShape(state, level, pos);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PostTile(this.type, pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{Facing}).add(new Property[]{WATERLOGGED});
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.getShape(state, worldIn, pos, context);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return this.use(level, pos, player, InteractionHand.MAIN_HAND);
    }

    protected InteractionResult useItemOn(ItemStack item, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return this.use(level, blockPos, player, hand);
    }

    public InteractionResult use(Level world, BlockPos pos, Player player, InteractionHand hand) {
        InteractionResult.Success success;
        BlockEntity tileEntity = world.getBlockEntity(pos);
        if (tileEntity instanceof PostTile) {
            PostTile tile = (PostTile)tileEntity;
            success = PostBlock.onActivate(tile, world, player, hand);
        } else {
            success = InteractionResult.SUCCESS;
        }
        return success;
    }

    public static InteractionResult onActivate(PostTile tile, Level world, Player player, InteractionHand hand) {
        return switch (tile.trace((Entity)player).map(p -> p.part.blockPart().interact(new InteractionInfo(InteractionInfo.Type.RightClick, player, hand, tile, (PostTile.TraceResult)p, () -> tile.notifyMutation(p.id, p.part, p.part.blockPart().getMeta().identifier()), world.isClientSide()))).orElse(Interactable.InteractionResult.Ignored)) {
            default -> throw new MatchException(null, null);
            case Interactable.InteractionResult.Accepted -> InteractionResult.SUCCESS;
            case Interactable.InteractionResult.Ignored -> InteractionResult.PASS;
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState res = super.getStateForPlacement(context);
        if (res == null) {
            res = this.defaultBlockState();
        }
        return (BlockState)((BlockState)res.setValue(Facing, (Comparable)context.getHorizontalDirection())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
    }

    protected boolean propagatesSkylightDown(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        if (!state.hasProperty(Facing)) {
            return state;
        }
        return (BlockState)state.setValue(Facing, (Comparable)rot.rotate((Direction)state.getValue(Facing)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        if (!state.hasProperty(Facing)) {
            return state;
        }
        return (BlockState)state.setValue(Facing, (Comparable)((Direction)state.getValue(Facing)).getOpposite());
    }

    protected ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData) {
        ItemStack ret = super.getCloneItemStack(level, pos, state, includeData);
        if (!includeData) {
            return ret;
        }
        level.getBlockEntity(pos, PostTile.getBlockEntityType()).ifPresent(tile -> {
            PostData data = new PostData(tile.parts());
            ret.applyComponents(DataComponentPatch.builder().set(PostData.TYPE, (Object)data).build());
        });
        return ret;
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.fieldOf("variant").forGetter(block -> ((PostBlock)block).type.name)).apply((Applicative)builder, variantName -> AllVariants.stream().filter(v -> Objects.equals(v.type.name, variantName)).findAny().orElseThrow().createBlock((TriFunction<BlockBehaviour.Properties, ModelType, Variant, PostBlock>)((TriFunction)PostBlock::new))));
    }

    public static class ModelType {
        private static final Map<String, ModelType> allTypes = new HashMap<String, ModelType>();
        public static final Codec<ModelType> CODEC = Codec.STRING.xmap(allTypes::get, type -> type.name);
        public static final ModelType Acacia = new ModelType("acacia", ResourceLocation.parse((String)"acacia_log"), ResourceLocation.parse((String)"stripped_acacia_log"), ResourceLocation.parse((String)"acacia_log"), r -> Ingredient.of((ItemLike)Items.ACACIA_SIGN), r -> Ingredient.of((HolderSet)r.lookupOrThrow(Registries.ITEM).getOrThrow(ItemTags.ACACIA_LOGS)), r -> Ingredient.of((ItemLike)Items.ACACIA_SIGN));
        public static final ModelType Birch = new ModelType("birch", ResourceLocation.parse((String)"birch_log"), ResourceLocation.parse((String)"stripped_birch_log"), ResourceLocation.parse((String)"birch_log"), r -> Ingredient.of((ItemLike)Items.BIRCH_SIGN), r -> Ingredient.of((HolderSet)r.lookupOrThrow(Registries.ITEM).getOrThrow(ItemTags.BIRCH_LOGS)), r -> Ingredient.of((ItemLike)Items.BIRCH_SIGN));
        public static final ModelType Iron = new ModelType("iron", ResourceLocation.parse((String)"iron_block"), ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)"iron"), ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)"iron_dark"), r -> Ingredient.of((HolderSet)r.lookupOrThrow(Registries.ITEM).getOrThrow(ItemTags.SIGNS)), r -> Ingredient.of((ItemLike)Items.IRON_INGOT), r -> Ingredient.of((ItemLike)Items.IRON_INGOT));
        public static final ModelType Jungle = new ModelType("jungle", ResourceLocation.parse((String)"jungle_log"), ResourceLocation.parse((String)"stripped_jungle_log"), ResourceLocation.parse((String)"jungle_log"), r -> Ingredient.of((ItemLike)Items.JUNGLE_SIGN), r -> Ingredient.of((HolderSet)r.lookupOrThrow(Registries.ITEM).getOrThrow(ItemTags.JUNGLE_LOGS)), r -> Ingredient.of((ItemLike)Items.JUNGLE_SIGN));
        public static final ModelType Oak = new ModelType("oak", ResourceLocation.parse((String)"oak_log"), ResourceLocation.parse((String)"stripped_oak_log"), ResourceLocation.parse((String)"oak_log"), r -> Ingredient.of((ItemLike)Items.OAK_SIGN), r -> Ingredient.of((HolderSet)r.lookupOrThrow(Registries.ITEM).getOrThrow(ItemTags.OAK_LOGS)), r -> Ingredient.of((ItemLike)Items.OAK_SIGN));
        public static final ModelType DarkOak = new ModelType("darkoak", ResourceLocation.parse((String)"dark_oak_log"), ResourceLocation.parse((String)"stripped_dark_oak_log"), ResourceLocation.parse((String)"dark_oak_log"), r -> Ingredient.of((ItemLike)Items.DARK_OAK_SIGN), r -> Ingredient.of((HolderSet)r.lookupOrThrow(Registries.ITEM).getOrThrow(ItemTags.DARK_OAK_LOGS)), r -> Ingredient.of((ItemLike)Items.DARK_OAK_SIGN));
        public static final ModelType Spruce = new ModelType("spruce", ResourceLocation.parse((String)"spruce_log"), ResourceLocation.parse((String)"stripped_spruce_log"), ResourceLocation.parse((String)"spruce_log"), r -> Ingredient.of((ItemLike)Items.SPRUCE_SIGN), r -> Ingredient.of((HolderSet)r.lookupOrThrow(Registries.ITEM).getOrThrow(ItemTags.SPRUCE_LOGS)), r -> Ingredient.of((ItemLike)Items.SPRUCE_SIGN));
        public static final ModelType Mangrove = new ModelType("mangrove", ResourceLocation.parse((String)"mangrove_log"), ResourceLocation.parse((String)"stripped_mangrove_log"), ResourceLocation.parse((String)"mangrove_log"), r -> Ingredient.of((ItemLike)Items.MANGROVE_SIGN), r -> Ingredient.of((HolderSet)r.lookupOrThrow(Registries.ITEM).getOrThrow(ItemTags.MANGROVE_LOGS)), r -> Ingredient.of((ItemLike)Items.MANGROVE_SIGN));
        public static final ModelType Bamboo = new ModelType("bamboo", ResourceLocation.parse((String)"bamboo_block"), ResourceLocation.parse((String)"stripped_bamboo_block"), ResourceLocation.parse((String)"bamboo_block"), r -> Ingredient.of((ItemLike)Items.BAMBOO_SIGN), r -> Ingredient.of((HolderSet)r.lookupOrThrow(Registries.ITEM).getOrThrow(ItemTags.BAMBOO_BLOCKS)), r -> Ingredient.of((ItemLike)Items.BAMBOO_SIGN));
        public static final ModelType Cherry = new ModelType("cherry", ResourceLocation.parse((String)"cherry_log"), ResourceLocation.parse((String)"stripped_cherry_log"), ResourceLocation.parse((String)"cherry_log"), r -> Ingredient.of((ItemLike)Items.CHERRY_SIGN), r -> Ingredient.of((HolderSet)r.lookupOrThrow(Registries.ITEM).getOrThrow(ItemTags.CHERRY_LOGS)), r -> Ingredient.of((ItemLike)Items.CHERRY_SIGN));
        public static final ModelType Stone = new ModelType("stone", ResourceLocation.parse((String)"stone"), ResourceLocation.parse((String)"stone"), ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)"stone_dark"), r -> Ingredient.of((HolderSet)r.lookupOrThrow(Registries.ITEM).getOrThrow(ItemTags.SIGNS)), r -> Ingredient.of((ItemLike)Items.STONE), r -> Ingredient.of((ItemLike)Items.STONE));
        public static final ModelType RedMushroom = new ModelType("red_mushroom", ResourceLocation.parse((String)"red_mushroom_block"), ResourceLocation.parse((String)"mushroom_stem"), ResourceLocation.parse((String)"red_mushroom_block"), r -> Ingredient.of((HolderSet)r.lookupOrThrow(Registries.ITEM).getOrThrow(ItemTags.SIGNS)), r -> Ingredient.of((ItemLike)Items.RED_MUSHROOM_BLOCK), r -> Ingredient.of((ItemLike)Items.RED_MUSHROOM));
        public static final ModelType BrownMushroom = new ModelType("brown_mushroom", ResourceLocation.parse((String)"brown_mushroom_block"), ResourceLocation.parse((String)"mushroom_stem"), ResourceLocation.parse((String)"brown_mushroom_block"), r -> Ingredient.of((HolderSet)r.lookupOrThrow(Registries.ITEM).getOrThrow(ItemTags.SIGNS)), r -> Ingredient.of((ItemLike)Items.BROWN_MUSHROOM_BLOCK), r -> Ingredient.of((ItemLike)Items.BROWN_MUSHROOM));
        public static final ModelType Warped = new ModelType("warped", ResourceLocation.parse((String)"warped_stem"), ResourceLocation.parse((String)"stripped_warped_stem"), ResourceLocation.parse((String)"warped_stem"), r -> Ingredient.of((ItemLike)Items.WARPED_SIGN), r -> Ingredient.of((HolderSet)r.lookupOrThrow(Registries.ITEM).getOrThrow(ItemTags.WARPED_STEMS)), r -> Ingredient.of((ItemLike)Items.WARPED_SIGN));
        public static final ModelType Crimson = new ModelType("crimson", ResourceLocation.parse((String)"crimson_stem"), ResourceLocation.parse((String)"stripped_crimson_stem"), ResourceLocation.parse((String)"crimson_stem"), r -> Ingredient.of((ItemLike)Items.CRIMSON_SIGN), r -> Ingredient.of((HolderSet)r.lookupOrThrow(Registries.ITEM).getOrThrow(ItemTags.CRIMSON_STEMS)), r -> Ingredient.of((ItemLike)Items.CRIMSON_SIGN));
        private static final Ingredient sandstone = Ingredient.of((ItemLike[])new ItemLike[]{Blocks.SANDSTONE, Blocks.CUT_SANDSTONE, Blocks.CHISELED_SANDSTONE, Blocks.SMOOTH_SANDSTONE});
        public static final ModelType Sandstone = new ModelType("sandstone", ResourceLocation.parse((String)"sandstone"), ResourceLocation.parse((String)"stripped_jungle_log"), ResourceLocation.parse((String)"sandstone_bottom"), r -> Ingredient.of((HolderSet)r.lookupOrThrow(Registries.ITEM).getOrThrow(ItemTags.SIGNS)), r -> sandstone, r -> sandstone);
        public final String name;
        public final Texture postTexture;
        public final Texture mainTexture;
        public final Texture secondaryTexture;
        public final Function<HolderLookup.Provider, Ingredient> signIngredient;
        public final Function<HolderLookup.Provider, Ingredient> baseIngredient;
        public final Function<HolderLookup.Provider, Ingredient> addSignIngredient;
        private static final StreamCodec<RegistryFriendlyByteBuf, Function<HolderLookup.Provider, Ingredient>> ingredientGetterStreamCodec;
        public static final StreamCodec<RegistryFriendlyByteBuf, ModelType> STREAM_CODEC;

        public static void register(ModelType modelType, String name) {
            if (name.length() < 3 || name.length() > 30) {
                throw new IllegalArgumentException("ModelType name must be between 3 and 30 characters");
            }
            allTypes.put(name, modelType);
        }

        public static void register(ModelType modelType) {
            ModelType.register(modelType, modelType.name);
        }

        public static Optional<ModelType> getByName(String name, boolean logErrorIfNotPresent) {
            if (allTypes.containsKey(name)) {
                return Optional.of(allTypes.get(name));
            }
            if (logErrorIfNotPresent) {
                Signpost.LOGGER.error("Tried to get invalid model type " + name);
            }
            return Optional.empty();
        }

        public static Optional<ModelType> from(Item signItem, HolderLookup.Provider registryAccess) {
            return allTypes.values().stream().filter(t -> t.addSignIngredient.apply(registryAccess).test(new ItemStack((ItemLike)signItem))).findFirst();
        }

        ModelType(String name, ResourceLocation postTexture, ResourceLocation mainTexture, ResourceLocation secondaryTexture, Function<HolderLookup.Provider, Ingredient> signIngredient, Function<HolderLookup.Provider, Ingredient> baseIngredient, Function<HolderLookup.Provider, Ingredient> addSignIngredient) {
            this(name, ModelType.expand(postTexture), ModelType.expand(mainTexture), ModelType.expand(secondaryTexture), signIngredient, baseIngredient, addSignIngredient);
        }

        public ModelType(String name, Texture postTexture, Texture mainTexture, Texture secondaryTexture, Function<HolderLookup.Provider, Ingredient> signIngredient, Function<HolderLookup.Provider, Ingredient> baseIngredient, Function<HolderLookup.Provider, Ingredient> addSignIngredient) {
            this.name = name;
            this.postTexture = postTexture;
            this.mainTexture = mainTexture;
            this.secondaryTexture = secondaryTexture;
            this.signIngredient = signIngredient;
            this.baseIngredient = baseIngredient;
            this.addSignIngredient = addSignIngredient;
        }

        private static Texture expand(ResourceLocation loc) {
            return new Texture(ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)(loc.getPath().startsWith("block/") ? loc.getPath() : "block/" + loc.getPath())));
        }

        static {
            ModelType.register(Acacia);
            ModelType.register(Birch);
            ModelType.register(Iron);
            ModelType.register(Stone);
            ModelType.register(Jungle);
            ModelType.register(Oak);
            ModelType.register(DarkOak);
            ModelType.register(Spruce);
            ModelType.register(Mangrove);
            ModelType.register(Bamboo);
            ModelType.register(Cherry);
            ModelType.register(Warped);
            ModelType.register(Crimson);
            ModelType.register(Sandstone);
            ModelType.register(BrownMushroom);
            ModelType.register(RedMushroom);
            ingredientGetterStreamCodec = StreamCodec.of((buffer, i) -> Ingredient.CONTENTS_STREAM_CODEC.encode(buffer, (Object)((Ingredient)i.apply(buffer.registryAccess()))), buffer -> {
                Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(buffer);
                return r -> ingredient;
            });
            STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, mt -> mt.name, Texture.STREAM_CODEC, mt -> mt.postTexture, Texture.STREAM_CODEC, mt -> mt.mainTexture, Texture.STREAM_CODEC, mt -> mt.secondaryTexture, ingredientGetterStreamCodec, mt -> mt.signIngredient, ingredientGetterStreamCodec, mt -> mt.baseIngredient, ingredientGetterStreamCodec, mt -> mt.addSignIngredient, ModelType::new);
        }
    }

    public static class Variant {
        private PostBlock block = null;
        public final String registryName;
        public final BlockBehaviour.Properties properties;
        public final ModelType type;
        public final RequiredTool tool;

        public Variant(BlockBehaviour.Properties properties, ModelType type, String registryName, RequiredTool tool) {
            this.registryName = "post_" + registryName;
            this.properties = properties.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)this.registryName)));
            this.type = type;
            this.tool = tool;
        }

        public PostBlock createBlock(TriFunction<BlockBehaviour.Properties, ModelType, Variant, PostBlock> factory) {
            assert (this.block == null);
            this.block = (PostBlock)((Object)factory.apply((Object)this.properties, (Object)this.type, (Object)this));
            return this.block;
        }

        public PostBlock getBlock() {
            assert (this.block != null);
            return this.block;
        }

        public static enum RequiredTool {
            Axe,
            Pickaxe;

        }
    }
}

