/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.block;

import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;

public class PropertiesUtil {
    public static BlockBehaviour.Properties STONE = BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(1.5f, 6.0f).requiresCorrectToolForDrops();
    public static BlockBehaviour.Properties IRON = BlockBehaviour.Properties.of().mapColor(MapColor.METAL).instrument(NoteBlockInstrument.IRON_XYLOPHONE).requiresCorrectToolForDrops().strength(5.0f, 6.0f).sound(SoundType.METAL);

    private static BlockBehaviour.Properties wood(MapColor color) {
        return BlockBehaviour.Properties.of().mapColor(color).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD);
    }

    public static BlockBehaviour.Properties mushroom(MapColor color) {
        return BlockBehaviour.Properties.of().mapColor(color).instrument(NoteBlockInstrument.BASS).strength(0.2f).sound(SoundType.WOOD);
    }

    private static MapColor colorFor(WoodType type) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> MapColor.WOOD;
            case 1 -> MapColor.COLOR_BROWN;
            case 2 -> MapColor.PODZOL;
            case 3 -> MapColor.SAND;
            case 4 -> MapColor.DIRT;
            case 5 -> MapColor.COLOR_ORANGE;
            case 6 -> MapColor.COLOR_RED;
            case 7 -> MapColor.COLOR_YELLOW;
            case 8 -> MapColor.TERRACOTTA_WHITE;
            case 9 -> MapColor.WARPED_STEM;
            case 10 -> MapColor.CRIMSON_STEM;
        };
    }

    public static BlockBehaviour.Properties wood(WoodType type) {
        return PropertiesUtil.wood(PropertiesUtil.colorFor(type));
    }

    public static enum WoodType {
        Oak,
        DarkOak,
        Spruce,
        Birch,
        Jungle,
        Acacia,
        Mangrove,
        Bamboo,
        Cherry,
        Warped,
        Crimson;

    }
}

