/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.block.tiles;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Codec;
import gollorum.signpost.PlayerHandle;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.events.WaystoneUpdatedEvent;
import gollorum.signpost.minecraft.block.ModelWaystone;
import gollorum.signpost.minecraft.block.WaystoneBlock;
import gollorum.signpost.minecraft.data.WaystoneHandleData;
import gollorum.signpost.platform.Services;
import gollorum.signpost.security.WithOwner;
import gollorum.signpost.utils.EventDispatcher;
import gollorum.signpost.utils.IDelay;
import gollorum.signpost.utils.WaystoneContainer;
import gollorum.signpost.utils.WaystoneData;
import gollorum.signpost.utils.WorldLocation;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class WaystoneTile
extends BlockEntity
implements WithOwner.OfWaystone,
WaystoneContainer {
    public static final String REGISTRY_NAME = "waystone";
    private static BlockEntityType<WaystoneTile> type = null;
    private Optional<PlayerHandle> owner = Optional.empty();
    private Optional<WaystoneHandle.Vanilla> handle = Optional.empty();
    private Optional<String> name = Optional.empty();
    private final EventDispatcher.Listener<WaystoneUpdatedEvent> updateListener = event -> {
        if (WorldLocation.from(this).map(loc -> loc.equals(event.location.block())).orElse(false).booleanValue()) {
            this.name = Optional.of(event.name);
            this.handle = Optional.of(event.handle);
        }
        return false;
    };

    public static BlockEntityType<WaystoneTile> createType() {
        assert (type == null);
        Type type = Util.fetchChoiceType((DSL.TypeReference)References.BLOCK_ENTITY, (String)REGISTRY_NAME);
        ArrayList<BaseEntityBlock> blocks = new ArrayList<BaseEntityBlock>();
        blocks.add(WaystoneBlock.getInstance());
        for (ModelWaystone.Variant variant : ModelWaystone.variants) {
            blocks.add(variant.getBlock());
        }
        WaystoneTile.type = Services.BLOCK_ENTITY_TYPE_FACTORY.create(WaystoneTile::new, (Block[])blocks.toArray(Block[]::new), type);
        return WaystoneTile.type;
    }

    public static BlockEntityType<WaystoneTile> getBlockEntityType() {
        assert (type != null);
        return type;
    }

    public Optional<WaystoneHandle.Vanilla> getHandle() {
        return this.handle;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public WaystoneTile(BlockPos pos, BlockState state) {
        super(WaystoneTile.getBlockEntityType(), pos, state);
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        IDelay.forFrames(10, level.isClientSide(), () -> {
            WaystoneLibrary.getInstance().requestWaystoneAt(WorldLocation.from(this.getBlockPos(), level), data -> {
                this.handle = data.map(WaystoneData::handle);
                this.name = data.map(WaystoneData::name);
            }, level.isClientSide());
            WaystoneLibrary.getInstance().updateEventDispatcher.addListener(this.updateListener);
        });
    }

    public static void onRemoved(ServerLevel world, BlockPos pos) {
        WaystoneLibrary.getInstance().removeAt(WorldLocation.from(pos, (Level)world), PlayerHandle.Invalid);
    }

    @Override
    public Optional<PlayerHandle> getWaystoneOwner() {
        return this.owner;
    }

    @Override
    public void setWaystoneOwner(Optional<PlayerHandle> owner) {
        this.owner = owner;
    }

    public void saveAdditional(ValueOutput output) {
        output.store(PlayerHandle.DIRECT_CODEC.optionalFieldOf("Owner"), this.owner);
    }

    protected void loadAdditional(ValueInput input) {
        this.owner = input.read(Codec.optionalField((String)"Owner", PlayerHandle.DIRECT_CODEC, (boolean)true)).flatMap(it -> it);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        this.handle.ifPresent(h -> components.set(WaystoneHandleData.TYPE, (Object)new WaystoneHandleData((WaystoneHandle.Vanilla)h)));
        this.name.ifPresent(n -> components.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)n)));
    }
}

