/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import gollorum.signpost.PlayerHandle;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.minecraft.commands.WaystoneArgument;
import gollorum.signpost.minecraft.config.IConfig;
import gollorum.signpost.minecraft.gui.utils.Colors;
import gollorum.signpost.minecraft.utils.TextComponents;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class DiscoverWaystone {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"discover").requires(source -> source.hasPermission(IConfig.IServer.getInstance().permissions().discoverPermissionLevel()))).then(((RequiredArgumentBuilder)Commands.argument((String)"waystone", (ArgumentType)new WaystoneArgument()).requires(source -> {
            try {
                source.getPlayerOrException();
                return true;
            }
            catch (CommandSyntaxException e) {
                return false;
            }
        })).executes(context -> DiscoverWaystone.execute((String)context.getArgument("waystone", String.class), ((CommandSourceStack)context.getSource()).getPlayerOrException())))).then(Commands.argument((String)"waystone", (ArgumentType)new WaystoneArgument()).then(Commands.argument((String)"sender", (ArgumentType)EntityArgument.player()).executes(context -> DiscoverWaystone.execute((String)context.getArgument("waystone", String.class), EntityArgument.getPlayer((CommandContext)context, (String)"sender")))));
    }

    private static int execute(String name, ServerPlayer player) throws CommandSyntaxException {
        WaystoneHandle.Vanilla handle = WaystoneLibrary.getInstance().getHandleByName(name).orElseThrow(() -> new SimpleCommandExceptionType((Message)Component.translatable((String)"signpost.waystone_not_found", (Object[])new Object[]{Colors.wrap(name, Colors.highlight)})).create());
        if (WaystoneLibrary.getInstance().addDiscovered(new PlayerHandle((Entity)player), handle)) {
            player.sendSystemMessage((Component)Component.translatable((String)"signpost.discovered", (Object[])new Object[]{TextComponents.waystone(player, name)}));
        }
        return 1;
    }
}

