/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.crafting;

import gollorum.signpost.minecraft.block.ModelWaystone;
import gollorum.signpost.minecraft.config.IConfig;
import gollorum.signpost.minecraft.data.WaystoneHandleData;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.SingleItemRecipe;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class CutWaystoneRecipe
extends StonecutterRecipe {
    public static final String RegistryName = "cut_waystone";

    public CutWaystoneRecipe(String group, Ingredient ingredient, ItemStack result) {
        super(group, ingredient, result);
    }

    public boolean matches(SingleRecipeInput inv, Level world) {
        return super.matches(inv, world) && CutWaystoneRecipe.isAllowed(this.result());
    }

    private static boolean isAllowed(ItemStack result) {
        if (!(result.getItem() instanceof BlockItem)) {
            return true;
        }
        Block block = ((BlockItem)result.getItem()).getBlock();
        if (!(block instanceof ModelWaystone)) {
            return true;
        }
        return IConfig.IServer.getInstance().allowedWaystones().contains(((ModelWaystone)block).variant.name);
    }

    @NotNull
    public ItemStack assemble(SingleRecipeInput container, HolderLookup.Provider registryAccess) {
        ItemStack ret = super.assemble(container, registryAccess);
        ItemStack ingred = container.getItem(0);
        if (ingred.has(WaystoneHandleData.TYPE)) {
            WaystoneHandleData data = (WaystoneHandleData)ingred.get(WaystoneHandleData.TYPE);
            ret.set(WaystoneHandleData.TYPE, (Object)data);
        }
        return ret;
    }

    public static class Serializer
    extends SingleItemRecipe.Serializer<CutWaystoneRecipe> {
        public Serializer() {
            super(CutWaystoneRecipe::new);
        }
    }
}

