/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import gollorum.signpost.PlayerHandle;
import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.blockpartdata.Overlay;
import gollorum.signpost.blockpartdata.types.LargeSignBlockPart;
import gollorum.signpost.blockpartdata.types.PostBlockPart;
import gollorum.signpost.blockpartdata.types.SignBlockPart;
import gollorum.signpost.blockpartdata.types.SmallShortSignBlockPart;
import gollorum.signpost.blockpartdata.types.SmallWideSignBlockPart;
import gollorum.signpost.compat.ExternalWaystoneLibrary;
import gollorum.signpost.events.WaystoneRenamedEvent;
import gollorum.signpost.events.WaystoneUpdatedEvent;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.gui.utils.Flippable;
import gollorum.signpost.minecraft.gui.utils.FlippableAtPivot;
import gollorum.signpost.minecraft.gui.utils.IColorableButton;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.gui.utils.TextureResource;
import gollorum.signpost.minecraft.gui.utils.TextureSize;
import gollorum.signpost.minecraft.gui.utils.WaystoneEntry;
import gollorum.signpost.minecraft.gui.widgets.AngleInputBox;
import gollorum.signpost.minecraft.gui.widgets.ColorInputBox;
import gollorum.signpost.minecraft.gui.widgets.DropDownSelection;
import gollorum.signpost.minecraft.gui.widgets.GuiItemRenderer;
import gollorum.signpost.minecraft.gui.widgets.GuiModelRenderer;
import gollorum.signpost.minecraft.gui.widgets.ImageInputBox;
import gollorum.signpost.minecraft.gui.widgets.InputBox;
import gollorum.signpost.minecraft.gui.widgets.ModelButton;
import gollorum.signpost.minecraft.gui.widgets.SignpostImageButton;
import gollorum.signpost.minecraft.gui.widgets.TextDisplay;
import gollorum.signpost.minecraft.models.LargeSignModel;
import gollorum.signpost.minecraft.models.PostModel;
import gollorum.signpost.minecraft.models.ShortSignModel;
import gollorum.signpost.minecraft.models.WideSignModel;
import gollorum.signpost.minecraft.rendering.FlippableModel;
import gollorum.signpost.minecraft.rendering.TexturedModel;
import gollorum.signpost.minecraft.utils.Texture;
import gollorum.signpost.mixin.ScreenAccessor;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.utils.AngleProvider;
import gollorum.signpost.utils.BlockPart;
import gollorum.signpost.utils.BlockPartInstance;
import gollorum.signpost.utils.IDelay;
import gollorum.signpost.utils.NameProvider;
import gollorum.signpost.utils.Tint;
import gollorum.signpost.utils.Tuple;
import gollorum.signpost.utils.WaystoneLocationData;
import gollorum.signpost.utils.math.Angle;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.LockIconButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;

public class SignGui
extends Screen {
    private static final TextureSize typeSelectionButtonsTextureSize = TextureResource.signTypeSelection.size;
    private static final TextureResource waystoneNameTexture = TextureResource.waystoneNameField;
    private static final TextureSize typeSelectionButtonsSize = new TextureSize(SignGui.typeSelectionButtonsTextureSize.width * 2, SignGui.typeSelectionButtonsTextureSize.height * 2);
    private static final int typeSelectionButtonsSpace = (int)((float)SignGui.typeSelectionButtonsSize.width * 0.3f);
    private static final int typeSelectionButtonsY = 15;
    private static final float typeSelectionButtonsScale = 0.66f;
    private static final float overlayButtonsScale = 0.5f;
    private static final int centralAreaHeight = 110;
    private static final int centerGap = 15;
    private static final float waystoneBoxScale = 2.5f;
    final int inputSignsScale = 5;
    private ImageInputBox waystoneInputBox;
    private DropDownSelection<WaystoneEntry> waystoneDropdown;
    private LockIconButton lockButton;
    private DropDownSelection<AngleSelectionEntry> angleDropDown;
    private TextDisplay rotationLabel;
    private AngleInputBox rotationInputField;
    private final Optional<ItemStack> itemToDropOnBreak;
    private final Consumer<WaystoneUpdatedEvent> waystoneUpdateListener = event -> {
        WaystoneEntry newEntry = new WaystoneEntry(event.name, event.name, event.handle, event.location.block().blockPos());
        switch (event.getType()) {
            case Added: {
                this.waystoneDropdown.addEntry(newEntry);
                this.onWaystoneCountChanged();
                break;
            }
            case Removed: {
                this.waystoneDropdown.removeEntry(newEntry);
                this.onWaystoneCountChanged();
                break;
            }
            case Renamed: {
                String oldName = ((WaystoneRenamedEvent)event).oldName;
                WaystoneEntry oldEntry = new WaystoneEntry(oldName, oldName, event.handle, event.location.block().blockPos());
                this.waystoneDropdown.removeEntry(oldEntry);
                this.waystoneDropdown.addEntry(newEntry);
            }
        }
    };
    private static final TextureSize buttonsSize = new TextureSize(98, 20);
    private SignType selectedType = null;
    private final PostTile tile;
    private final ItemStack itemStack;
    private final PostBlock.ModelType modelType;
    private final Vector3 localHitPos;
    private final Optional<SignBlockPart> oldSign;
    private final Optional<PostTile.TilePartInfo> oldTilePartInfo;
    private final List<Flippable> widgetsToFlip = new ArrayList<Flippable>();
    private InputBox wideSignInputBox;
    private InputBox shortSignInputBox;
    private List<InputBox> largeSignInputBoxes;
    private List<InputBox> allSignInputBoxes;
    private GuiModelRenderer wideSignRenderer;
    private GuiModelRenderer shortSignRenderer;
    private GuiModelRenderer largeSignRenderer;
    private GuiModelRenderer currentSignRenderer;
    private InputBox currentSignInputBox;
    private ColorInputBox colorInputBox;
    private Optional<WaystoneEntry> lastWaystone = Optional.empty();
    private AngleSelectionEntry waystoneRotationEntry;
    private Optional<Overlay> selectedOverlay;
    private final List<ModelButton> overlaySelectionButtons = new ArrayList<ModelButton>();
    private boolean hasBeenInitialized = false;
    private TextDisplay noWaystonesInfo;
    private final List<AbstractWidget> selectionDependentWidgets = Lists.newArrayList();
    private GuiModelRenderer currentOverlay;
    private boolean isClosed = false;

    public static void display(PostTile tile, PostBlock.ModelType modelType, Vector3 localHitPos, Optional<ItemStack> itemToDropOnBreak) {
        Minecraft.getInstance().setScreen((Screen)new SignGui(tile, modelType, localHitPos, itemToDropOnBreak));
    }

    public static void display(PostTile tile, SignBlockPart oldSign, Vector3 oldOffset, PostTile.TilePartInfo oldTilePartInfo) {
        if (oldSign.hasThePermissionToEdit(tile, (Player)Minecraft.getInstance().player)) {
            Minecraft.getInstance().setScreen((Screen)new SignGui(tile, oldSign, oldOffset, oldTilePartInfo));
        }
    }

    public SignGui(PostTile tile, PostBlock.ModelType modelType, Vector3 localHitPos, Optional<ItemStack> itemToDropOnBreak) {
        super((Component)Component.translatable((String)"gui.signpost.sign_gui_title"));
        this.tile = tile;
        this.modelType = modelType;
        this.localHitPos = localHitPos;
        this.itemToDropOnBreak = itemToDropOnBreak;
        this.oldSign = Optional.empty();
        this.oldTilePartInfo = Optional.empty();
        this.itemStack = new ItemStack((ItemLike)tile.getBlockState().getBlock().asItem());
    }

    public SignGui(PostTile tile, SignBlockPart oldSign, Vector3 oldOffset, PostTile.TilePartInfo oldTilePartInfo) {
        super((Component)Component.translatable((String)"gui.signpost.sign_gui_title"));
        this.tile = tile;
        this.modelType = oldSign.getModelType();
        this.localHitPos = oldOffset;
        this.itemToDropOnBreak = oldSign.getItemToDropOnBreak();
        this.oldSign = Optional.of(oldSign);
        this.oldTilePartInfo = Optional.of(oldTilePartInfo);
        this.itemStack = new ItemStack((ItemLike)tile.getBlockState().getBlock().asItem());
    }

    protected void init() {
        Button doneButton;
        Angle currentAngle;
        int currentColor;
        boolean isFlipped;
        NameProvider[] currentText;
        String currentWaystone;
        SignType currentType;
        this.isClosed = false;
        if (this.hasBeenInitialized) {
            NameProvider[] nameProviderArray;
            currentType = this.selectedType;
            currentWaystone = this.waystoneInputBox.getValue();
            switch (currentType.ordinal()) {
                case 1: {
                    NameProvider[] nameProviderArray2 = new NameProvider[1];
                    nameProviderArray = nameProviderArray2;
                    nameProviderArray2[0] = this.asNameProvider(this.shortSignInputBox.getValue());
                    break;
                }
                case 2: {
                    nameProviderArray = (NameProvider[])this.largeSignInputBoxes.stream().map(EditBox::getValue).map(this::asNameProvider).toArray(NameProvider[]::new);
                    break;
                }
                default: {
                    NameProvider[] nameProviderArray3 = new NameProvider[1];
                    nameProviderArray = nameProviderArray3;
                    nameProviderArray3[0] = this.asNameProvider(this.wideSignInputBox.getValue());
                }
            }
            currentText = nameProviderArray;
            isFlipped = this.widgetsToFlip.get(0).isFlipped();
            this.widgetsToFlip.clear();
            currentColor = this.colorInputBox.getCurrentColor();
            currentAngle = this.rotationInputField.getCurrentAngle();
        } else {
            currentWaystone = "";
            if (this.oldSign.isPresent()) {
                if (this.oldSign.get() instanceof LargeSignBlockPart) {
                    currentType = SignType.Large;
                    LargeSignBlockPart sign = (LargeSignBlockPart)this.oldSign.get();
                    currentText = sign.getText();
                } else if (this.oldSign.get() instanceof SmallShortSignBlockPart) {
                    currentType = SignType.Short;
                    currentText = new NameProvider[]{((SmallShortSignBlockPart)this.oldSign.get()).getText()};
                } else {
                    currentType = SignType.Wide;
                    currentText = new NameProvider[]{((SmallWideSignBlockPart)this.oldSign.get()).getText()};
                }
                isFlipped = this.oldSign.get().isFlipped();
                currentColor = this.oldSign.get().getColor();
                currentAngle = this.oldSign.get().getAngle().get();
                this.selectedOverlay = this.oldSign.get().getOverlay();
            } else {
                currentType = SignType.Wide;
                currentText = new NameProvider[]{new NameProvider.Literal("")};
                isFlipped = true;
                currentColor = 0;
                currentAngle = Angle.ZERO;
                this.selectedOverlay = Optional.empty();
            }
        }
        super.init();
        this.selectedType = null;
        int signTypeSelectionTopY = 15;
        int centerOffset = (SignGui.typeSelectionButtonsSize.width + typeSelectionButtonsSpace) / 2;
        Texture postTexture = this.tile.getParts().stream().filter(p -> p.blockPart() instanceof PostBlockPart).map(p -> ((PostBlockPart)p.blockPart()).getTexture()).findFirst().orElse(this.tile.modelType.postTexture);
        Texture mainTexture = this.oldSign.map(SignBlockPart::getMainTexture).orElse(this.modelType.mainTexture);
        Texture secondaryTexture = this.oldSign.map(SignBlockPart::getSecondaryTexture).orElse(this.modelType.secondaryTexture);
        FlippableModel postModel = FlippableModel.fromSymmetric(new TexturedModel[]{new TexturedModel(PostModel.MODEL, postTexture.toMaterial(), this.colorFrom(postTexture.tint()))});
        FlippableModel wideModel = FlippableModel.from(new TexturedModel[]{new TexturedModel(WideSignModel.MODEL_MAIN, mainTexture.toMaterial(), this.colorFrom(mainTexture.tint())), new TexturedModel(WideSignModel.MODEL_SECONDARY, secondaryTexture.toMaterial(), this.colorFrom(secondaryTexture.tint()))}, new TexturedModel[]{new TexturedModel(WideSignModel.MODEL_MAIN_FLIPPED, mainTexture.toMaterial(), this.colorFrom(mainTexture.tint())), new TexturedModel(WideSignModel.MODEL_SECONDARY_FLIPPED, secondaryTexture.toMaterial(), this.colorFrom(secondaryTexture.tint()))});
        FlippableModel shortModel = FlippableModel.from(new TexturedModel[]{new TexturedModel(ShortSignModel.MODEL_MAIN, mainTexture.toMaterial(), this.colorFrom(mainTexture.tint())), new TexturedModel(ShortSignModel.MODEL_SECONDARY, secondaryTexture.toMaterial(), this.colorFrom(secondaryTexture.tint()))}, new TexturedModel[]{new TexturedModel(ShortSignModel.MODEL_MAIN_FLIPPED, mainTexture.toMaterial(), this.colorFrom(mainTexture.tint())), new TexturedModel(ShortSignModel.MODEL_SECONDARY_FLIPPED, secondaryTexture.toMaterial(), this.colorFrom(secondaryTexture.tint()))});
        FlippableModel largeModel = FlippableModel.from(new TexturedModel[]{new TexturedModel(LargeSignModel.MODEL_MAIN, mainTexture.toMaterial(), this.colorFrom(mainTexture.tint())), new TexturedModel(LargeSignModel.MODEL_SECONDARY, secondaryTexture.toMaterial(), this.colorFrom(secondaryTexture.tint()))}, new TexturedModel[]{new TexturedModel(LargeSignModel.MODEL_MAIN_FLIPPED, mainTexture.toMaterial(), this.colorFrom(mainTexture.tint())), new TexturedModel(LargeSignModel.MODEL_SECONDARY_FLIPPED, secondaryTexture.toMaterial(), this.colorFrom(secondaryTexture.tint()))});
        this.addRenderableWidget((GuiEventListener)new ModelButton(TextureResource.signTypeSelection, new Point(this.getCenterX() - centerOffset, signTypeSelectionTopY), 0.66f, Rect.XAlignment.Center, Rect.YAlignment.Top, rect -> rect.withPoint(p -> p.add(-4, 0)).scaleCenter(0.75f), this::switchToWide, new ModelButton.ModelData(postModel, 0.0f, -0.5f, this.itemStack), new ModelButton.ModelData(wideModel, 0.0f, 0.25f, this.itemStack)));
        this.addRenderableWidget((GuiEventListener)new ModelButton(TextureResource.signTypeSelection, new Point(this.getCenterX(), signTypeSelectionTopY), 0.66f, Rect.XAlignment.Center, Rect.YAlignment.Top, rect -> rect.withPoint(p -> p.add(-11, 0)).scaleCenter(0.75f), this::switchToShort, new ModelButton.ModelData(postModel, 0.0f, -0.5f, this.itemStack), new ModelButton.ModelData(shortModel, 0.0f, 0.25f, this.itemStack)));
        this.addRenderableWidget((GuiEventListener)new ModelButton(TextureResource.signTypeSelection, new Point(this.getCenterX() + centerOffset, signTypeSelectionTopY), 0.66f, Rect.XAlignment.Center, Rect.YAlignment.Top, rect -> rect.withPoint(p -> p.add(-3, 0)).scaleCenter(0.75f), this::switchToLarge, new ModelButton.ModelData(postModel, 0.0f, -0.5f, this.itemStack), new ModelButton.ModelData(largeModel, 0.0f, 0.0f, this.itemStack)));
        Rect doneRect = new Rect(new Point(this.getCenterX(), this.height - 15), buttonsSize, Rect.XAlignment.Center, Rect.YAlignment.Bottom);
        if (this.oldSign.isPresent()) {
            int buttonsWidth = doneRect.width;
            doneButton = Button.builder((Component)Component.translatable((String)"gui.done"), b -> this.done()).bounds(this.getCenterX() + 7, doneRect.point.y, buttonsWidth, doneRect.height).build();
            Button removeSignButton = Button.builder((Component)Component.translatable((String)"gui.signpost.remove_sign"), b -> this.removeSign()).bounds(this.getCenterX() - 7 - buttonsWidth, doneRect.point.y, buttonsWidth, doneRect.height).build();
            ((IColorableButton)removeSignButton).signpost$overrideColor(-48060);
            this.addRenderableWidget((GuiEventListener)removeSignButton);
        } else {
            doneButton = Button.builder((Component)Component.translatable((String)"gui.done"), b -> this.done()).bounds(doneRect.point.x, doneRect.point.y, doneRect.width, doneRect.height).build();
        }
        this.addRenderableWidget((GuiEventListener)doneButton);
        this.lockButton = new LockIconButton(this.getCenterX() - 10, doneRect.point.y - 30, b -> this.lockButton.setLocked(!this.lockButton.isLocked()));
        this.lockButton.setLocked(this.oldSign.map(SignBlockPart::isLocked).orElse(false).booleanValue());
        this.addRenderableWidget((GuiEventListener)this.lockButton);
        Collection<Object> waystoneDropdownEntry = this.hasBeenInitialized ? this.waystoneDropdown.getAllEntries() : new HashSet();
        this.waystoneDropdown = new DropDownSelection<WaystoneEntry>(this.font, new Point(this.getCenterX() - 15, this.getCenterY() - 55 + 20), Rect.XAlignment.Right, Rect.YAlignment.Center, (int)((float)SignGui.waystoneNameTexture.size.width * 2.5f) + 3 + DropDownSelection.size.width, 100, (int)((float)SignGui.waystoneNameTexture.size.height * 2.5f - (float)DropDownSelection.size.height) / 2, e -> {
            this.addWidget((GuiEventListener)e);
            this.hideStuffOccludedByWaystoneDropdown();
        }, o -> {
            this.removeWidget((GuiEventListener)o);
            this.showStuffOccludedByWaystoneDropdown();
        }, entry -> {
            this.waystoneInputBox.setValue(entry.entryName);
            this.waystoneDropdown.hideList();
        });
        this.waystoneDropdown.setEntries(waystoneDropdownEntry);
        Rect waystoneInputRect = new Rect(new Point(this.waystoneDropdown.getX() - 10, this.waystoneDropdown.getY() + this.waystoneDropdown.getHeight() / 2), new TextureSize((int)((float)(SignGui.waystoneNameTexture.size.width - 4) * 2.5f), (int)((float)(SignGui.waystoneNameTexture.size.height - 4) * 2.5f)), Rect.XAlignment.Right, Rect.YAlignment.Center);
        this.waystoneInputBox = new ImageInputBox(this.font, waystoneInputRect, new Rect(new Point(-4, 0), SignGui.waystoneNameTexture.size.scale(2.5f), Rect.XAlignment.Center, Rect.YAlignment.Center), Rect.XAlignment.Center, Rect.YAlignment.Center, waystoneNameTexture, true, 100.0);
        this.waystoneInputBox.setMaxLength(200);
        this.waystoneInputBox.setResponder(this::onWaystoneSelected);
        this.noWaystonesInfo = new TextDisplay((Component)Component.translatable((String)"signpost.no_waystones"), this.waystoneDropdown.rect.max(), Rect.XAlignment.Right, Rect.YAlignment.Bottom, this.font);
        int rotationLabelStringWidth = this.font.width(I18n.get((String)"gui.signpost.rotation_label", (Object[])new Object[0]));
        int rotationLabelWidth = Math.min(rotationLabelStringWidth, this.waystoneInputBox.width() / 2);
        Rect rotationInputBoxRect = waystoneInputRect.offset(new Point(rotationLabelWidth + 10, waystoneInputRect.height + 20), new Point(0, waystoneInputRect.height + 20));
        this.rotationInputField = new AngleInputBox(this.font, rotationInputBoxRect, 0.0);
        this.addRenderableWidget((GuiEventListener)this.rotationInputField);
        this.angleDropDown = new DropDownSelection<AngleSelectionEntry>(this.font, new Point(this.getCenterX() - 15, rotationInputBoxRect.center().y), Rect.XAlignment.Right, Rect.YAlignment.Center, (int)((float)SignGui.waystoneNameTexture.size.width * 2.5f) + DropDownSelection.size.width, 75, (int)((float)SignGui.waystoneNameTexture.size.height * 2.5f - (float)DropDownSelection.size.height) / 2, e -> {
            this.addWidget((GuiEventListener)e);
            for (AbstractWidget abstractWidget : this.overlaySelectionButtons) {
                this.removeWidget((GuiEventListener)abstractWidget);
            }
        }, o -> {
            this.removeWidget((GuiEventListener)o);
            for (AbstractWidget abstractWidget : this.overlaySelectionButtons) {
                this.addRenderableWidget((GuiEventListener)abstractWidget);
            }
        }, entry -> {
            this.rotationInputField.setValue(entry.angleToString());
            this.angleDropDown.hideList();
        });
        this.angleDropDown.setEntries(new HashSet());
        this.angleDropDown.addEntry(this.angleEntryForPlayer());
        this.addRenderableWidget((GuiEventListener)this.angleDropDown);
        this.rotationLabel = new TextDisplay((Component)Component.translatable((String)"gui.signpost.rotation_label"), rotationInputBoxRect.at(Rect.XAlignment.Left, Rect.YAlignment.Center).add(-10, 0), Rect.XAlignment.Right, Rect.YAlignment.Center, this.font);
        this.addRenderableOnly(this.rotationLabel);
        Rect modelRect = new Rect(new Point(this.getCenterX() + 15 + 15, this.getCenterY() - 55), new TextureSize(22, 16).scale(5.0f), Rect.XAlignment.Left, Rect.YAlignment.Top);
        GuiModelRenderer postRenderer = new GuiModelRenderer(modelRect, postModel, 0.0f, -0.5f);
        this.addRenderableOnly(postRenderer);
        Point modelRectTop = modelRect.at(Rect.XAlignment.Center, Rect.YAlignment.Top);
        int inputBoxesZOffset = 100;
        Rect wideInputRect = new Rect(modelRectTop.add(-35, 10), modelRectTop.add(55, 30));
        this.wideSignInputBox = new InputBox(this.font, wideInputRect, false, 100.0);
        this.wideSignInputBox.setBordered(false);
        this.wideSignInputBox.setTextColor(-16777216);
        this.widgetsToFlip.add(new FlippableAtPivot(this.wideSignInputBox, modelRectTop.x));
        this.wideSignRenderer = new GuiModelRenderer(modelRect, wideModel, 0.0f, 0.24f);
        this.widgetsToFlip.add(this.wideSignRenderer);
        Rect shortInputRect = new Rect(modelRectTop.add(15, 10), modelRectTop.add(70, 30));
        this.shortSignInputBox = new InputBox(this.font, shortInputRect, false, 100.0);
        this.shortSignInputBox.setBordered(false);
        this.shortSignInputBox.setTextColor(-16777216);
        this.widgetsToFlip.add(new FlippableAtPivot(this.shortSignInputBox, modelRectTop.x));
        this.shortSignRenderer = new GuiModelRenderer(modelRect, shortModel, 0.0f, 0.24f);
        this.widgetsToFlip.add(this.shortSignRenderer);
        Rect largeInputRect = new Rect(modelRectTop.add(-35, 15), modelRectTop.add(45, 70)).withHeight(height -> height / 4 - 1);
        InputBox firstLarge = new InputBox(this.font, largeInputRect, false, 100.0);
        firstLarge.setBordered(false);
        firstLarge.setTextColor(-16777216);
        largeInputRect = largeInputRect.withPoint(p -> p.withY(Math.round((float)modelRectTop.y + 27.5f)));
        InputBox secondLarge = new InputBox(this.font, largeInputRect, false, 100.0);
        secondLarge.setBordered(false);
        secondLarge.setTextColor(-16777216);
        largeInputRect = largeInputRect.withPoint(p -> p.withY(Math.round((float)modelRectTop.y + 40.0f)));
        InputBox thirdLarge = new InputBox(this.font, largeInputRect, false, 100.0);
        thirdLarge.setBordered(false);
        thirdLarge.setTextColor(-16777216);
        largeInputRect = largeInputRect.withPoint(p -> p.withY(Math.round((float)modelRectTop.y + 52.5f)));
        InputBox fourthLarge = new InputBox(this.font, largeInputRect, false, 100.0);
        fourthLarge.setBordered(false);
        fourthLarge.setTextColor(-16777216);
        firstLarge.addKeyCodeListener(264, () -> this.setInitialFocus((GuiEventListener)secondLarge));
        secondLarge.addKeyCodeListener(265, () -> this.setInitialFocus((GuiEventListener)firstLarge));
        secondLarge.addKeyCodeListener(264, () -> this.setInitialFocus((GuiEventListener)thirdLarge));
        thirdLarge.addKeyCodeListener(265, () -> this.setInitialFocus((GuiEventListener)secondLarge));
        thirdLarge.addKeyCodeListener(264, () -> this.setInitialFocus((GuiEventListener)fourthLarge));
        fourthLarge.addKeyCodeListener(265, () -> this.setInitialFocus((GuiEventListener)thirdLarge));
        this.widgetsToFlip.add(new FlippableAtPivot(firstLarge, modelRectTop.x));
        this.widgetsToFlip.add(new FlippableAtPivot(secondLarge, modelRectTop.x));
        this.widgetsToFlip.add(new FlippableAtPivot(thirdLarge, modelRectTop.x));
        this.widgetsToFlip.add(new FlippableAtPivot(fourthLarge, modelRectTop.x));
        this.largeSignRenderer = new GuiModelRenderer(modelRect, largeModel, 0.0f, -0.01f);
        this.widgetsToFlip.add(this.largeSignRenderer);
        this.largeSignInputBoxes = ImmutableList.of((Object)firstLarge, (Object)secondLarge, (Object)thirdLarge, (Object)fourthLarge);
        this.allSignInputBoxes = ImmutableList.of((Object)this.wideSignInputBox, (Object)this.shortSignInputBox, (Object)firstLarge, (Object)secondLarge, (Object)thirdLarge, (Object)fourthLarge);
        SignpostImageButton switchDirectionButton = SignGui.newImageButton(TextureResource.flipDirection, 0, new Point(modelRect.point.x, modelRect.max().y + 15), 1.0f, Rect.XAlignment.Left, Rect.YAlignment.Top, this::flip);
        this.addRenderableWidget((GuiEventListener)switchDirectionButton);
        this.colorInputBox = new ColorInputBox(this.font, new Rect(new Point(switchDirectionButton.getX() + switchDirectionButton.getWidth() + 20, switchDirectionButton.getY() + switchDirectionButton.getHeight() / 2), 80, 20, Rect.XAlignment.Left, Rect.YAlignment.Center), 0.0);
        this.colorInputBox.setColorResponder(color -> this.allSignInputBoxes.forEach(b -> b.setTextColor(color)));
        this.addRenderableWidget((GuiEventListener)this.colorInputBox);
        this.overlaySelectionButtons.clear();
        int i = 0;
        for (Overlay overlay : Overlay.getAllOverlays()) {
            FlippableModel overlayModel = FlippableModel.from(new TexturedModel[]{new TexturedModel(WideSignModel.MODEL_OVERLAY, overlay.materialFor(SmallWideSignBlockPart.class), this.colorFrom(overlay.tint))}, new TexturedModel[]{new TexturedModel(WideSignModel.MODEL_OVERLAY_FLIPPED, overlay.materialFor(SmallWideSignBlockPart.class), this.colorFrom(overlay.tint))});
            this.overlaySelectionButtons.add(new ModelButton(TextureResource.signTypeSelection, new Point(this.getCenterX() - 15 - i * 37, rotationInputBoxRect.max().y + 15), 0.5f, Rect.XAlignment.Right, Rect.YAlignment.Top, rect -> rect.withPoint(p -> p.add(Math.round(-3.030303f), 0)).scaleCenter(0.75f), () -> this.switchOverlay(Optional.of(overlay)), new ModelButton.ModelData(postModel, 0.0f, -0.5f, this.itemStack), new ModelButton.ModelData(wideModel, 0.0f, 0.25f, this.itemStack), new ModelButton.ModelData(overlayModel, 0.0f, 0.25f, this.itemStack)));
            ++i;
        }
        if (i > 0) {
            this.overlaySelectionButtons.add(new ModelButton(TextureResource.signTypeSelection, new Point(this.getCenterX() - 15 - i * 37, rotationInputBoxRect.max().y + 15), 0.5f, Rect.XAlignment.Right, Rect.YAlignment.Top, rect -> rect.withPoint(p -> p.add(Math.round(-3.030303f), 0)).scaleCenter(0.75f), () -> this.switchOverlay(Optional.empty()), new ModelButton.ModelData(postModel, 0.0f, -0.5f, this.itemStack), new ModelButton.ModelData(wideModel, 0.0f, 0.25f, this.itemStack)));
        }
        for (Button button : this.overlaySelectionButtons) {
            this.addRenderableWidget((GuiEventListener)button);
        }
        this.switchTo(currentType);
        this.switchOverlay(this.selectedOverlay);
        this.waystoneInputBox.setValue(currentWaystone);
        switch (currentType.ordinal()) {
            case 0: {
                this.wideSignInputBox.setValue(currentText[0].get());
                break;
            }
            case 1: {
                this.shortSignInputBox.setValue(currentText[0].get());
                break;
            }
            case 2: {
                for (i = 0; i < this.largeSignInputBoxes.size(); ++i) {
                    this.largeSignInputBoxes.get(i).setValue(currentText[i].get());
                }
                break;
            }
        }
        if (isFlipped ^ this.widgetsToFlip.get(0).isFlipped()) {
            this.flip();
        }
        this.colorInputBox.setSelectedColor(currentColor);
        this.rotationInputField.setSelectedAngle(Angle.fromDegrees(Math.round(currentAngle.degrees())));
        if (this.hasBeenInitialized) {
            this.onWaystoneCountChanged();
        } else {
            String unknownWaystone = Component.translatable((String)"gui.signpost.unknownWaystone").withStyle(style -> style.withColor(TextColor.fromRgb((int)-9408400))).getString();
            Optional<Object> optional = this.oldSign.flatMap(SignBlockPart::getDestination).map(handle -> new WaystoneEntry(unknownWaystone, unknownWaystone, (WaystoneHandle)handle, this.tile.getBlockPos().offset((Vec3i)new Vector3(100.0f, 0.0f, 0.0f).rotateY(this.oldSign.get().getAngle().get()).toBlockPos())));
            optional.ifPresent(text -> {
                this.waystoneDropdown.addEntry((WaystoneEntry)text);
                this.waystoneInputBox.setResponder(x -> {});
                this.waystoneInputBox.setValue(text.entryName);
                this.waystoneInputBox.setResponder(this::onWaystoneSelected);
            });
            Consumer<Function> setupFromSign = map -> {
                oldWaystone.ifPresent(oldWs -> {
                    Optional name = (Optional)map.apply(oldWs.handle);
                    if (name.isPresent()) {
                        oldWs.entryName = (String)((Tuple)((Tuple)name.get())._1())._1();
                        oldWs.displayName = (String)((Tuple)((Tuple)name.get())._1())._2();
                        oldWs.pos = (BlockPos)((Tuple)name.get())._2();
                        this.waystoneInputBox.setValue(oldWs.entryName);
                    }
                });
                this.onWaystoneCountChanged();
            };
            WaystoneLibrary.getInstance().requestAllWaystones(n -> {
                this.waystoneDropdown.addEntries(n.entrySet().stream().map(e -> new WaystoneEntry((String)((Tuple)e.getValue())._1(), (String)((Tuple)e.getValue())._1(), (WaystoneHandle)e.getKey(), ((WaystoneLocationData)((Tuple)e.getValue())._2()).block().blockPos())).filter(e -> oldWaystone.map(oldE -> !e.handle.equals(oldE.handle)).orElse(true)).collect(Collectors.toList()));
                setupFromSign.accept(id -> id instanceof WaystoneHandle.Vanilla ? Optional.ofNullable((Tuple)n.get(id)).map(e -> Tuple.of((String)e._1(), (String)e._1(), ((WaystoneLocationData)e._2()).block().blockPos())) : Optional.empty());
            }, Optional.of(PlayerHandle.from((Entity)this.minecraft.player)), true);
            ExternalWaystoneLibrary.getInstance().requestKnownWaystones(n -> {
                List entries = n.stream().map(w -> new WaystoneEntry(w.name() + " " + w.handle().modMark(), w.name(), w.handle(), w.loc().block().blockPos())).collect(Collectors.toList());
                this.waystoneDropdown.addEntries(entries.stream().filter(e -> oldWaystone.map(oldE -> !e.handle.equals(oldE.handle)).orElse(true)).collect(Collectors.toList()));
                setupFromSign.accept(id -> entries.stream().filter(e -> e.handle.equals(id)).findFirst().map(e -> Tuple.of(e.entryName, e.displayName, e.pos)));
            });
            WaystoneLibrary.getInstance().updateEventDispatcher.addListener(this.waystoneUpdateListener);
        }
        int newSignItemSize = 16;
        TextDisplay textDisplay = new TextDisplay((Component)Component.translatable((String)"gui.signpost.new_sign_hint"), new Point(this.getCenterX() - 16, (int)((float)(doneButton.getY() + doneButton.getHeight() + this.height) / 2.0f)), Rect.XAlignment.Center, Rect.YAlignment.Center, this.font);
        this.addRenderableOnly(textDisplay);
        GuiItemRenderer ir = new GuiItemRenderer(new Rect(textDisplay.rect.at(Rect.XAlignment.Right, Rect.YAlignment.Center), 16, 16, Rect.XAlignment.Left, Rect.YAlignment.Center), ItemStack.EMPTY);
        this.addRenderableOnly((Renderable)ir);
        AtomicReference<Runnable> cycleItem = new AtomicReference<Runnable>();
        AtomicInteger cycleItemIndex = new AtomicInteger(0);
        AtomicInteger cycleItemIngredientIndex = new AtomicInteger(0);
        AtomicLong nextCycleAt = new AtomicLong(System.currentTimeMillis());
        cycleItem.set(() -> {
            if (this.isClosed) {
                return;
            }
            List options = PostBlock.AllVariants.get((int)cycleItemIndex.get()).type.addSignIngredient.apply((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()).items().toList();
            ir.setItemStack(new ItemStack((ItemLike)((Holder)options.get(cycleItemIngredientIndex.get())).value()));
            if (cycleItemIngredientIndex.get() >= options.size() - 1) {
                cycleItemIndex.set((cycleItemIndex.get() + 1) % PostBlock.AllVariants.size());
                cycleItemIngredientIndex.set(0);
            } else {
                cycleItemIngredientIndex.incrementAndGet();
            }
            nextCycleAt.set(nextCycleAt.get() + (long)(options.size() < 2 ? 1500 : (options.size() == 2 ? 1000 : 500)));
            IDelay.onClientUntil(() -> System.currentTimeMillis() >= nextCycleAt.get(), () -> ((Runnable)cycleItem.get()).run());
        });
        ((Runnable)cycleItem.get()).run();
        this.hasBeenInitialized = true;
        this.setFocused((GuiEventListener)this.currentSignInputBox);
        this.currentSignInputBox.setFocused(true);
    }

    private void onWaystoneCountChanged() {
        if (this.waystoneDropdown.getAllEntries().isEmpty()) {
            if (!((ScreenAccessor)((Object)this)).getRenderables().contains(this.noWaystonesInfo)) {
                this.addRenderableOnly(this.noWaystonesInfo);
            }
            this.removeWidget((GuiEventListener)this.waystoneDropdown);
            this.removeWidget((GuiEventListener)this.waystoneInputBox);
        } else {
            if (!((ScreenAccessor)((Object)this)).getRenderables().contains(this.waystoneDropdown)) {
                this.addRenderableWidget((GuiEventListener)this.waystoneDropdown);
            }
            if (!((ScreenAccessor)((Object)this)).getRenderables().contains(this.waystoneInputBox)) {
                this.addRenderableWidget((GuiEventListener)this.waystoneInputBox);
            }
            ((ScreenAccessor)((Object)this)).getRenderables().remove(this.noWaystonesInfo);
        }
    }

    private void flip() {
        AngleSelectionEntry playerAngleEntry = this.angleEntryForPlayer();
        boolean shouldPointAtPlayer = Math.round(Math.abs(playerAngleEntry.angleGetter.get().degrees() - this.rotationInputField.getCurrentAngle().degrees())) <= 1;
        this.widgetsToFlip.forEach(Flippable::flip);
        if (shouldPointAtPlayer) {
            this.rotationInputField.setValue(playerAngleEntry.angleToString());
        }
    }

    private void onWaystoneSelected(String waystoneName) {
        boolean shouldOverrideRotation;
        boolean bl = shouldOverrideRotation = this.isCurrentAnglePointingAtWaystone() || this.isCurrentAnglePointingAtPlayer();
        if (this.waystoneRotationEntry != null) {
            shouldOverrideRotation |= this.waystoneRotationEntry.angleGetter.get().isNearly(this.rotationInputField.getCurrentAngle(), Angle.fromDegrees(1.0f));
            this.angleDropDown.removeEntry(this.waystoneRotationEntry);
        }
        Optional<WaystoneEntry> validWaystone = this.asValidWaystone(waystoneName);
        if (waystoneName.equals("") || validWaystone.isPresent()) {
            this.waystoneInputBox.setTextColor(-1);
            this.waystoneInputBox.setTextColorUneditable(-2236963);
            this.waystoneDropdown.setFilter(name -> true);
            if (this.currentSignInputBox != null && this.lastWaystone.map(lw -> lw.displayName.equals(this.currentSignInputBox.getValue())).orElse(this.currentSignInputBox.getValue().equals("")).booleanValue()) {
                this.currentSignInputBox.setValue(validWaystone.map(e -> e.displayName).orElse(waystoneName));
            }
            if (!waystoneName.equals("")) {
                this.waystoneRotationEntry = this.angleEntryForWaystone(validWaystone.get());
                this.angleDropDown.addEntry(this.waystoneRotationEntry);
                if (shouldOverrideRotation) {
                    this.rotationInputField.setSelectedAngle(this.waystoneRotationEntry.angleGetter.get());
                }
            }
            this.lastWaystone = validWaystone;
        } else {
            this.waystoneInputBox.setTextColor(-48060);
            this.waystoneInputBox.setTextColorUneditable(-2267546);
            this.waystoneDropdown.setFilter(e -> e.entryName.toLowerCase().contains(waystoneName.toLowerCase()));
            if (this.currentSignInputBox != null && this.lastWaystone.map(lw -> lw.displayName.equals(this.currentSignInputBox.getValue())).orElse(this.currentSignInputBox.getValue().equals("")).booleanValue()) {
                this.currentSignInputBox.setValue("");
            }
        }
    }

    private int colorFrom(Optional<Tint> tint) {
        return tint.map(t -> t.getColorAt((BlockAndTintGetter)this.minecraft.level, this.minecraft.player.blockPosition())).orElse(-1);
    }

    private boolean isCurrentAnglePointingAtWaystone() {
        return !this.oldSign.isPresent() && this.rotationInputField.getCurrentAngle().equals(Angle.ZERO) || this.lastWaystone.map(lw -> this.rotationInputField.getCurrentAngle().isNearly(this.angleEntryForWaystone((WaystoneEntry)lw).angleGetter.get(), Angle.fromDegrees(1.0f))).orElse(false) != false;
    }

    private boolean isCurrentAnglePointingAtPlayer() {
        return this.rotationInputField.getCurrentAngle().isNearly(this.angleEntryForPlayer().angleGetter.get(), Angle.fromDegrees(1.0f));
    }

    private Optional<WaystoneEntry> asValidWaystone(String name) {
        Optional<WaystoneEntry> ret = this.waystoneDropdown.getAllEntries().stream().filter(e -> e.entryName.equals(name)).findFirst();
        if (ret.isPresent()) {
            return ret;
        }
        return this.waystoneDropdown.getAllEntries().stream().filter(e -> e.displayName.equals(name)).findFirst();
    }

    private static SignpostImageButton newImageButton(TextureResource texture, int index, Point referencePoint, float scale, Rect.XAlignment xAlignment, Rect.YAlignment yAlignment, Runnable onClick) {
        Rect rect = new Rect(referencePoint, texture.size.scale(scale), xAlignment, yAlignment);
        return new SignpostImageButton(texture, rect, b -> onClick.run());
    }

    private int getCenterX() {
        return this.width / 2;
    }

    private int getCenterY() {
        return this.height / 2;
    }

    private void switchTo(SignType type) {
        switch (type.ordinal()) {
            case 0: {
                this.switchToWide();
                break;
            }
            case 1: {
                this.switchToShort();
                break;
            }
            case 2: {
                this.switchToLarge();
                break;
            }
            default: {
                throw new RuntimeException("Sign type " + String.valueOf((Object)type) + " is not supported");
            }
        }
    }

    private void switchToWide() {
        if (this.selectedType == SignType.Wide) {
            return;
        }
        this.clearTypeDependentChildren();
        this.selectedType = SignType.Wide;
        this.switchSignInputBoxTo(this.wideSignInputBox);
        this.addRenderableOnly(this.wideSignRenderer);
        this.addTypeDependentChild((AbstractWidget)this.wideSignInputBox);
        this.currentSignRenderer = this.wideSignRenderer;
        this.switchOverlay(this.selectedOverlay);
    }

    private void switchToShort() {
        if (this.selectedType == SignType.Short) {
            return;
        }
        this.clearTypeDependentChildren();
        this.selectedType = SignType.Short;
        this.switchSignInputBoxTo(this.shortSignInputBox);
        this.addRenderableOnly(this.shortSignRenderer);
        this.addTypeDependentChild((AbstractWidget)this.shortSignInputBox);
        this.currentSignRenderer = this.shortSignRenderer;
        this.switchOverlay(this.selectedOverlay);
    }

    private void switchToLarge() {
        if (this.selectedType == SignType.Large) {
            return;
        }
        this.clearTypeDependentChildren();
        this.selectedType = SignType.Large;
        this.switchSignInputBoxTo(this.largeSignInputBoxes.get(0));
        this.addRenderableOnly(this.largeSignRenderer);
        this.addTypeDependentChildren(this.largeSignInputBoxes);
        this.currentSignRenderer = this.largeSignRenderer;
        this.switchOverlay(this.selectedOverlay);
    }

    private void switchOverlay(Optional<Overlay> overlay) {
        if (this.currentOverlay != null) {
            ((ScreenAccessor)((Object)this)).getRenderables().remove(this.currentOverlay);
            this.widgetsToFlip.remove(this.currentOverlay);
        }
        this.selectedOverlay = overlay;
        if (!overlay.isPresent()) {
            return;
        }
        Overlay o = overlay.get();
        switch (this.selectedType.ordinal()) {
            case 0: {
                this.currentOverlay = new GuiModelRenderer(this.wideSignRenderer.rect, FlippableModel.from(new TexturedModel[]{new TexturedModel(WideSignModel.MODEL_OVERLAY, o.materialFor(SmallWideSignBlockPart.class), this.colorFrom(o.tint))}, new TexturedModel[]{new TexturedModel(WideSignModel.MODEL_OVERLAY_FLIPPED, o.materialFor(SmallWideSignBlockPart.class), this.colorFrom(o.tint))}), 0.0f, 0.25f);
                break;
            }
            case 1: {
                this.currentOverlay = new GuiModelRenderer(this.shortSignRenderer.rect, FlippableModel.from(new TexturedModel[]{new TexturedModel(ShortSignModel.MODEL_OVERLAY, o.materialFor(SmallShortSignBlockPart.class), this.colorFrom(o.tint))}, new TexturedModel[]{new TexturedModel(ShortSignModel.MODEL_OVERLAY_FLIPPED, o.materialFor(SmallShortSignBlockPart.class), this.colorFrom(o.tint))}), 0.0f, 0.25f);
                break;
            }
            case 2: {
                this.currentOverlay = new GuiModelRenderer(this.largeSignRenderer.rect, FlippableModel.from(new TexturedModel[]{new TexturedModel(LargeSignModel.MODEL_OVERLAY, o.materialFor(LargeSignBlockPart.class), this.colorFrom(o.tint))}, new TexturedModel[]{new TexturedModel(LargeSignModel.MODEL_OVERLAY_FLIPPED, o.materialFor(LargeSignBlockPart.class), this.colorFrom(o.tint))}), 0.0f, 0.0f);
            }
        }
        this.addRenderableOnly(this.currentOverlay);
        if (this.currentSignRenderer.isFlipped()) {
            this.currentOverlay.flip();
        }
        this.widgetsToFlip.add(this.currentOverlay);
    }

    private void hideStuffOccludedByWaystoneDropdown() {
        ((ScreenAccessor)((Object)this)).getRenderables().remove(this.rotationLabel);
        this.removeWidget((GuiEventListener)this.rotationInputField);
        this.angleDropDown.hideList();
        this.removeWidget((GuiEventListener)this.angleDropDown);
        for (Button button : this.overlaySelectionButtons) {
            this.removeWidget((GuiEventListener)button);
        }
    }

    private void showStuffOccludedByWaystoneDropdown() {
        this.addRenderableOnly(this.rotationLabel);
        this.addRenderableWidget((GuiEventListener)this.rotationInputField);
        this.addRenderableWidget((GuiEventListener)this.angleDropDown);
        for (Button button : this.overlaySelectionButtons) {
            this.addRenderableWidget((GuiEventListener)button);
        }
    }

    private void switchSignInputBoxTo(InputBox box) {
        if (this.currentSignInputBox != null) {
            box.setValue(this.currentSignInputBox.getValue());
        }
        this.currentSignInputBox = box;
    }

    private void clearTypeDependentChildren() {
        for (AbstractWidget b : this.selectionDependentWidgets) {
            this.removeWidget((GuiEventListener)b);
        }
        ((ScreenAccessor)((Object)this)).getRenderables().remove(this.currentSignRenderer);
        this.selectionDependentWidgets.clear();
    }

    private void addTypeDependentChildren(Collection<? extends AbstractWidget> widgets) {
        this.selectionDependentWidgets.addAll(widgets);
        for (AbstractWidget abstractWidget : widgets) {
            this.addRenderableWidget((GuiEventListener)abstractWidget);
        }
    }

    private void addTypeDependentChild(AbstractWidget widget) {
        this.selectionDependentWidgets.add(widget);
        this.addRenderableWidget((GuiEventListener)widget);
    }

    public void onClose() {
        super.onClose();
        this.isClosed = true;
        WaystoneLibrary.getInstance().updateEventDispatcher.removeListener(this.waystoneUpdateListener);
    }

    private void removeSign() {
        if (this.oldSign.isPresent()) {
            PacketHandler.getInstance().sendToServer(new PostTile.PartRemovedEvent.Packet(this.oldTilePartInfo.get(), true));
        } else {
            Signpost.LOGGER.error("Tried to remove a sign, but the necessary information was missing.");
        }
        this.minecraft.setScreen(null);
    }

    private void done() {
        this.apply(this.asValidWaystone(this.waystoneInputBox.getValue()).map(w -> w.handle));
        this.minecraft.setScreen(null);
        this.isClosed = true;
    }

    private void apply(Optional<WaystoneHandle> destinationId) {
        PostTile.TilePartInfo tilePartInfo = this.oldTilePartInfo.orElseGet(() -> new PostTile.TilePartInfo(this.tile.getLevel().dimension().location(), this.tile.getBlockPos(), UUID.randomUUID()));
        RegistryAccess registries = this.tile.getLevel().registryAccess();
        boolean isLocked = this.lockButton.isLocked();
        Texture mainTex = this.oldSign.map(SignBlockPart::getMainTexture).orElse(this.modelType.mainTexture);
        Texture secondaryTex = this.oldSign.map(SignBlockPart::getSecondaryTexture).orElse(this.modelType.secondaryTexture);
        AngleProvider angle = destinationId.flatMap(destination -> this.isCurrentAnglePointingAtWaystone() ? Optional.of(new AngleProvider.WaystoneTarget(this.rotationInputField.getCurrentAngle())) : Optional.empty()).orElseGet(() -> new AngleProvider.Literal(this.rotationInputField.getCurrentAngle()));
        switch (this.selectedType.ordinal()) {
            case 0: {
                SmallWideSignBlockPart data = new SmallWideSignBlockPart(angle, this.asNameProvider(this.wideSignInputBox.getValue()), this.wideSignRenderer.isFlipped(), mainTex, secondaryTex, this.selectedOverlay, this.colorInputBox.getCurrentColor(), destinationId, this.itemToDropOnBreak, this.modelType, isLocked, this.oldSign.map(SignBlockPart::isMarkedForGeneration).orElse(false));
                if (this.oldSign.isPresent()) {
                    PacketHandler.getInstance().sendToServer(new PostTile.PartMutatedEvent.Packet(tilePartInfo, (BlockPart)data, SmallWideSignBlockPart.METADATA.identifier(), new Vector3(0.0f, this.localHitPos.y() > 0.5f ? 0.75f : 0.25f, 0.0f)));
                    break;
                }
                PacketHandler.getInstance().sendToServer(new PostTile.PartAddedEvent.Packet(tilePartInfo, new BlockPartInstance(data, new Vector3(0.0f, this.localHitPos.y() > 0.5f ? 0.75f : 0.25f, 0.0f)), this.itemToDropOnBreak.orElse(ItemStack.EMPTY), PlayerHandle.from((Entity)this.minecraft.player)));
                break;
            }
            case 1: {
                SmallShortSignBlockPart data = new SmallShortSignBlockPart(angle, this.asNameProvider(this.shortSignInputBox.getValue()), this.shortSignRenderer.isFlipped(), mainTex, secondaryTex, this.selectedOverlay, this.colorInputBox.getCurrentColor(), destinationId, this.itemToDropOnBreak, this.modelType, isLocked, this.oldSign.map(SignBlockPart::isMarkedForGeneration).orElse(false));
                if (this.oldSign.isPresent()) {
                    PacketHandler.getInstance().sendToServer(new PostTile.PartMutatedEvent.Packet(tilePartInfo, (BlockPart)data, SmallShortSignBlockPart.METADATA.identifier(), new Vector3(0.0f, this.localHitPos.y() > 0.5f ? 0.75f : 0.25f, 0.0f)));
                    break;
                }
                PacketHandler.getInstance().sendToServer(new PostTile.PartAddedEvent.Packet(tilePartInfo, new BlockPartInstance(data, new Vector3(0.0f, this.localHitPos.y() > 0.5f ? 0.75f : 0.25f, 0.0f)), this.itemToDropOnBreak.orElse(ItemStack.EMPTY), PlayerHandle.from((Entity)this.minecraft.player)));
                break;
            }
            case 2: {
                LargeSignBlockPart data = new LargeSignBlockPart(angle, new NameProvider[]{this.asNameProvider(this.largeSignInputBoxes.get(0).getValue()), this.asNameProvider(this.largeSignInputBoxes.get(1).getValue()), this.asNameProvider(this.largeSignInputBoxes.get(2).getValue()), this.asNameProvider(this.largeSignInputBoxes.get(3).getValue())}, this.currentSignRenderer.isFlipped(), mainTex, secondaryTex, this.selectedOverlay, this.colorInputBox.getCurrentColor(), destinationId, this.itemToDropOnBreak, this.modelType, isLocked, this.oldSign.map(SignBlockPart::isMarkedForGeneration).orElse(false));
                if (this.oldSign.isPresent()) {
                    PacketHandler.getInstance().sendToServer(new PostTile.PartMutatedEvent.Packet(tilePartInfo, (BlockPart)data, LargeSignBlockPart.METADATA.identifier(), new Vector3(0.0f, this.localHitPos.y() >= 0.5f ? 0.501f : 0.499f, 0.0f)));
                    break;
                }
                PacketHandler.getInstance().sendToServer(new PostTile.PartAddedEvent.Packet(tilePartInfo, new BlockPartInstance(data, new Vector3(0.0f, 0.5f, 0.0f)), this.itemToDropOnBreak.orElse(ItemStack.EMPTY), PlayerHandle.from((Entity)this.minecraft.player)));
            }
        }
    }

    private AngleSelectionEntry angleEntryForWaystone(WaystoneEntry waystone) {
        AtomicReference<Angle> angle = new AtomicReference<Angle>(Angle.fromDegrees(404.0f));
        angle.set(SignBlockPart.pointingAt(this.tile.getBlockPos(), waystone.pos));
        return new AngleSelectionEntry("gui.signpost.rotation_waystone", angle::get);
    }

    private AngleSelectionEntry angleEntryForPlayer() {
        AtomicReference<Angle> angleWhenFlipped = new AtomicReference<Angle>(Angle.fromDegrees(404.0f));
        AtomicReference<Angle> angleWhenNotFlipped = new AtomicReference<Angle>(Angle.fromDegrees(404.0f));
        IDelay.onClientUntil(() -> this.minecraft != null && this.minecraft.player != null, () -> {
            angleWhenFlipped.set(Angle.fromDegrees(-this.minecraft.player.getYRot()).normalized());
            angleWhenNotFlipped.set(((Angle)angleWhenFlipped.get()).add(Angle.fromRadians((float)Math.PI)).normalized());
            if (!this.oldSign.isPresent() && this.rotationInputField.getCurrentAngle().equals(Angle.ZERO)) {
                IDelay.onClientUntil(() -> this.widgetsToFlip.size() > 0, () -> this.rotationInputField.setSelectedAngle((Angle)(this.widgetsToFlip.get(0).isFlipped() ? angleWhenFlipped : angleWhenNotFlipped).get()), 100, Optional.empty());
            }
        });
        return new AngleSelectionEntry("gui.signpost.rotation_player", () -> (Angle)(this.widgetsToFlip.get(0).isFlipped() ? angleWhenFlipped : angleWhenNotFlipped).get());
    }

    private NameProvider asNameProvider(String name) {
        return this.lastWaystone.map(lw -> lw.entryName.equals(name)).orElse(false) != false ? new NameProvider.WaystoneTarget(name) : new NameProvider.Literal(name);
    }

    private static enum SignType {
        Wide,
        Short,
        Large;

    }

    private static class AngleSelectionEntry {
        private final String langKey;
        public final Supplier<Angle> angleGetter;

        private AngleSelectionEntry(String langKey, Supplier<Angle> angleGetter) {
            this.langKey = langKey;
            this.angleGetter = angleGetter;
        }

        public String angleToString() {
            return Math.round(this.angleGetter.get().degrees()) + AngleInputBox.degreeSign;
        }

        public String toString() {
            return I18n.get((String)this.langKey, (Object[])new Object[]{this.angleToString()});
        }
    }
}

