/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui.widgets;

import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.gui.widgets.InputBox;
import gollorum.signpost.utils.math.Angle;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.gui.Font;

public class AngleInputBox
extends InputBox {
    public static final String degreeSign = Character.toString('\u00b0');
    private float currentResult;

    public AngleInputBox(Font fontRenderer, Rect inputFieldRect, double zOffset) {
        super(fontRenderer, new Rect(new Point(inputFieldRect.point.x + inputFieldRect.height, inputFieldRect.point.y), inputFieldRect.width - inputFieldRect.height, inputFieldRect.height), true, zOffset);
        this.setFilter(null);
        this.setValue("0" + degreeSign);
        this.setResponder(null);
    }

    private static boolean isValidValue(String text) {
        return text.endsWith(degreeSign) ? AngleInputBox.canParse(text.substring(0, text.length() - 1)) : AngleInputBox.canParse(text);
    }

    private static boolean canParse(String text) {
        if (text.equals("")) {
            return true;
        }
        if (text.equals("-")) {
            return true;
        }
        try {
            Integer.parseInt(text);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private float getResult() {
        String text = this.getValue().endsWith(degreeSign) ? this.getValue().substring(0, this.getValue().length() - 1) : this.getValue();
        return text.equals("") || text.equals("-") ? 0.0f : (float)Integer.parseInt(text);
    }

    public Angle getCurrentAngle() {
        return Angle.fromDegrees(this.currentResult);
    }

    public void setResponder(Consumer<String> responder) {
        super.setResponder(value -> {
            this.currentResult = this.getResult();
            if (responder != null) {
                responder.accept((String)value);
            }
        });
    }

    public void setFilter(Predicate<String> filter) {
        super.setFilter(value -> AngleInputBox.isValidValue(value) && (filter == null || filter.test((String)value)));
    }

    public void setAngleResponder(Consumer<Angle> responder) {
        this.setResponder(responder == null ? null : value -> responder.accept(Angle.fromDegrees(this.currentResult)));
    }

    public void setSelectedAngle(Angle angle) {
        this.setValue(Math.round(angle.degrees()) + degreeSign);
    }
}

