/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui.widgets;

import gollorum.signpost.minecraft.gui.utils.Colors;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.gui.utils.TextureResource;
import gollorum.signpost.minecraft.gui.widgets.InputBox;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;

public class ColorInputBox
extends InputBox {
    private int currentResult;

    public ColorInputBox(Font fontRenderer, Rect inputFieldRect, double zOffset) {
        super(fontRenderer, new Rect(new Point(inputFieldRect.point.x + inputFieldRect.height, inputFieldRect.point.y), inputFieldRect.width - inputFieldRect.height, inputFieldRect.height), true, zOffset);
        this.setFilter(null);
        this.setResponder(null);
        this.setValue("#000000");
    }

    private static boolean isValidColor(String text) {
        return text.startsWith("#") && text.length() <= 7 && ColorInputBox.canParse(text.substring(1));
    }

    public void setFilter(Predicate<String> filter) {
        super.setFilter(text -> ColorInputBox.isValidColor(text) && (filter == null || filter.test((String)text)));
    }

    private static boolean canParse(String text) {
        if (text.equals("")) {
            return true;
        }
        try {
            Integer.parseInt(text, 16);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private int getResult() {
        if (this.getValue().equals("#")) {
            return 0;
        }
        return Integer.parseInt(this.getValue().substring(1), 16);
    }

    public int getCurrentColor() {
        return Colors.withAlpha(this.currentResult, 255);
    }

    public void setResponder(Consumer<String> responder) {
        super.setResponder(text -> {
            this.currentResult = this.getResult();
            if (responder != null) {
                responder.accept((String)text);
            }
        });
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.blit(RenderPipelines.GUI_TEXTURED, TextureResource.paintBackground.location, this.getX() - this.height, this.getY(), 0.0f, 0.0f, this.height, this.height, TextureResource.paintBackground.size.width, TextureResource.paintBackground.size.height, this.getCurrentColor());
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
    }

    public void setColorResponder(Consumer<Integer> responder) {
        this.setResponder(text -> {
            if (responder != null) {
                responder.accept(this.getCurrentColor());
            }
        });
    }

    public void setSelectedColor(int color) {
        Object text = Integer.toHexString(color);
        if (((String)text).length() < 6) {
            text = String.join((CharSequence)"", Collections.nCopies(6 - ((String)text).length(), "0")) + (String)text;
        }
        this.setValue("#" + (String)text);
    }
}

