/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui.widgets;

import gollorum.signpost.minecraft.gui.utils.Colors;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.gui.utils.TextureResource;
import gollorum.signpost.minecraft.gui.utils.TextureSize;
import gollorum.signpost.minecraft.gui.widgets.DropDownSelection;
import gollorum.signpost.minecraft.rendering.RenderingUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;

public class DropDownSelection<EntryType>
extends ImageButton {
    public final Rect rect;
    private static final TextureResource texture = TextureResource.expandContract;
    public static final TextureSize size = new TextureSize(11, 11);
    private final Consumer<List> onShow;
    private final Consumer<List> onHide;
    private final Consumer<EntryType> onSelectionChanged;
    private final Font fontRenderer;
    private boolean isListVisible;
    private final List list;
    private final java.util.List<EntryType> allEntries = new ArrayList<EntryType>();
    private Predicate<EntryType> filter = b -> true;
    private int selectedIndex;

    public Collection<EntryType> getAllEntries() {
        return this.allEntries;
    }

    public Optional<EntryType> getSelectedEntry() {
        List.Entry selectedEntry = (List.Entry)this.list.getSelected();
        if (selectedEntry == null) {
            return Optional.empty();
        }
        return Optional.of(selectedEntry.content);
    }

    public void setFilter(Predicate<EntryType> filter) {
        this.filter = filter;
        this.list.updateContent();
    }

    public DropDownSelection(Font fontRenderer, Point position, Rect.XAlignment xAlignment, Rect.YAlignment yAlignment, int width, int height, int yOffset, Consumer<List> onShow, Consumer<List> onHide, Consumer<EntryType> onSelectionChanged) {
        this(fontRenderer, new Rect(position, size, xAlignment, yAlignment), width, height, yOffset, onShow, onHide, onSelectionChanged);
    }

    private DropDownSelection(Font fontRenderer, Rect rect, int width, int height, int yOffset, Consumer<List> onShow, Consumer<List> onHide, Consumer<EntryType> onSelectionChanged) {
        super(rect.point.x, rect.point.y, rect.width, rect.height, new WidgetSprites(DropDownSelection.texture.location, DropDownSelection.texture.location), b -> ((DropDownSelection)b).toggle());
        this.rect = rect;
        this.fontRenderer = fontRenderer;
        this.list = new List(this, Minecraft.getInstance(), new Point(rect.point.x + DropDownSelection.size.width, rect.point.y + DropDownSelection.size.height + yOffset), width, height);
        this.onSelectionChanged = onSelectionChanged;
        this.onShow = onShow;
        this.onHide = onHide;
    }

    public void addEntry(EntryType text) {
        if (!this.allEntries.contains(text)) {
            this.allEntries.add(text);
            this.list.updateContent();
        }
    }

    public void removeEntry(EntryType text) {
        if (this.allEntries.contains(text)) {
            this.allEntries.remove(text);
            this.list.updateContent();
        }
    }

    public void setEntries(Collection<EntryType> entries) {
        this.allEntries.clear();
        this.addEntries(entries);
    }

    public void addEntries(Collection<EntryType> entries) {
        this.allEntries.addAll(entries);
        this.list.updateContent();
    }

    public void toggle() {
        if (this.isListVisible) {
            this.isListVisible = false;
            this.onHide.accept(this.list);
        } else {
            this.isListVisible = true;
            this.onShow.accept(this.list);
        }
    }

    public void showList() {
        if (!this.isListVisible) {
            this.isListVisible = true;
            this.onShow.accept(this.list);
        }
    }

    public void hideList() {
        if (this.isListVisible) {
            this.isListVisible = false;
            this.onHide.accept(this.list);
        }
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.pose().pushMatrix();
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        int yTexStart = this.isHovered ? DropDownSelection.texture.size.height : 0;
        int xTexStart = this.isListVisible ? DropDownSelection.texture.size.width : 0;
        graphics.blit(RenderPipelines.GUI_TEXTURED, DropDownSelection.texture.location, this.getX(), this.getY(), (float)xTexStart, (float)yTexStart, this.width, this.height, DropDownSelection.texture.fileSize.height, DropDownSelection.texture.fileSize.width);
        if (this.isListVisible) {
            this.list.render(graphics, mouseX, mouseY, partialTicks);
        }
        graphics.pose().popMatrix();
    }

    public class List
    extends ObjectSelectionList<gollorum.signpost.minecraft.gui.widgets.DropDownSelection$List.Entry> {
        private final int rimHeight;
        final /* synthetic */ DropDownSelection this$0;

        public List(DropDownSelection this$0, Minecraft minecraft, Point topRight, int width, int height) {
            Objects.requireNonNull(minecraft.font);
            this(this$0, minecraft, topRight, width, height, 9);
        }

        public List(DropDownSelection this$0, Minecraft minecraft, Point topRight, int width, int height, int rimHeight) {
            this.this$0 = this$0;
            super(minecraft, width, height, topRight.y + rimHeight, 14);
            this.setX(topRight.x - width);
            this.rimHeight = rimHeight;
            this.updateContent();
        }

        public void updateContent() {
            this.replaceEntries(this.this$0.allEntries.stream().filter(this.this$0.filter).map(x$0 -> new Entry(x$0)).collect(Collectors.toList()));
            this.setScrollAmount(this.scrollAmount());
        }

        public int getRowWidth() {
            return this.width;
        }

        public class Entry
        extends ObjectSelectionList.Entry<gollorum.signpost.minecraft.gui.widgets.DropDownSelection$List.Entry> {
            private final EntryType content;

            public Entry(EntryType content) {
                this.content = content;
            }

            public void renderContent(GuiGraphics graphics, int mouseX, int mouseY, boolean isHovering, float partialTick) {
                int brightness = 255;
                if (isHovering) {
                    brightness = (int)((float)brightness * 0.6f);
                }
                RenderingUtil.drawString(graphics, List.this.this$0.fontRenderer, this.content.toString(), new Point(this.getContentX(), this.getContentY()), Rect.XAlignment.Center, Rect.YAlignment.Top, Colors.from(brightness, brightness, brightness), List.this.width - 6, true);
            }

            public Component getNarration() {
                return Component.literal((String)"");
            }

            public boolean mouseClicked(MouseButtonEvent p_446815_, boolean p_432750_) {
                List.this.this$0.selectedIndex = List.this.this$0.allEntries.indexOf(this.content);
                List.this.this$0.onSelectionChanged.accept(this.content);
                return true;
            }
        }
    }
}

