/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import gollorum.signpost.blockpartdata.types.BlockPartRenderer;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.rendering.GuiFakeCollector;
import gollorum.signpost.minecraft.rendering.RenderingUtil;
import gollorum.signpost.mixin.GuiGraphicsMixin;
import gollorum.signpost.utils.BlockPartInstance;
import gollorum.signpost.utils.math.Angle;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.state.GuiRenderState;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class GuiBlockPartRenderer
extends AbstractWidget {
    private static final double randomOffset = 0.001;
    private final Collection<BlockPartInstance> partsToRender;
    private final Point center;
    private Angle yaw;
    private Angle pitch;
    private float scale;
    private final Font font;

    public GuiBlockPartRenderer(Collection<BlockPartInstance> partsToRender, Point center, Angle yaw, Angle pitch, float scale, Font font) {
        super(center.x - GuiBlockPartRenderer.widthFor(scale) / 2, center.y - GuiBlockPartRenderer.heightFor(scale) / 2, GuiBlockPartRenderer.widthFor(scale), GuiBlockPartRenderer.heightFor(scale), (Component)Component.literal((String)""));
        this.partsToRender = partsToRender;
        this.center = center;
        this.yaw = yaw;
        this.pitch = pitch;
        this.scale = scale;
        this.font = font;
    }

    private static int widthFor(float scale) {
        return (int)(scale * 1.5f);
    }

    private static int heightFor(float scale) {
        return (int)(scale * 1.5f);
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isHovered) {
            graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, 0x20FFFFFF);
        }
        long randomSeed = ((Object)((Object)this)).hashCode();
        RandomSource random = RandomSource.create((long)randomSeed);
        PoseStack ms = new PoseStack();
        GuiRenderState renderState = ((GuiGraphicsMixin)graphics).getGuiRenderState();
        ScreenRectangle rect = new ScreenRectangle(this.getX(), this.getY(), this.width, this.height);
        RenderingUtil.wrapInMatrixEntry(ms, () -> {
            ms.translate(0.0f, 0.0f, 100.0f);
            ms.translate((float)this.center.x, (float)this.center.y, 0.0f);
            ms.scale(this.scale, -this.scale, this.scale);
            ms.mulPose((Quaternionfc)new Quaternionf(new AxisAngle4f(this.pitch.radians(), (Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f))));
            ms.mulPose((Quaternionfc)new Quaternionf(new AxisAngle4f(this.yaw.radians(), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f))));
            ms.translate(0.0, -0.5, 0.0);
            for (BlockPartInstance bpi : this.partsToRender) {
                RenderingUtil.wrapInMatrixEntry(ms, () -> {
                    ms.translate((double)bpi.offset().x() + 0.001 * random.nextDouble(), (double)bpi.offset().y() + 0.001 * random.nextDouble(), (double)bpi.offset().z() + 0.001 * random.nextDouble());
                    BlockPartRenderer.renderDynamic(bpi.blockPart(), (Level)Minecraft.getInstance().level, Minecraft.getInstance().player.blockPosition(), ms, new GuiFakeCollector(rect, renderState, this.font), (MaterialSet)Minecraft.getInstance().getAtlasManager(), 0xF000F0, OverlayTexture.NO_OVERLAY, t -> RenderType.cutout(), null);
                });
            }
        });
    }

    protected void onDrag(MouseButtonEvent event, double mouseX, double mouseY) {
        this.yaw = this.yaw.add(Angle.fromDegrees((float)(mouseX * 3.0)));
        this.pitch = this.pitch.add(Angle.fromDegrees((float)(mouseY * 3.0)));
        this.pitch = Angle.fromDegrees(Math.clamp(this.pitch.degrees(), -90.0f, 90.0f));
    }

    public void updateWidgetNarration(NarrationElementOutput p_169152_) {
    }
}

