/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import gollorum.signpost.minecraft.gui.utils.Flippable;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.rendering.FlippableModel;
import gollorum.signpost.minecraft.rendering.ModelElementRenderState;
import gollorum.signpost.minecraft.rendering.RenderingUtil;
import gollorum.signpost.minecraft.rendering.TexturedModel;
import gollorum.signpost.mixin.GuiGraphicsMixin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.gui.render.state.GuiRenderState;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.OverlayTexture;
import org.joml.AxisAngle4d;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class GuiModelRenderer
implements Renderable,
Flippable {
    private final FlippableModel model;
    private final float modelSpaceXOffset;
    private final float modelSpaceYOffset;
    private boolean isFlipped = false;
    private final Point center;
    private final int width;
    private final int height;
    public final Rect rect;

    public GuiModelRenderer(Rect rect, FlippableModel model, float modelSpaceXOffset, float modelSpaceYOffset) {
        this.rect = rect;
        this.center = rect.center();
        this.width = rect.width;
        this.height = rect.height;
        this.model = model;
        this.modelSpaceXOffset = modelSpaceXOffset;
        this.modelSpaceYOffset = modelSpaceYOffset;
    }

    @Override
    public boolean isFlipped() {
        return this.isFlipped;
    }

    @Override
    public void setFlipped(boolean isFlipped) {
        this.isFlipped = isFlipped;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        GuiRenderState renderState = ((GuiGraphicsMixin)graphics).getGuiRenderState();
        float scale = Math.min(this.width, this.height);
        PoseStack matrixStack = new PoseStack();
        matrixStack.translate((float)this.center.x, (float)this.center.y, 0.0f);
        matrixStack.scale(scale, -scale, scale);
        if (this.isFlipped) {
            matrixStack.mulPose((Quaternionfc)new Quaternionf(new AxisAngle4d(Math.PI, new Vector3f(0.0f, 1.0f, 0.0f))));
        }
        matrixStack.translate(this.modelSpaceXOffset, this.modelSpaceYOffset, 0.0f);
        for (TexturedModel moo : this.model.get(this.isFlipped)) {
            renderState.submitGuiElement((GuiElementRenderState)new ModelElementRenderState(this.rect, moo.texture().atlasLocation(), RenderPipelines.CUTOUT, buffer -> RenderingUtil.render(matrixStack.last(), moo.model(), Minecraft.getInstance().getAtlasManager().get(moo.texture()).wrap(buffer), 0xF000F0, OverlayTexture.NO_OVERLAY, moo.tint(), 0.0f)));
        }
    }
}

