/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui.widgets;

import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.gui.utils.WithMutableX;
import gollorum.signpost.mixin.GuiGraphicsMixin;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public class InputBox
extends EditBox
implements WithMutableX {
    private boolean shouldDropShadow;
    private final Font configFont;
    private final List<Function<Integer, Boolean>> keyCodeConsumers = new ArrayList<Function<Integer, Boolean>>();
    private final double zOffset;

    public InputBox(Font configFont, Rect inputFieldRect, boolean shouldDropShadow, double zOffset) {
        this(configFont, inputFieldRect, shouldDropShadow, zOffset, 500);
    }

    private InputBox(Font copyFont, Rect inputFieldRect, boolean shouldDropShadow, double zOffset, int maxStringLength) {
        super(copyFont, inputFieldRect.point.x, inputFieldRect.point.y, inputFieldRect.width, inputFieldRect.height, (Component)Component.literal((String)""));
        this.configFont = copyFont;
        this.shouldDropShadow = shouldDropShadow;
        this.setTextShadow(shouldDropShadow);
        this.zOffset = zOffset;
        this.setMaxLength(maxStringLength);
    }

    public boolean keyPressed(KeyEvent event) {
        for (Function<Integer, Boolean> consumer : this.keyCodeConsumers) {
            if (!consumer.apply(event.key()).booleanValue()) continue;
            return true;
        }
        return super.keyPressed(event);
    }

    public void addKeyCodeListener(int keyCode, Runnable action) {
        this.keyCodeConsumers.add(i -> {
            if (i == keyCode) {
                action.run();
                return true;
            }
            return false;
        });
    }

    public void renderWidget(GuiGraphics graphics, int p_94161_, int p_94162_, float p_94163_) {
        if (!this.shouldDropShadow) {
            graphics = new NoShadowGuiGraphics(this, graphics);
        }
        if (this.isHovered && !this.isBordered()) {
            int n = this.getY();
            Objects.requireNonNull(this.configFont);
            int fromY = n + (9 - this.height) / 2;
            graphics.fill(RenderPipelines.GUI, this.getX(), fromY, this.getX() + this.width, fromY + this.height, 0x40FFFFFF);
        }
        super.renderWidget(graphics, p_94161_, p_94162_, p_94163_);
    }

    public void setBordered(boolean shouldBeBordered) {
        super.setBordered(shouldBeBordered);
        this.setY(this.getY() + (shouldBeBordered ? -(this.height - 8) / 2 : (this.height - 8) / 2));
    }

    @Override
    public int getXPos() {
        return this.getX();
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public void setXPos(int x) {
        this.setX(x);
    }

    private class NoShadowGuiGraphics
    extends GuiGraphics {
        public NoShadowGuiGraphics(InputBox inputBox, GuiGraphics original) {
            super(Minecraft.getInstance(), ((GuiGraphicsMixin)original).getGuiRenderState());
        }

        public void drawString(Font font, @Nullable String text, int x, int y, int color) {
            super.drawString(font, text, x, y, color, false);
        }

        public void drawString(Font font, FormattedCharSequence text, int x, int y, int color) {
            super.drawString(font, text, x, y, color, false);
        }

        public void drawString(Font font, Component text, int x, int y, int color) {
            super.drawString(font, text, x, y, color, false);
        }

        public void drawWordWrap(Font font, FormattedText text, int x, int y, int lineWidth, int color) {
            this.drawWordWrap(font, text, x, y, lineWidth, color, false);
        }
    }
}

