/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui.widgets;

import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.utils.Either;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.network.chat.Component;

public class SpriteSelectionButton
extends AbstractButton {
    private final Either<TextureAtlasSprite, Material> material;
    private final int tint;
    private final Consumer<SpriteSelectionButton> onPressed;

    public SpriteSelectionButton(Rect rect, Either<TextureAtlasSprite, Material> material, int tint, Consumer<SpriteSelectionButton> pressedAction) {
        super(rect.point.x, rect.point.y, rect.width, rect.height, (Component)Component.literal((String)""));
        this.onPressed = pressedAction;
        this.material = material;
        if ((tint & 0xFF000000) == 0) {
            tint |= 0xFF000000;
        }
        this.tint = tint;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        TextureAtlasSprite sprite = this.material.leftOr(arg_0 -> ((GuiGraphics)graphics).getSprite(arg_0));
        SpriteContents contents = sprite.contents();
        if (contents.width() > contents.height()) {
            this.height = this.width * contents.height() / contents.width();
        } else if (contents.width() < contents.height()) {
            this.width = this.height * contents.width() / contents.height();
        }
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, sprite, this.getX(), this.getY(), this.width, this.height, this.tint);
        int xMin = this.getX();
        int xMax = xMin + this.width;
        int yMin = this.getY();
        int yMax = yMin + this.height;
        if (this.isHovered) {
            graphics.fill(RenderPipelines.GUI, xMin, yMin, xMax, yMax, 0x50FFFFFF);
        }
    }

    public void onPress(InputWithModifiers inputWithModifiers) {
        this.onPressed.accept(this);
    }

    public void updateWidgetNarration(NarrationElementOutput p_169152_) {
    }
}

