/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.block.tiles.WaystoneTile;
import gollorum.signpost.minecraft.loot.LootEntries;
import gollorum.signpost.utils.BlockPartInstance;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class PostBlockPartDropLoot
extends LootPoolSingletonContainer {
    public static final MapCodec<PostBlockPartDropLoot> MAP_CODEC = RecordCodecBuilder.mapCodec(inst -> PostBlockPartDropLoot.singletonFields((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, PostBlockPartDropLoot::new));

    public static LootPoolSingletonContainer.Builder<?> createBuilder() {
        return PostBlockPartDropLoot.simpleBuilder(PostBlockPartDropLoot::new);
    }

    protected PostBlockPartDropLoot(int weight, int quality, List<LootItemCondition> conditions, List<LootItemFunction> functions) {
        super(weight, quality, conditions, functions);
    }

    protected void createItemStack(Consumer<ItemStack> consumer, LootContext lootContext) {
        Iterator<BlockPartInstance> iterator = lootContext.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (iterator instanceof PostTile) {
            PostTile postTile = (PostTile)((Object)iterator);
            for (BlockPartInstance part : postTile.getParts()) {
                for (ItemStack item : part.blockPart().getDrops()) {
                    consumer.accept(item);
                }
            }
        } else if (lootContext.getOptionalParameter(LootContextParams.BLOCK_ENTITY) instanceof WaystoneTile) {
            consumer.accept(new ItemStack((ItemLike)Items.GLOW_ITEM_FRAME, 13));
        }
    }

    public LootPoolEntryType getType() {
        return LootEntries.POST_BLOCK_LOOT;
    }
}

