/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.models.modelGeneration;

import gollorum.signpost.minecraft.models.modelGeneration.FaceRotation;
import gollorum.signpost.minecraft.models.modelGeneration.TextureSegment;
import java.util.function.Function;
import org.joml.Vector2f;

public class TextureArea {
    public final Vector2f from;
    public final Vector2f fromTo;
    public final Vector2f toFrom;
    public final Vector2f to;

    public TextureArea(TextureSegment u, TextureSegment v) {
        this.from = new Vector2f(u.from, v.from);
        this.fromTo = new Vector2f(u.from, v.to);
        this.toFrom = new Vector2f(u.to, v.from);
        this.to = new Vector2f(u.to, v.to);
    }

    public TextureArea(Vector2f from, Vector2f fromTo, Vector2f toFrom, Vector2f toTo) {
        this.from = from;
        this.fromTo = fromTo;
        this.toFrom = toFrom;
        this.to = toTo;
    }

    public TextureArea rotate(FaceRotation rotation) {
        return new TextureArea(TextureArea.rotate(this.from, rotation), TextureArea.rotate(this.fromTo, rotation), TextureArea.rotate(this.toFrom, rotation), TextureArea.rotate(this.to, rotation));
    }

    private static Vector2f rotate(Vector2f v, FaceRotation rotation) {
        int c = 8;
        int cc = c + c;
        return switch (rotation) {
            case FaceRotation.Zero -> v;
            case FaceRotation.CounterClockwise90 -> new Vector2f(v.y, (float)cc - v.x);
            case FaceRotation.UpsideDown -> new Vector2f((float)cc - v.x, (float)cc - v.y);
            case FaceRotation.Clockwise90 -> new Vector2f((float)cc - v.y, v.x);
            default -> throw new RuntimeException("Rotation type " + String.valueOf((Object)rotation) + " is not supported");
        };
    }

    public TextureArea map(Function<Float, Float> uMapping, Function<Float, Float> vMapping) {
        return new TextureArea(new Vector2f(uMapping.apply(Float.valueOf(this.from.x)).floatValue(), vMapping.apply(Float.valueOf(this.from.y)).floatValue()), new Vector2f(uMapping.apply(Float.valueOf(this.fromTo.x)).floatValue(), vMapping.apply(Float.valueOf(this.fromTo.y)).floatValue()), new Vector2f(uMapping.apply(Float.valueOf(this.toFrom.x)).floatValue(), vMapping.apply(Float.valueOf(this.toFrom.y)).floatValue()), new Vector2f(uMapping.apply(Float.valueOf(this.to.x)).floatValue(), vMapping.apply(Float.valueOf(this.to.y)).floatValue()));
    }

    public TextureArea flipU() {
        return new TextureArea(new Vector2f(this.to.x, this.from.y), new Vector2f(this.toFrom.x, this.fromTo.y), new Vector2f(this.fromTo.x, this.toFrom.y), new Vector2f(this.from.x, this.to.y));
    }

    public TextureArea flipV() {
        return new TextureArea(new Vector2f(this.from.x, this.to.y), new Vector2f(this.fromTo.x, this.toFrom.y), new Vector2f(this.toFrom.x, this.fromTo.y), new Vector2f(this.to.x, this.from.y));
    }
}

