/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import gollorum.signpost.minecraft.gui.utils.TextureResource;
import gollorum.signpost.minecraft.rendering.ModelElementRenderState;
import gollorum.signpost.minecraft.rendering.Text3dElementRenderState;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.font.TextRenderable;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.gui.render.state.GuiRenderState;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.OrderedSubmitNodeCollector;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.MovingBlockRenderState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.HitboxesRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class GuiFakeCollector
implements SubmitNodeCollector {
    private final ScreenRectangle rect;
    private final GuiRenderState renderState;
    private final Font font;

    public GuiFakeCollector(ScreenRectangle rect, GuiRenderState renderState, Font font) {
        this.rect = rect;
        this.renderState = renderState;
        this.font = font;
    }

    public OrderedSubmitNodeCollector order(int i) {
        throw new RuntimeException("Not supported");
    }

    public void submitHitbox(PoseStack poseStack, EntityRenderState entityRenderState, HitboxesRenderState hitboxesRenderState) {
        throw new RuntimeException("Not supported");
    }

    public void submitShadow(PoseStack poseStack, float v, List<EntityRenderState.ShadowPiece> list) {
        throw new RuntimeException("Not supported");
    }

    public void submitNameTag(PoseStack poseStack, @Nullable Vec3 vec3, int i, Component component, boolean b, int i1, double v, CameraRenderState cameraRenderState) {
        throw new RuntimeException("Not supported");
    }

    public void submitText(PoseStack poseStack, float x, float y, FormattedCharSequence text, boolean dropShadow, Font.DisplayMode displayMode, final int packedLight, int color, int backgroundColor, int outlineColor) {
        final Matrix4f pose = poseStack.last().copy().pose();
        Font.PreparedText preparedText = this.font.prepareText(text, x, y, color, dropShadow, backgroundColor);
        preparedText.visit(new Font.GlyphVisitor(){

            public void acceptGlyph(TextRenderable renderable) {
                this.accept(renderable);
            }

            public void acceptEffect(TextRenderable renderable) {
                this.accept(renderable);
            }

            private void accept(TextRenderable renderable) {
                GuiFakeCollector.this.renderState.submitGuiElement((GuiElementRenderState)new Text3dElementRenderState(pose, renderable, packedLight, GuiFakeCollector.this.rect));
            }
        });
    }

    public void submitFlame(PoseStack poseStack, EntityRenderState entityRenderState, Quaternionf quaternionf) {
        throw new RuntimeException("Not supported");
    }

    public void submitLeash(PoseStack poseStack, EntityRenderState.LeashState leashState) {
        throw new RuntimeException("Not supported");
    }

    public <S> void submitModel(Model<? super S> model, S s, PoseStack poseStack, RenderType renderType, int i, int i1, int i2, @Nullable TextureAtlasSprite textureAtlasSprite, int i3, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        throw new RuntimeException("Not supported");
    }

    public void submitModelPart(ModelPart modelPart, PoseStack poseStack, RenderType renderType, int i, int i1, @Nullable TextureAtlasSprite textureAtlasSprite, boolean b, boolean b1, int i2, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay, int i3) {
        throw new RuntimeException("Not supported");
    }

    public void submitBlock(PoseStack poseStack, BlockState blockState, int i, int i1, int i2) {
        throw new RuntimeException("Not supported");
    }

    public void submitMovingBlock(PoseStack poseStack, MovingBlockRenderState movingBlockRenderState) {
        throw new RuntimeException("Not supported");
    }

    public void submitBlockModel(PoseStack poseStack, RenderType renderType, BlockStateModel blockStateModel, float v, float v1, float v2, int i, int i1, int i2) {
        throw new RuntimeException("Not supported");
    }

    public void submitItem(PoseStack poseStack, ItemDisplayContext itemDisplayContext, int i, int i1, int i2, int[] ints, List<BakedQuad> list, RenderType renderType, ItemStackRenderState.FoilType foilType) {
        throw new RuntimeException("Not supported");
    }

    public void submitCustomGeometry(PoseStack poseStack, RenderType renderType, SubmitNodeCollector.CustomGeometryRenderer customGeometryRenderer) {
        this.submitCustomGeometry(poseStack, renderType, customGeometryRenderer, TextureResource.blockAtlas);
    }

    public void submitCustomGeometry(PoseStack poseStack, RenderType renderType, SubmitNodeCollector.CustomGeometryRenderer customGeometryRenderer, ResourceLocation atlasLocation) {
        PoseStack.Pose pose = poseStack.last().copy();
        this.renderState.submitGuiElement((GuiElementRenderState)new ModelElementRenderState(this.rect, atlasLocation, renderType.pipeline(), vertexConsumer -> customGeometryRenderer.render(pose, vertexConsumer)));
    }

    public void submitParticleGroup(SubmitNodeCollector.ParticleGroupRenderer particleGroupRenderer) {
        throw new RuntimeException("Not supported");
    }
}

