/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.rendering;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.font.TextRenderable;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.FormattedCharSequence;
import org.joml.Matrix4f;

public record Text3dElementRenderState(Matrix4f pose, TextRenderable renderable, int packedLight, ScreenRectangle bounds) implements GuiElementRenderState
{
    public void buildVertices(VertexConsumer vertexConsumer) {
        this.renderable.render(this.pose, vertexConsumer, this.packedLight, true);
    }

    public RenderPipeline pipeline() {
        return RenderPipelines.TEXT;
    }

    public TextureSetup textureSetup() {
        return TextureSetup.singleTextureWithLightmap((GpuTextureView)this.renderable.textureView());
    }

    public ScreenRectangle scissorArea() {
        return null;
    }

    public record ButDifferent(Matrix4f pose, float x, float y, FormattedCharSequence text, boolean dropShadow, Font.DisplayMode displayMode, int packedLight, int color, int backgroundColor, int outlineColor, ScreenRectangle bounds) implements GuiElementRenderState
    {
        public void buildVertices(VertexConsumer vertexConsumer) {
            Font font = Minecraft.getInstance().font;
            font.drawInBatch(this.text, this.x, this.y, this.color, this.dropShadow, this.pose, (MultiBufferSource)Minecraft.getInstance().renderBuffers().bufferSource(), this.displayMode, this.backgroundColor, this.packedLight);
        }

        public RenderPipeline pipeline() {
            return RenderPipelines.GUI_TEXT;
        }

        public TextureSetup textureSetup() {
            Minecraft minecraft = Minecraft.getInstance();
            TextureManager texturemanager = minecraft.getTextureManager();
            GpuTextureView gputextureview = texturemanager.getTexture(Sheets.GUI_SHEET).getTextureView();
            return TextureSetup.singleTextureWithLightmap((GpuTextureView)gputextureview);
        }

        public ScreenRectangle scissorArea() {
            return null;
        }
    }
}

