/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.utils;

import gollorum.signpost.Signpost;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class Inventory {
    private static List<ItemStack> getAllItemStack(Player player) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(player.getMainHandItem());
        ret.add(player.getOffhandItem());
        for (ItemStack item : player.getInventory()) {
            if (item == null || item.isEmpty()) continue;
            ret.add(item);
        }
        return ret;
    }

    public static int getItemCount(Player player, Item item) {
        int count = 0;
        for (ItemStack currentStack : Inventory.getAllItemStack(player)) {
            if (!currentStack.getItem().equals(item)) continue;
            count += currentStack.getCount();
        }
        return count;
    }

    public static <TPlayer extends Player> void tryPay(TPlayer player, ItemStack itemStack, Consumer<TPlayer> onSuccess) {
        if (!player.hasInfiniteMaterials()) {
            if (Inventory.tryConsume(player, itemStack)) {
                onSuccess.accept(player);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"signpost.too_expensive", (Object[])new Object[]{itemStack.getCount(), Component.translatable((String)itemStack.getItem().getDescriptionId())}), false);
            }
        } else {
            onSuccess.accept(player);
        }
    }

    public static boolean tryConsume(Player player, ItemStack itemStack) {
        if (itemStack.getCount() <= 0) {
            return true;
        }
        if (Inventory.getItemCount(player, itemStack.getItem()) >= itemStack.getCount()) {
            int remainingItems = itemStack.getCount();
            for (ItemStack currentStack : Inventory.getAllItemStack(player)) {
                if (!currentStack.getItem().equals(itemStack.getItem())) continue;
                currentStack.setCount((remainingItems -= currentStack.getCount()) > 0 ? 0 : -remainingItems);
                if (remainingItems > 0) continue;
                return true;
            }
            if (remainingItems <= 0) {
                return true;
            }
            Signpost.LOGGER.error("Tried to consume more items than were present");
        }
        return false;
    }
}

