/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.utils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gollorum.signpost.minecraft.gui.utils.TextureResource;
import gollorum.signpost.utils.Tint;
import gollorum.signpost.utils.serialization.OptionalSerializerV1;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.client.resources.model.Material;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public record Texture(ResourceLocation location, ResourceLocation atlasLocation, Optional<Tint> tint) {
    public static final Codec<Texture> CODEC_V1 = RecordCodecBuilder.create(i -> i.group((App)ResourceLocation.CODEC.fieldOf("ResourceLocation").forGetter(Texture::location), (App)OptionalSerializerV1.of(Tint.Serialization.CODEC).codec().fieldOf("Tint").forGetter(Texture::tint)).apply((Applicative)i, (loc, tint) -> new Texture((ResourceLocation)loc, Optional.empty(), (Optional<Tint>)tint)));
    public static final Codec<Texture> CODEC_V2 = RecordCodecBuilder.create(i -> i.group((App)ResourceLocation.CODEC.fieldOf("ResourceLocation").forGetter(Texture::location), (App)Codec.optionalField((String)"AtlasLocation", (Codec)ResourceLocation.CODEC, (boolean)true).forGetter(t -> Optional.of(t.atlasLocation)), (App)Codec.optionalField((String)"Tint", Tint.Serialization.CODEC, (boolean)true).forGetter(Texture::tint)).apply((Applicative)i, Texture::new));
    public static final StreamCodec<ByteBuf, Texture> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, Texture::location, (StreamCodec)ResourceLocation.STREAM_CODEC, Texture::atlasLocation, (StreamCodec)ByteBufCodecs.optional(Tint.Serialization.STREAM_CODEC), Texture::tint, Texture::new);

    public Texture(ResourceLocation location) {
        this(location, Optional.empty(), Optional.empty());
    }

    private Texture(ResourceLocation location, Optional<ResourceLocation> atlasLocation, Optional<Tint> tint) {
        this(location, atlasLocation.orElse(TextureResource.blockAtlas), tint);
    }

    @Override
    public String toString() {
        return null;
    }

    public Material toMaterial() {
        return new Material(this.atlasLocation, this.location);
    }

    public static Codec<Texture> codec(int version) {
        return switch (version) {
            case 1 -> CODEC_V1;
            case 2 -> CODEC_V2;
            default -> throw new IllegalArgumentException("Unsupported version: " + version);
        };
    }
}

