/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.utils.tints;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gollorum.signpost.utils.Tint;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;

public record BlockColorTint(Block block, int tintIndex) implements Tint
{
    public static final MapCodec<BlockColorTint> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)ResourceLocation.CODEC.fieldOf("Block").xmap(BlockColorTint::getBlock, BlockColorTint::getKey).forGetter(BlockColorTint::block), (App)Codec.INT.fieldOf("TintIndex").forGetter(BlockColorTint::tintIndex)).apply((Applicative)i, BlockColorTint::new));
    public static final StreamCodec<ByteBuf, BlockColorTint> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, t -> BlockColorTint.getKey(t.block), (StreamCodec)ByteBufCodecs.INT, t -> t.tintIndex, (blockKey, tintIndex) -> new BlockColorTint(BlockColorTint.getBlock(blockKey), (int)tintIndex));

    @Override
    public int getColorAt(BlockAndTintGetter level, BlockPos pos) {
        return Minecraft.getInstance().getBlockColors().getColor(this.block.defaultBlockState(), level, pos, this.tintIndex);
    }

    public static void register() {
        Tint.Serialization.register("blockColor", new Tint.Serializer(BlockColorTint.class, CODEC, STREAM_CODEC));
    }

    private static Registry<Block> getBlockRegistry() {
        return BuiltInRegistries.BLOCK;
    }

    private static Block getBlock(ResourceLocation key) {
        return (Block)((Holder.Reference)BlockColorTint.getBlockRegistry().get(key).get()).value();
    }

    private static ResourceLocation getKey(Block block) {
        return Objects.requireNonNull(BlockColorTint.getBlockRegistry().getKey((Object)block));
    }
}

