/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.utils.tints;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import gollorum.signpost.minecraft.gui.utils.IFluidTextureProvider;
import gollorum.signpost.utils.Tint;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;

public record FluidTint(Fluid fluid) implements Tint
{
    public static final MapCodec<FluidTint> CODEC = Codec.STRING.fieldOf("ResourceLocation").xmap(s -> new FluidTint((Fluid)((Holder.Reference)FluidTint.getFluidRegistry().get(ResourceLocation.parse((String)s)).get()).value()), t -> FluidTint.getFluidRegistry().getKey((Object)t.fluid).toString());
    public static final StreamCodec<ByteBuf, FluidTint> STREAM_CODEC = ResourceLocation.STREAM_CODEC.map(rl -> new FluidTint((Fluid)FluidTint.getFluidRegistry().getValue(rl)), t -> FluidTint.getFluidRegistry().getKey((Object)t.fluid));

    @Override
    public int getColorAt(BlockAndTintGetter level, BlockPos pos) {
        return IFluidTextureProvider.getInstance().getTintColor(this.fluid.defaultFluidState(), level, pos);
    }

    public static void register() {
        Tint.Serialization.register("fluid", new Tint.Serializer(FluidTint.class, CODEC, STREAM_CODEC));
    }

    private static Registry<Fluid> getFluidRegistry() {
        return BuiltInRegistries.FLUID;
    }
}

