/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gollorum.signpost.minecraft.config.IConfig;
import gollorum.signpost.minecraft.worldgen.JigsawDeserializers;
import gollorum.signpost.minecraft.worldgen.VillageWaystone;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.LegacySinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.jetbrains.annotations.NotNull;

public class WaystoneJigsawPiece
extends LegacySinglePoolElement {
    private static Set<BlockPos> generatedPieces;
    public static final MapCodec<WaystoneJigsawPiece> codec;

    public static void reset() {
        generatedPieces = new HashSet<BlockPos>();
    }

    public WaystoneJigsawPiece(ResourceLocation location, Holder<StructureProcessorList> structureProcessorListSupplier, StructureTemplatePool.Projection placementBehaviour, Optional<LiquidSettings> liquidSettings) {
        this((Either<ResourceLocation, StructureTemplate>)Either.left((Object)location), structureProcessorListSupplier, placementBehaviour, liquidSettings);
    }

    public WaystoneJigsawPiece(Either<ResourceLocation, StructureTemplate> template, Holder<StructureProcessorList> structureProcessorListSupplier, StructureTemplatePool.Projection placementBehaviour, Optional<LiquidSettings> liquidSettings) {
        super(template, structureProcessorListSupplier, placementBehaviour, liquidSettings);
    }

    public boolean place(StructureTemplateManager templateManager, WorldGenLevel seedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, BlockPos pieceLocation, BlockPos villageLocation, Rotation rotation, BoundingBox boundingBox, RandomSource random, LiquidSettings liquidSettings, boolean keepJigsaws) {
        if (!IConfig.IServer.getInstance().worldGen().isVillageGenerationEnabled()) {
            return false;
        }
        if (generatedPieces.contains(villageLocation) || VillageWaystone.getInstance().doesWaystoneExistIn(villageLocation)) {
            return false;
        }
        StructurePlaceSettings placementSettings = this.getSettings(rotation, boundingBox, liquidSettings, keepJigsaws);
        StructureTemplate template = (StructureTemplate)this.template.map(arg_0 -> ((StructureTemplateManager)templateManager).getOrCreate(arg_0), Function.identity());
        if (template.placeInWorld((ServerLevelAccessor)seedReader, pieceLocation, villageLocation, placementSettings, random, 18)) {
            generatedPieces.add(villageLocation);
            return true;
        }
        return false;
    }

    @NotNull
    public StructurePoolElementType<?> getType() {
        return JigsawDeserializers.waystone;
    }

    @NotNull
    public String toString() {
        return "SingleSignpostWaystone[" + String.valueOf(this.template) + "]";
    }

    static {
        codec = RecordCodecBuilder.mapCodec(codecBuilder -> codecBuilder.group((App)WaystoneJigsawPiece.templateCodec(), (App)WaystoneJigsawPiece.processorsCodec(), (App)WaystoneJigsawPiece.projectionCodec(), (App)WaystoneJigsawPiece.overrideLiquidSettingsCodec()).apply((Applicative)codecBuilder, WaystoneJigsawPiece::new));
    }
}

