/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.networking;

import gollorum.signpost.Signpost;
import gollorum.signpost.SignpostNeoforge;
import gollorum.signpost.compat.Compat;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.utils.Tuple;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.client.network.event.RegisterClientPayloadHandlersEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class NeoForgePacketHandler
extends PacketHandler {
    public static void initialize(IEventBus bus) {
        instance = new NeoForgePacketHandler();
        instance.init();
        instance.register(new SignpostNeoforge.JoinServerEvent(), ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)"join_server"));
        for (Map.Entry<ResourceLocation, PacketHandler.Event<?>> entry : Compat.getEvents().entrySet()) {
            instance.register(entry.getValue(), entry.getKey());
        }
        bus.register(NeoForgePacketHandler.class);
    }

    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("signpost");
        for (Tuple<PacketHandler.Event<?>, ResourceLocation> tuple : NeoForgePacketHandler.instance.events) {
            ((NeoForgePacketHandler)instance).registerCommon(tuple._1(), tuple._2(), registrar);
        }
    }

    private <T> void registerCommon(PacketHandler.Event<T> event, ResourceLocation id, PayloadRegistrar registrar) {
        CustomPacketPayload.Type type = new CustomPacketPayload.Type(id);
        registrar.playBidirectional(type, event.codec().map(message -> new Payload<Object>(type, event, message), payload -> payload.message), (payload, context) -> context.enqueueWork(() -> payload.event.handle(payload.message, new PacketHandler.Context.Server((ServerPlayer)context.player()))));
    }

    @SubscribeEvent
    public static void register(RegisterClientPayloadHandlersEvent event) {
        for (Tuple<PacketHandler.Event<?>, ResourceLocation> tuple : NeoForgePacketHandler.instance.events) {
            ((NeoForgePacketHandler)instance).registerClient(tuple._2(), event);
        }
    }

    private <T> void registerClient(ResourceLocation id, RegisterClientPayloadHandlersEvent registrar) {
        registrar.register(new CustomPacketPayload.Type(id), (payload, context) -> context.enqueueWork(() -> payload.event.handle(payload.message, new PacketHandler.Context.Client())));
    }

    private <T> Payload<T> toPayload(T message) {
        Tuple tuple = (Tuple)this.eventMap.get(message.getClass());
        return new Payload<T>(new CustomPacketPayload.Type((ResourceLocation)tuple._2()), (PacketHandler.Event)tuple._1(), message);
    }

    @Override
    public <T> void sendToServer(T message) {
        ClientPacketDistributor.sendToServer(this.toPayload(message), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public <T> void sendToPlayer(ServerPlayer target, T message) {
        PacketDistributor.sendToPlayer((ServerPlayer)target, this.toPayload(message), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public <T> void sendToTracing(ServerLevel world, BlockPos pos, Supplier<T> t) {
        if (world == null) {
            Signpost.LOGGER.warn("No world to notify mutation");
        } else if (pos == null) {
            Signpost.LOGGER.warn("No position to notify mutation");
        } else {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)world, (ChunkPos)new ChunkPos(pos), this.toPayload(t.get()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public <T> void sendToTracing(BlockEntity tile, Supplier<T> t) {
        this.sendToTracing((ServerLevel)tile.getLevel(), tile.getBlockPos(), t);
    }

    @Override
    public <T> void sendToAll(T message) {
        PacketDistributor.sendToAllPlayers(this.toPayload(message), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private record Payload<T>(CustomPacketPayload.Type<Payload<T>> type, PacketHandler.Event<T> event, T message) implements CustomPacketPayload
    {
    }
}

