/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.networking;

import gollorum.signpost.Teleport;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.gui.RequestSignGui;
import gollorum.signpost.minecraft.gui.RequestWaystoneGui;
import gollorum.signpost.utils.Tuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class PacketHandler {
    protected static PacketHandler instance = null;
    protected final List<Tuple<Event<?>, ResourceLocation>> events = new ArrayList();
    protected final Map<Class<?>, Tuple<Event<?>, ResourceLocation>> eventMap = new HashMap();

    public static PacketHandler getInstance() {
        return instance;
    }

    protected void init() {
        this.register(new PostTile.PartAddedEvent(), ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)"part_added"));
        this.register(new PostTile.PartMutatedEvent(), ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)"part_mutated"));
        this.register(new PostTile.PartRemovedEvent(), ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)"part_removed"));
        this.register(new PostTile.UpdateAllPartsEvent(), ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)"update_all_parts"));
        this.register(new Teleport.Request(), ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)"teleport_request"));
        this.register(new Teleport.RequestGui(), ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)"teleport_request_gui"));
        this.register(new RequestSignGui(), ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)"request_sign_gui"));
        this.register(new RequestSignGui.ForNewSign(), ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)"request_sign_gui_for_new_sign"));
        this.register(new RequestWaystoneGui(), ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)"request_waystone_gui"));
        this.register(new WaystoneLibrary.RequestAllWaystoneNamesEvent(), ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)"request_all_waystone_names"));
        this.register(new WaystoneLibrary.DeliverAllWaystoneNamesEvent(), ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)"deliver_all_waystone_names"));
        this.register(new WaystoneLibrary.RequestAllWaystonesEvent(), ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)"request_all_waystones"));
        this.register(new WaystoneLibrary.DeliverAllWaystonesEvent(), ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)"deliver_all_waystones"));
        this.register(new WaystoneLibrary.WaystoneUpdatedEventEvent(), ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)"waystone_updated_event"));
        this.register(new WaystoneLibrary.RequestWaystoneLocationEvent(), ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)"request_waystone_location"));
        this.register(new WaystoneLibrary.DeliverWaystoneLocationEvent(), ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)"deliver_waystone_location"));
        this.register(new WaystoneLibrary.RequestWaystoneAtLocationEvent(), ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)"request_waystone_at_location"));
        this.register(new WaystoneLibrary.DeliverWaystoneAtLocationEvent(), ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)"deliver_waystone_at_location"));
        this.register(new WaystoneLibrary.DeliverIdEvent(), ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)"deliver_id"));
        this.register(new WaystoneLibrary.RequestIdEvent(), ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)"request_id"));
    }

    public final <T> void register(Event<T> event, ResourceLocation id) {
        this.events.add(new Tuple<Event<T>, ResourceLocation>(event, id));
        this.eventMap.put(event.getMessageClass(), new Tuple<Event<T>, ResourceLocation>(event, id));
    }

    public abstract <T> void sendToServer(T var1);

    public abstract <T> void sendToPlayer(ServerPlayer var1, T var2);

    public abstract <T> void sendToTracing(ServerLevel var1, BlockPos var2, Supplier<T> var3);

    public abstract <T> void sendToTracing(BlockEntity var1, Supplier<T> var2);

    public abstract <T> void sendToAll(T var1);

    public static interface Event<T> {
        public Class<T> getMessageClass();

        public void handle(T var1, Context var2);

        public StreamCodec<RegistryFriendlyByteBuf, T> codec();

        public static interface ForServer<T>
        extends Event<T> {
            @Override
            default public void handle(T message, Context context) {
                if (!(context instanceof Context.Server)) {
                    throw new RuntimeException("Tried to handle server event on client");
                }
                Context.Server server = (Context.Server)context;
                this.handle(message, server);
            }

            public void handle(T var1, Context.Server var2);
        }

        public static interface ForClient<T>
        extends Event<T> {
            @Override
            default public void handle(T message, Context context) {
                if (!(context instanceof Context.Client)) {
                    throw new RuntimeException("Tried to handle client event on server");
                }
                Context.Client client = (Context.Client)context;
                this.handle(message, client);
            }

            public void handle(T var1, Context.Client var2);
        }
    }

    public static interface Context {
        public HolderLookup.Provider getHolderLookupProvider();

        public record Client() implements Context
        {
            @Override
            public HolderLookup.Provider getHolderLookupProvider() {
                return Minecraft.getInstance().player.registryAccess();
            }
        }

        public record Server(ServerPlayer sender) implements Context
        {
            @Override
            public HolderLookup.Provider getHolderLookupProvider() {
                return this.sender.registryAccess();
            }
        }
    }
}

