/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.registry;

import gollorum.signpost.minecraft.block.ModelWaystone;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.block.WaystoneBlock;
import gollorum.signpost.minecraft.items.Brush;
import gollorum.signpost.minecraft.items.GenerationWand;
import gollorum.signpost.minecraft.items.PostItem;
import gollorum.signpost.minecraft.items.WaystoneItem;
import gollorum.signpost.minecraft.items.Wrench;
import gollorum.signpost.registry.BlockRegistry;
import gollorum.signpost.utils.Tuple;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ItemRegistry {
    private static final DeferredRegister.Items REGISTER = DeferredRegister.createItems((String)"signpost");
    public static final DeferredItem<WaystoneItem> WAYSTONE_ITEM = REGISTER.register("waystone", () -> new WaystoneItem(WaystoneBlock.getInstance(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)"waystone")))));
    public static final List<Tuple<ModelWaystone.Variant, DeferredItem<Item>>> ModelWaystoneItems = ModelWaystone.variants.stream().map(ItemRegistry::registerModelWaystoneItem).toList();
    public static final List<DeferredItem<Item>> POSTS_ITEMS = PostBlock.AllVariants.stream().map(ItemRegistry::registerPostItem).toList();
    public static final DeferredItem<Item> WaystoneGeneratorItem = REGISTER.register("waystone_generator", () -> new BlockItem((Block)BlockRegistry.WaystoneGenerator.get(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)"waystone_generator")))));
    public static final DeferredItem<Item> WRENCH = REGISTER.register("tool", Wrench::new);
    public static final DeferredItem<Item> BRUSH = REGISTER.register("brush", Brush::new);
    public static final DeferredItem<Item> GENERATION_WAND = REGISTER.register("generation_wand", GenerationWand::new);

    private static DeferredItem<Item> registerPostItem(PostBlock.Variant postVariant) {
        return REGISTER.register(postVariant.registryName, () -> new PostItem(postVariant.getBlock(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)postVariant.registryName)))));
    }

    private static Tuple<ModelWaystone.Variant, DeferredItem<Item>> registerModelWaystoneItem(ModelWaystone.Variant variant) {
        return new Tuple<ModelWaystone.Variant, DeferredItem<Item>>(variant, REGISTER.register(variant.registryName, () -> new WaystoneItem(variant.getBlock(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)variant.registryName))))));
    }

    public static void register(IEventBus bus) {
        REGISTER.register(bus);
    }
}

