/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils;

import gollorum.signpost.utils.IDelay;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

public class Delay
implements IDelay {
    public static final Delay INSTANCE = new Delay();
    private final List<Task> serverTasks = new ArrayList<Task>();
    private final List<Task> clientTasks = new ArrayList<Task>();

    @Override
    public void forFramesImpl(int frames, boolean onClient, Runnable run) {
        if (frames == 0) {
            run.run();
        } else {
            AtomicInteger framesLeft = new AtomicInteger(frames);
            (onClient ? this.clientTasks : this.serverTasks).add(new Task(() -> framesLeft.decrementAndGet() <= 0, run));
        }
    }

    @Override
    public void onServerUntilImpl(Supplier<Boolean> canRun, Runnable run) {
        if (canRun.get().booleanValue()) {
            run.run();
        } else {
            this.serverTasks.add(new Task(canRun, run));
        }
    }

    @Override
    public void onClientUntilImpl(Supplier<Boolean> canRun, Runnable run) {
        if (canRun.get().booleanValue()) {
            run.run();
        } else {
            this.clientTasks.add(new Task(canRun, run));
        }
    }

    @Override
    public void onServerUntilImpl(Supplier<Boolean> canRun, Runnable run, int timeoutFrames, Optional<Runnable> onTimeOut) {
        if (canRun.get().booleanValue()) {
            run.run();
        } else {
            this.delayUntil(canRun, run, timeoutFrames, this.serverTasks, onTimeOut);
        }
    }

    @Override
    public void onClientUntilImpl(Supplier<Boolean> canRun, Runnable run, int timeoutFrames, Optional<Runnable> onTimeOut) {
        if (canRun.get().booleanValue()) {
            run.run();
        } else {
            this.delayUntil(canRun, run, timeoutFrames, this.clientTasks, onTimeOut);
        }
    }

    @Override
    public <T> void onServerUntilIsPresentImpl(Supplier<Optional<T>> supplier, Consumer<T> run, int timeoutFrames, Optional<Runnable> onTimeOut) {
        AtomicReference result = new AtomicReference(supplier.get());
        if (result.get().isPresent()) {
            run.accept(result.get().get());
        } else {
            this.delayUntil(() -> {
                result.set((Optional)supplier.get());
                return ((Optional)result.get()).isPresent();
            }, () -> run.accept(((Optional)result.get()).get()), timeoutFrames, this.serverTasks, onTimeOut);
        }
    }

    @Override
    public <T> void onClientUntilIsPresentImpl(Supplier<Optional<T>> supplier, Consumer<T> run, int timeoutFrames, Optional<Runnable> onTimeOut) {
        AtomicReference result = new AtomicReference(supplier.get());
        if (result.get().isPresent()) {
            run.accept(result.get().get());
        } else {
            this.delayUntil(() -> {
                result.set((Optional)supplier.get());
                return ((Optional)result.get()).isPresent();
            }, () -> run.accept(((Optional)result.get()).get()), timeoutFrames, this.clientTasks, onTimeOut);
        }
    }

    private void delayUntil(Supplier<Boolean> canRun, Runnable run, int timeoutFrames, List<Task> taskList, Optional<Runnable> onTimeOut) {
        AtomicInteger framesLeft = new AtomicInteger(timeoutFrames);
        taskList.add(new Task(() -> {
            framesLeft.set(framesLeft.get() - 1);
            return (Boolean)canRun.get() != false || framesLeft.get() < 0;
        }, () -> {
            if (framesLeft.get() >= 0) {
                run.run();
            } else {
                onTimeOut.ifPresent(Runnable::run);
            }
        }));
    }

    @SubscribeEvent
    void onServerTick(ServerTickEvent.Pre event) {
        Task[] tasks = this.serverTasks.toArray(new Task[0]);
        this.serverTasks.clear();
        for (Task task : tasks) {
            if (task.canRun()) {
                task.run();
                continue;
            }
            this.serverTasks.add(task);
        }
    }

    @SubscribeEvent
    void onClientTick(ClientTickEvent.Pre event) {
        Task[] tasks = this.clientTasks.toArray(new Task[0]);
        this.clientTasks.clear();
        for (Task task : tasks) {
            if (task.canRun()) {
                task.run();
                continue;
            }
            this.clientTasks.add(task);
        }
    }

    private static class Task {
        private final Supplier<Boolean> canRun;
        private final Runnable run;

        public boolean canRun() {
            return this.canRun.get();
        }

        public void run() {
            this.run.run();
        }

        private Task(Supplier<Boolean> canRun, Runnable run) {
            this.canRun = canRun;
            this.run = run;
        }
    }
}

