/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gollorum.signpost.WaystoneDataBase;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.minecraft.config.IConfig;
import gollorum.signpost.minecraft.utils.TileEntityUtils;
import gollorum.signpost.security.WithOwner;
import gollorum.signpost.utils.Either;
import gollorum.signpost.utils.WaystoneLocationData;
import gollorum.signpost.utils.WorldLocation;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public final class WaystoneData
extends Record
implements WaystoneDataBase {
    private final WaystoneHandle.Vanilla handle;
    private final String name;
    private final WaystoneLocationData location;
    private final boolean isLocked;
    public static final Codec<WaystoneData> CODEC = RecordCodecBuilder.create(i -> i.group((App)WaystoneHandle.Vanilla.CODEC.fieldOf("handle").forGetter(WaystoneData::handle), (App)Codec.STRING.fieldOf("Name").forGetter(WaystoneData::name), (App)WaystoneLocationData.CODEC.fieldOf("Location").forGetter(WaystoneData::location), (App)Codec.BOOL.fieldOf("IsLocked").forGetter(WaystoneData::isLocked)).apply((Applicative)i, WaystoneData::new));
    public static final StreamCodec<ByteBuf, WaystoneData> STREAM_CODEC = StreamCodec.composite(WaystoneHandle.Vanilla.STREAM_CODEC, WaystoneData::handle, (StreamCodec)ByteBufCodecs.STRING_UTF8, WaystoneData::name, WaystoneLocationData.STREAM_CODEC, WaystoneData::location, (StreamCodec)ByteBufCodecs.BOOL, WaystoneData::isLocked, WaystoneData::new);

    public WaystoneData(WaystoneHandle.Vanilla handle, String name, WaystoneLocationData location, boolean isLocked) {
        this.handle = handle;
        this.name = name;
        this.location = location;
        this.isLocked = isLocked;
    }

    public WaystoneData withoutExplicitLevel() {
        if (this.location.block().world().isLeft()) {
            return new WaystoneData(this.handle, this.name, new WaystoneLocationData(WorldLocation.from(this.location.block().blockPos(), Either.right(this.location.block().world().leftOrThrow().dimension().location())), this.location.spawn()), this.isLocked);
        }
        return this;
    }

    public WaystoneData withName(String newName) {
        return new WaystoneData(this.handle, newName, this.location, this.isLocked);
    }

    public boolean hasThePermissionToEdit(Player player) {
        return WaystoneData.hasThePermissionToEdit(player, this.location, this.isLocked);
    }

    public static boolean hasThePermissionToEdit(Player player, WaystoneLocationData locationData, boolean isLocked) {
        return !isLocked || WaystoneData.hasSecurityPermissions(player, locationData);
    }

    public static boolean hasSecurityPermissions(Player player, WaystoneLocationData locationData) {
        return player.hasPermissions(IConfig.IServer.getInstance().permissions().editLockedWaystoneCommandPermissionLevel()) || TileEntityUtils.toWorld(locationData.block().world(), !(player instanceof ServerPlayer)).map(w -> w.getBlockEntity(locationData.block().blockPos())).flatMap(tile -> tile instanceof WithOwner.OfWaystone ? ((WithOwner.OfWaystone)tile).getWaystoneOwner() : Optional.empty()).map(owner -> owner.id().equals(player.getUUID())).orElse(true) != false;
    }

    @Override
    public WaystoneLocationData loc() {
        return this.location;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{WaystoneData.class, "handle;name;location;isLocked", "handle", "name", "location", "isLocked"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{WaystoneData.class, "handle;name;location;isLocked", "handle", "name", "location", "isLocked"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{WaystoneData.class, "handle;name;location;isLocked", "handle", "name", "location", "isLocked"}, this, o);
    }

    @Override
    public WaystoneHandle.Vanilla handle() {
        return this.handle;
    }

    @Override
    public String name() {
        return this.name;
    }

    public WaystoneLocationData location() {
        return this.location;
    }

    public boolean isLocked() {
        return this.isLocked;
    }
}

