/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gollorum.signpost.utils.Either;
import gollorum.signpost.utils.WorldLocation;
import gollorum.signpost.utils.math.geometry.Vector3;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;

public record WaystoneLocationData(WorldLocation block, Vector3 spawn) {
    public static final Codec<WaystoneLocationData> CODEC = RecordCodecBuilder.create(i -> i.group((App)WorldLocation.CODEC.fieldOf("Block").forGetter(WaystoneLocationData::block), (App)Vector3.CODEC.fieldOf("Spawn").forGetter(WaystoneLocationData::spawn)).apply((Applicative)i, WaystoneLocationData::new));
    public static final StreamCodec<ByteBuf, WaystoneLocationData> STREAM_CODEC = StreamCodec.composite(WorldLocation.STREAM_CODEC, WaystoneLocationData::block, Vector3.STREAM_CODEC, WaystoneLocationData::spawn, WaystoneLocationData::new);

    public WaystoneLocationData withoutExplicitLevel() {
        if (this.block.world().isLeft()) {
            return new WaystoneLocationData(WorldLocation.from(this.block.blockPos(), Either.right(this.block.world().leftOrThrow().dimension().location())), this.spawn);
        }
        return this;
    }
}

