/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gollorum.signpost.utils.Either;
import gollorum.signpost.utils.serialization.BlockPosSerializer;
import gollorum.signpost.utils.serialization.WorldSerializer;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public record WorldLocation(BlockPos blockPos, Either<Level, ResourceLocation> world) {
    public static final Codec<WorldLocation> CODEC = RecordCodecBuilder.create(i -> i.group((App)BlockPosSerializer.CODEC.fieldOf("Pos").forGetter(WorldLocation::blockPos), (App)WorldSerializer.MAP_CODEC.fieldOf("Level").forGetter(WorldLocation::world)).apply((Applicative)i, WorldLocation::from));
    public static final StreamCodec<ByteBuf, WorldLocation> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, WorldLocation::blockPos, WorldSerializer.STREAM_CODEC, WorldLocation::world, WorldLocation::from);

    public static Optional<WorldLocation> from(BlockEntity tile) {
        return tile != null && tile.hasLevel() ? Optional.of(WorldLocation.from(tile.getBlockPos(), tile.getLevel())) : Optional.empty();
    }

    public static WorldLocation from(BlockPos blockPos, Either<Level, ResourceLocation> world) {
        return new WorldLocation(blockPos, world.mapRight(loc -> loc.getPath().equals("") ? Level.OVERWORLD.location() : loc));
    }

    public static WorldLocation from(BlockPos blockPos, Level world) {
        return WorldLocation.from(blockPos, Either.left(world));
    }

    public static WorldLocation from(BlockPos blockPos, ResourceLocation dimensionKeyLocation) {
        return WorldLocation.from(blockPos, Either.right(dimensionKeyLocation));
    }

    public WorldLocation withoutExplicitLevel() {
        if (this.world.isLeft()) {
            return WorldLocation.from(this.blockPos, Either.right(this.world.leftOrThrow().dimension().location()));
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorldLocation that = (WorldLocation)o;
        return this.blockPos.equals((Object)that.blockPos) && this.world.rightOr(w -> w.dimension().location()).equals((Object)that.world.rightOr(w -> w.dimension().location()));
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.blockPos, this.world.rightOr(w -> w.dimension().location()));
    }

    @Override
    public String toString() {
        return String.format("(%d %d %d) in %s", this.blockPos.getX(), this.blockPos.getY(), this.blockPos.getZ(), this.world.match(Level::gatherChunkSourceStats, ResourceLocation::toString));
    }
}

