/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils.math;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public final class Angle {
    public static final float DEGREES_TO_RADIANS = (float)Math.PI / 180;
    public static final float RADIANS_TO_DEGREES = 57.29578f;
    public static final Angle ZERO = new Angle(0.0f);
    private final float radians;
    public static final MapCodec<Angle> MAP_CODEC = Codec.FLOAT.fieldOf("Radians").xmap(Angle::fromRadians, Angle::radians);
    public static final Codec<Angle> CODEC = MAP_CODEC.codec();
    public static final StreamCodec<ByteBuf, Angle> STREAM_CODEC = ByteBufCodecs.FLOAT.map(Angle::fromRadians, Angle::radians);

    public static Angle between(float x1, float z1, float x2, float z2) {
        return Angle.fromRadians((float)(Math.atan2(z2, x2) - Math.atan2(z1, x1)));
    }

    public static Angle fromRadians(float radians) {
        return new Angle(radians);
    }

    public static Angle fromDegrees(float degrees) {
        return new Angle(degrees * ((float)Math.PI / 180));
    }

    private Angle(float radians) {
        this.radians = radians;
    }

    public Angle add(Angle other) {
        return Angle.fromRadians(this.radians + other.radians);
    }

    public Angle subtract(Angle other) {
        return Angle.fromRadians(this.radians - other.radians);
    }

    public Angle mul(Float other) {
        return Angle.fromRadians(this.radians * other.floatValue());
    }

    public Angle div(Float other) {
        return Angle.fromRadians(this.radians / other.floatValue());
    }

    public Angle negated() {
        return new Angle(-this.radians);
    }

    public float radians() {
        return this.radians;
    }

    public float degrees() {
        return this.radians * 57.29578f;
    }

    public Angle normalized() {
        float pi = (float)Math.PI;
        float r = this.radians % (2.0f * pi);
        if (r < -pi) {
            r += 2.0f * pi;
        }
        if (r > pi) {
            r -= 2.0f * pi;
        }
        return Angle.fromRadians(r);
    }

    public double cos() {
        return Math.cos(this.radians());
    }

    public double sin() {
        return Math.sin(this.radians());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Angle angle = (Angle)o;
        return Float.compare(angle.radians, this.radians) == 0;
    }

    public boolean isNearly(Angle other, Angle threshold) {
        return Math.abs(this.radians - other.radians) <= threshold.radians;
    }

    public int hashCode() {
        return Float.hashCode(this.radians);
    }
}

