/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils.serialization;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.codecs.KeyDispatchCodec;
import java.util.function.Function;
import java.util.stream.Stream;

public class OptionalKeyDispatchCodec<K, V>
extends KeyDispatchCodec<K, V> {
    private final String typeKey;
    public final K defaultKey;
    private final Codec<K> keyCodec;

    public OptionalKeyDispatchCodec(String typeKey, K defaultKey, Function<? super V, ? extends K> type, Codec<K> keyCodec, Function<? super K, ? extends MapCodec<? extends V>> codec) {
        super(typeKey, keyCodec, type.andThen(DataResult::success), codec.andThen(DataResult::success));
        this.defaultKey = defaultKey;
        this.typeKey = typeKey;
        this.keyCodec = keyCodec;
    }

    public <T> DataResult<V> decode(DynamicOps<T> ops, MapLike<T> input) {
        return super.decode(ops, this.extendIfNeeded(input, ops));
    }

    private <T> MapLike<T> extendIfNeeded(MapLike<T> original, DynamicOps<T> ops) {
        return original.get(this.typeKey) == null ? new ExtendedMap<T>(original, ops) : original;
    }

    private class ExtendedMap<T>
    implements MapLike<T> {
        private final MapLike<T> original;
        private final DynamicOps<T> ops;
        private final T encodedDefaultKey;

        public ExtendedMap(MapLike<T> original, DynamicOps<T> ops) {
            this.original = original;
            this.ops = ops;
            this.encodedDefaultKey = OptionalKeyDispatchCodec.this.keyCodec.encodeStart(ops, OptionalKeyDispatchCodec.this.defaultKey).getOrThrow();
        }

        public T get(String key) {
            return (T)(key.equals(OptionalKeyDispatchCodec.this.typeKey) ? this.encodedDefaultKey : this.original.get(key));
        }

        public T get(T key) {
            DataResult k = this.ops.getStringValue(key);
            return (T)(k.isSuccess() && ((String)k.getOrThrow()).equals(OptionalKeyDispatchCodec.this.typeKey) ? this.encodedDefaultKey : this.original.get(key));
        }

        public Stream<Pair<T, T>> entries() {
            return Stream.concat(Stream.of(Pair.of((Object)this.ops.createString(OptionalKeyDispatchCodec.this.typeKey), this.encodedDefaultKey)), this.original.entries());
        }
    }
}

