/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost;

import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.compat.Compat;
import gollorum.signpost.compat.ExternalWaystoneLibrary;
import gollorum.signpost.config.Config;
import gollorum.signpost.minecraft.loot.LootEntries;
import gollorum.signpost.minecraft.worldgen.JigsawDeserializers;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.registry.ArgumentTypeInfosInjector;
import gollorum.signpost.registry.BlockRegistry;
import gollorum.signpost.registry.CommandRegistry;
import gollorum.signpost.registry.CreativeModeTabRegistry;
import gollorum.signpost.registry.DataComponentsRegistry;
import gollorum.signpost.registry.ItemRegistry;
import gollorum.signpost.registry.LootItemConditionRegistryImpl;
import gollorum.signpost.registry.RecipeRegistry;
import gollorum.signpost.registry.TileEntityRegistry;
import gollorum.signpost.registry.WaystoneDiscoveryEventListener;
import gollorum.signpost.utils.Delay;
import gollorum.signpost.utils.IDelay;
import gollorum.signpost.worldgen.Villages;
import java.util.function.Consumer;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3244;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public class SignpostFabric
implements ModInitializer {
    private final Consumer<MinecraftServer> serverSetter;

    public SignpostFabric() {
        AutoConfig.register(Config.class, GsonConfigSerializer::new);
        this.serverSetter = Signpost.init(Config::get, (IDelay)Delay.INSTANCE);
    }

    public void onInitialize() {
        BlockRegistry.register();
        ItemRegistry.register();
        DataComponentsRegistry.register();
        RecipeRegistry.register();
        TileEntityRegistry.register();
        CreativeModeTabRegistry.register();
        WaystoneDiscoveryEventListener.register();
        Delay.INSTANCE.register();
        LootItemConditionRegistryImpl.register();
        JigsawDeserializers.register((loc, elem) -> class_2378.method_10230((class_2378)class_7923.field_41162, (class_2960)loc, (Object)elem));
        LootEntries.register((loc, elem) -> class_2378.method_10230((class_2378)class_7923.field_41133, (class_2960)loc, (Object)elem));
        Compat.register();
        ExternalWaystoneLibrary.initialize();
        FabricEvents events = new FabricEvents();
        ServerLifecycleEvents.SERVER_STARTING.register(events::serverAboutToStart);
        ServerLifecycleEvents.SERVER_STOPPED.register(events::onServerStopped);
        ServerPlayConnectionEvents.JOIN.register(events::joinServer);
        ServerWorldEvents.LOAD.register(events::onWorldLoad);
        CommandRegistry.register();
        ArgumentTypeInfosInjector.register();
    }

    private class FabricEvents {
        private FabricEvents() {
        }

        public void serverAboutToStart(MinecraftServer server) {
            SignpostFabric.this.serverSetter.accept(server);
            Villages.instance.initialize((class_5455)server.method_30611());
            new WaystoneDiscoveryEventListener().initialize();
        }

        public void joinServer(class_3244 handler, PacketSender sender, MinecraftServer server) {
            if (Signpost.getServerInstance().method_3816()) {
                PacketHandler.getInstance().sendToPlayer(handler.method_32311(), JoinServerEvent.Package.INSTANCE);
            }
        }

        public void onServerStopped(MinecraftServer server) {
            SignpostFabric.this.serverSetter.accept(null);
        }

        public void onWorldLoad(MinecraftServer server, class_3218 world) {
            if (world.method_27983().equals(class_1937.field_25179)) {
                WaystoneLibrary.initializeServer(world);
            }
        }
    }

    public static final class JoinServerEvent
    implements PacketHandler.Event<Package> {
        @Override
        public class_9139<class_9129, Package> codec() {
            return Package.CODEC;
        }

        @Override
        public Class<Package> getMessageClass() {
            return Package.class;
        }

        @Override
        public void handle(Package message, PacketHandler.Context context) {
            WaystoneLibrary.initializeClient();
        }

        public static final class Package {
            public static final Package INSTANCE = new Package();
            public static final class_9139<class_9129, Package> CODEC = class_9139.method_56431((Object)INSTANCE);
        }
    }
}

