/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost;

import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneDataBase;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.blockpartdata.types.SignBlockPart;
import gollorum.signpost.compat.ExternalWaystone;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.config.IConfig;
import gollorum.signpost.minecraft.gui.ConfirmTeleportGui;
import gollorum.signpost.minecraft.gui.utils.Colors;
import gollorum.signpost.minecraft.utils.Inventory;
import gollorum.signpost.minecraft.utils.TileEntityUtils;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.utils.Either;
import gollorum.signpost.utils.IDelay;
import gollorum.signpost.utils.WaystoneHandleUtils;
import gollorum.signpost.utils.WaystoneLocationData;
import gollorum.signpost.utils.math.Angle;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9817;
import org.apache.logging.log4j.util.TriConsumer;

public class Teleport {
    public static void toWaystone(WaystoneHandle waystone, class_3222 player) {
        if (waystone instanceof WaystoneHandle.Vanilla) {
            WaystoneLocationData waystoneData = WaystoneLibrary.getInstance().getLocationData((WaystoneHandle.Vanilla)waystone);
            Teleport.toWaystone(waystoneData, player);
        } else {
            Signpost.LOGGER.error("Tried to teleport to non-vanilla waystone " + ((ExternalWaystone.Handle)waystone).modMark());
        }
    }

    public static void toWaystone(WaystoneLocationData waystoneData, class_3222 player) {
        waystoneData.block().world().mapLeft(Optional::of).leftOr(i -> TileEntityUtils.findWorld(i, false)).ifPresent(unspecificWorld -> {
            if (!(unspecificWorld instanceof class_3218)) {
                return;
            }
            class_3218 world = (class_3218)unspecificWorld;
            Vector3 location = waystoneData.spawn();
            Vector3 diff = Vector3.fromBlockPos(waystoneData.block().blockPos()).add(new Vector3(0.5f, 0.5f, 0.5f)).subtract(location.withY(y -> Float.valueOf(y.floatValue() + player.method_5751())));
            Angle yaw = Angle.between(0.0f, 1.0f, diff.x(), diff.z());
            Angle pitch = Angle.fromRadians((float)(1.5707963267948966 + Math.atan(Math.sqrt(diff.x() * diff.x() + diff.z() * diff.z()) / (double)diff.y())));
            class_3218 oldWorld = player.method_51469();
            class_2338 oldPos = player.method_24515();
            if (!player.method_51469().method_8597().equals((Object)world.method_8597()) && !IConfig.getInstance().getServer().teleport().enableAcrossDimensions()) {
                player.method_64398((class_2561)class_2561.method_43471((String)"signpost.different_dimension"));
                return;
            }
            class_3222 toTeleport = player;
            if (IConfig.getInstance().getServer().teleport().allowVehicle()) {
                while (toTeleport.method_5765()) {
                    toTeleport = toTeleport.method_5854();
                }
            } else {
                toTeleport.method_18375();
            }
            TeleportNode.create((class_1297)toTeleport).teleportWithChildren(world, location, yaw, pitch);
            int steps = 6;
            TriConsumer playStepSound = (soundWorld, pos, volume) -> {
                class_2498 soundType = class_2246.field_10340.method_9564().method_26231();
                soundWorld.method_8396(null, pos, soundType.method_10594(), player.method_5634(), soundType.method_10597() * volume.floatValue(), soundType.method_10599());
            };
            AtomicReference<Consumer<Integer>> playStepSounds = new AtomicReference<Consumer<Integer>>();
            playStepSounds.set(arg_0 -> Teleport.lambda$toWaystone$4(playStepSound, (class_1937)oldWorld, oldPos, playStepSounds, arg_0));
            ((Consumer)playStepSounds.get()).accept(6);
        });
    }

    private static List<class_1308> findLeashedMobs(class_1297 player) {
        class_238 searchBox = new class_238(player.method_24515()).method_1014(7.0);
        return player.method_73183().method_8390(class_1308.class, searchBox, mob -> player.equals((Object)mob.method_60952()));
    }

    public static void requestOnClient(Either<String, RequestGui.Package.Info> data, Optional<ConfirmTeleportGui.SignInfo> signInfo) {
        ConfirmTeleportGui.display(data, signInfo);
    }

    public static class_1799 getCost(class_3222 player, Vector3 from, Vector3 to) {
        class_1792 item = player.method_56673().method_46759(class_7924.field_41197).flatMap(registry -> registry.method_46746(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60654((String)IConfig.getInstance().getServer().teleport().costItem())))).map(class_6880.class_6883::comp_349).orElse(null);
        if (item == null || item.equals(class_1802.field_8162) || player.method_68878() || player.method_7325()) {
            return class_1799.field_8037;
        }
        int distancePerPayment = IConfig.getInstance().getServer().teleport().distancePerPayment();
        int distanceDependentCost = distancePerPayment < 0 ? 0 : (int)(from.distanceTo(to) / (float)distancePerPayment);
        return new class_1799((class_1935)item, IConfig.getInstance().getServer().teleport().constantPayment() + distanceDependentCost);
    }

    private static /* synthetic */ void lambda$toWaystone$4(TriConsumer playStepSound, class_1937 oldWorld, class_2338 oldPos, AtomicReference playStepSounds, Integer countdown) {
        float volume = (float)countdown.intValue() / 6.0f;
        playStepSound.accept((Object)oldWorld, (Object)oldPos, (Object)Float.valueOf(volume));
        if (countdown > 1) {
            IDelay.onServerForFrames(10, () -> ((Consumer)playStepSounds.get()).accept(countdown - 1));
        }
    }

    private record TeleportNode(class_1297 entity, List<TeleportNode> passengers, List<TeleportNode> leashed) {
        public static TeleportNode create(class_1297 entity) {
            List<TeleportNode> passengers = entity.method_5685().stream().map(TeleportNode::create).toList();
            List<TeleportNode> leashed = Teleport.findLeashedMobs(entity).stream().map(TeleportNode::create).toList();
            return new TeleportNode(entity, passengers, leashed);
        }

        public AtomicReference<Either<Consumer<class_1297>, class_1297>> teleportWithChildren(class_3218 level, Vector3 pos, Angle yaw, Angle pitch) {
            boolean changesDimension = !this.entity.method_73183().method_27983().equals(level.method_27983());
            AtomicReference<Either<Consumer<class_1297>, class_1297>> doAfter = new AtomicReference<Either<Consumer<class_1297>, class_1297>>();
            this.entity.method_5731(new class_5454(level, pos.asVec3(), class_243.field_1353, yaw.degrees(), pitch.degrees(), Set.of(), entity2 -> {
                Either da = (Either)doAfter.get();
                if (da != null && da.isLeft()) {
                    ((Consumer)da.leftOrThrow()).accept(entity2);
                }
                doAfter.set(Either.right(entity2));
                if (IConfig.getInstance().getServer().teleport().allowLead()) {
                    TeleportNode.teleportLeadedAnimals(entity2, this.leashed, level, pos, yaw, pitch);
                } else {
                    this.unleash();
                }
                for (TeleportNode p : this.passengers) {
                    Consumer<class_1297> next = p2 -> {
                        if (changesDimension || p.entity instanceof class_3222) {
                            IDelay.onServerForFrames(5, () -> p2.method_5873(entity2, true, true));
                        } else {
                            entity2.method_24201(p2);
                        }
                    };
                    AtomicReference<Either<Consumer<class_1297>, class_1297>> result = p.teleportWithChildren(level, pos, yaw, pitch);
                    if (result.get() != null && result.get().isRight()) {
                        next.accept(result.get().rightOrThrow());
                        continue;
                    }
                    result.set(Either.left(next));
                }
            }));
            return doAfter;
        }

        private static void teleportLeadedAnimals(class_1297 player, List<TeleportNode> leashed, class_3218 level, Vector3 pos, Angle yaw, Angle pitch) {
            for (TeleportNode mob : leashed) {
                Consumer<class_1297> releash = mob2 -> ((class_1308)mob2).method_60964(player, true);
                AtomicReference<Either<Consumer<class_1297>, class_1297>> result = mob.teleportWithChildren(level, pos, yaw, pitch);
                if (result.get() != null && result.get().isRight()) {
                    releash.accept(result.get().rightOrThrow());
                    continue;
                }
                result.set(Either.left(releash));
            }
        }

        private void unleash() {
            for (TeleportNode l : this.leashed) {
                class_1297 class_12972 = l.entity;
                if (!(class_12972 instanceof class_9817)) continue;
                class_9817 leashable = (class_9817)class_12972;
                leashable.method_5932();
            }
        }
    }

    public static final class RequestGui
    implements PacketHandler.Event<Package> {
        @Override
        public class_9139<class_9129, Package> codec() {
            return Package.STREAM_CODEC;
        }

        @Override
        public Class<Package> getMessageClass() {
            return Package.class;
        }

        @Override
        public void handle(Package message, PacketHandler.Context context) {
            if (IConfig.getInstance().getClient().enableConfirmationScreen()) {
                Teleport.requestOnClient(message.data, message.tilePartInfo.flatMap(info -> TileEntityUtils.findTileEntity(info.dimensionKey, true, info.pos, PostTile.getBlockEntityType()).flatMap(tile -> tile.getPart(info.identifier).flatMap(part -> part.blockPart() instanceof SignBlockPart ? Optional.of(new ConfirmTeleportGui.SignInfo((PostTile)tile, (SignBlockPart)part.blockPart(), (PostTile.TilePartInfo)info, part.offset())) : Optional.empty()))));
            } else {
                message.data.consume(l -> class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43471((String)l), true), r -> PacketHandler.getInstance().sendToServer(new Request.Package(r.waystoneName, r.handle)));
            }
        }

        public record Package(Either<String, Info> data, Optional<PostTile.TilePartInfo> tilePartInfo) {
            public static final class_9139<class_9129, Package> STREAM_CODEC = class_9139.method_56435(Either.streamCodec(class_9135.field_48554, Info.STREAM_CODEC), Package::data, (class_9139)class_9135.method_56382(PostTile.TilePartInfo.STREAM_CODEC), Package::tilePartInfo, Package::new);

            public record Info(int maxDistance, int distance, Optional<class_2561> cannotTeleportBecause, String waystoneName, class_1799 cost, Optional<WaystoneHandle> handle) {
                public static final class_9139<class_9129, Info> STREAM_CODEC = class_9139.method_58025((class_9139)class_9135.field_49675, Info::maxDistance, (class_9139)class_9135.field_49675, Info::distance, (class_9139)class_8824.field_48985, Info::cannotTeleportBecause, (class_9139)class_9135.field_48554, Info::waystoneName, (class_9139)class_1799.field_49268, Info::cost, (class_9139)class_9135.method_56382(WaystoneHandle.STREAM_CODEC), Info::handle, Info::new);
            }
        }
    }

    public static final class Request
    implements PacketHandler.Event.ForServer<Package> {
        @Override
        public class_9139<class_9129, Package> codec() {
            return Package.STREAM_CODEC;
        }

        @Override
        public Class<Package> getMessageClass() {
            return Package.class;
        }

        @Override
        public void handle(Package message, PacketHandler.Context.Server context) {
            class_3222 player = context.sender();
            Optional<WaystoneHandle> waystone = message.handle.or(() -> WaystoneLibrary.getInstance().getHandleByName(message.waystoneName));
            Optional data = waystone.flatMap(WaystoneLibrary.getInstance()::getData);
            if (data.isPresent()) {
                WaystoneHandle handle = waystone.get();
                WaystoneLocationData waystoneData = ((WaystoneDataBase)data.get()).loc();
                Optional<class_2561> cannotTeleportBecause = WaystoneHandleUtils.cannotTeleportToBecause((class_1657)player, handle, message.waystoneName);
                int distance = (int)waystoneData.spawn().distanceTo(Vector3.fromVec3d(player.method_73189()));
                int maxDistance = IConfig.getInstance().getServer().teleport().maximumDistance();
                boolean isTooFarAway = maxDistance > 0 && distance > maxDistance;
                cannotTeleportBecause.ifPresent(arg_0 -> ((class_3222)player).method_64398(arg_0));
                if (isTooFarAway) {
                    player.method_64398((class_2561)class_2561.method_43469((String)"signpost.too_far_away", (Object[])new Object[]{Integer.toString(distance), Integer.toString(maxDistance)}));
                }
                if (cannotTeleportBecause.isPresent() || isTooFarAway) {
                    return;
                }
                Inventory.tryPay(player, Teleport.getCost(player, Vector3.fromVec3d(player.method_73189()), waystoneData.spawn()), p -> Teleport.toWaystone(waystoneData, p));
            } else {
                player.method_64398((class_2561)class_2561.method_43469((String)"signpost.waystone_not_found", (Object[])new Object[]{Colors.wrap(message.waystoneName, Colors.highlight)}));
            }
        }

        public record Package(String waystoneName, Optional<WaystoneHandle> handle) {
            public static final class_9139<class_9129, Package> STREAM_CODEC = class_9139.method_56435((class_9139)class_9135.field_48554, Package::waystoneName, (class_9139)class_9135.method_56382(WaystoneHandle.STREAM_CODEC), Package::handle, Package::new);
        }
    }
}

