/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gollorum.signpost.PlayerHandle;
import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneDataBase;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.blockpartdata.types.renderers.BlockPartWaystoneUpdateListener;
import gollorum.signpost.compat.ExternalWaystoneLibrary;
import gollorum.signpost.events.WaystoneAddedOrRenamedEvent;
import gollorum.signpost.events.WaystoneMovedEvent;
import gollorum.signpost.events.WaystoneRemovedEvent;
import gollorum.signpost.events.WaystoneRenamedEvent;
import gollorum.signpost.events.WaystoneUpdatedEvent;
import gollorum.signpost.minecraft.block.WaystoneBlock;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.block.tiles.WaystoneTile;
import gollorum.signpost.minecraft.config.IConfig;
import gollorum.signpost.minecraft.storage.WaystoneLibraryStorage;
import gollorum.signpost.minecraft.utils.TileEntityUtils;
import gollorum.signpost.minecraft.worldgen.VillageWaystone;
import gollorum.signpost.mixin.LevelAccessor;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.utils.EventDispatcher;
import gollorum.signpost.utils.IDelay;
import gollorum.signpost.utils.Tuple;
import gollorum.signpost.utils.WaystoneContainer;
import gollorum.signpost.utils.WaystoneData;
import gollorum.signpost.utils.WaystoneLocationData;
import gollorum.signpost.utils.WorldLocation;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class WaystoneLibrary {
    private static WaystoneLibrary instance;
    public final WaystoneLibraryStorage data;
    private final EventDispatcher.Impl.WithPublicDispatch<WaystoneUpdatedEvent> _updateEventDispatcher = new EventDispatcher.Impl.WithPublicDispatch();
    public final EventDispatcher<WaystoneUpdatedEvent> updateEventDispatcher = this._updateEventDispatcher;
    private final Set<String> cachedWaystoneNames = new HashSet<String>();
    private boolean isWaystoneNameCacheDirty = true;
    private final EventDispatcher.Impl.WithPublicDispatch<Map<WaystoneHandle.Vanilla, String>> requestedAllNamesEventDispatcher = new EventDispatcher.Impl.WithPublicDispatch();
    private final EventDispatcher.Impl.WithPublicDispatch<Map<WaystoneHandle.Vanilla, Tuple<String, WaystoneLocationData>>> requestedAllWaystonesEventDispatcher = new EventDispatcher.Impl.WithPublicDispatch();
    private final EventDispatcher.Impl.WithPublicDispatch<Optional<WaystoneHandle.Vanilla>> requestedIdEventDispatcher = new EventDispatcher.Impl.WithPublicDispatch();
    private final EventDispatcher.Impl.WithPublicDispatch<DeliverWaystoneAtLocationEvent.Packet> requestedWaystoneAtLocationEventDispatcher = new EventDispatcher.Impl.WithPublicDispatch();
    private final EventDispatcher.Impl.WithPublicDispatch<DeliverWaystoneLocationEvent.Packet> requestedWaystoneLocationEventDispatcher = new EventDispatcher.Impl.WithPublicDispatch();
    private final long tileEntityExistenceCheckCooldownMillis = 600000L;
    private final Map<class_2960, Map<class_2338, Long>> checkedTileEntities = new HashMap<class_2960, Map<class_2338, Long>>();

    public static WaystoneLibrary getInstance() {
        if (instance == null) {
            if (Signpost.getServerType().isServer) {
                WaystoneLibrary.initializeServer(Signpost.getServerInstance().method_30002());
            } else {
                WaystoneLibrary.initializeClient();
            }
            Signpost.LOGGER.warn("Force-initialized waystone library. This should not happen.");
        }
        return instance;
    }

    public static boolean hasInstance() {
        return instance != null;
    }

    public static void initializeServer(class_3218 overworld) {
        WaystoneLibraryStorage data = (WaystoneLibraryStorage)overworld.method_17983().method_17924(WaystoneLibraryStorage.TYPE);
        instance = new WaystoneLibrary(data);
        BlockPartWaystoneUpdateListener.getInstance().initialize();
    }

    public static void initializeClient() {
        WaystoneLibraryStorage data = new WaystoneLibraryStorage(new HashMap<WaystoneHandle.Vanilla, WaystoneEntry>(), new HashMap<PlayerHandle, HashSet<WaystoneHandle.Vanilla>>(), new VillageWaystone());
        instance = new WaystoneLibrary(data);
        BlockPartWaystoneUpdateListener.getInstance().initialize();
    }

    public VillageWaystone getVillageWaystones() {
        return this.data.villageWaystones;
    }

    private WaystoneLibrary(WaystoneLibraryStorage data) {
        this.data = data;
        this.updateEventDispatcher.addListener(event -> {
            if (this.isWaystoneNameCacheDirty) {
                return;
            }
            switch (event.getType()) {
                case Added: {
                    this.cachedWaystoneNames.add(event.name);
                    break;
                }
                case Removed: {
                    this.cachedWaystoneNames.remove(event.name);
                    break;
                }
                case Renamed: {
                    this.cachedWaystoneNames.remove(((WaystoneRenamedEvent)event).oldName);
                    this.cachedWaystoneNames.add(event.name);
                }
            }
            data.method_80();
        });
    }

    public WaystoneLocationData getLocationData(WaystoneHandle.Vanilla waystoneId) {
        assert (Signpost.getServerType().isServer);
        return this.data.allWaystones.get((Object)waystoneId).locationData;
    }

    public Optional<WaystoneDataBase> getData(WaystoneHandle handle) {
        return handle instanceof WaystoneHandle.Vanilla ? this.getData((WaystoneHandle.Vanilla)handle).map(d -> d) : ExternalWaystoneLibrary.getInstance().getData(handle).map(d -> d);
    }

    public Optional<WaystoneData> getData(WaystoneHandle.Vanilla waystoneId) {
        assert (Signpost.getServerType().isServer);
        WaystoneEntry entry = this.data.allWaystones.get(waystoneId);
        return entry == null ? Optional.empty() : Optional.of(new WaystoneData(waystoneId, entry.name, entry.locationData, entry.isLocked));
    }

    public void requestUpdate(String newName, WaystoneLocationData location, boolean isLocked) {
        PacketHandler.getInstance().sendToServer(new WaystoneUpdatedEventEvent.Packet(WaystoneUpdatedEvent.fromUpdated(location, newName, isLocked, WaystoneHandle.Vanilla.NIL)));
    }

    public Optional<String> update(String newName, WaystoneLocationData location, class_1657 editingPlayer, boolean isLocked) {
        assert (Signpost.getServerType().isServer && location.block().world().match(w -> w instanceof class_3218, i -> true).booleanValue());
        WaystoneHandle.Vanilla[] oldWaystones = (WaystoneHandle.Vanilla[])this.data.allWaystones.entrySet().stream().filter(e -> ((WaystoneEntry)e.getValue()).locationData.block().equals(location.block())).map(Map.Entry::getKey).distinct().toArray(WaystoneHandle.Vanilla[]::new);
        CharSequence[] oldNames = (String[])Arrays.stream(oldWaystones).map(id -> this.data.allWaystones.get((Object)id).name).toArray(String[]::new);
        if (oldWaystones.length > 1) {
            Signpost.LOGGER.error("Waystone at " + String.valueOf(location) + " (new name: " + newName + ") was already present " + oldWaystones.length + " times. This indicates invalid state. Names found: " + String.join((CharSequence)", ", oldNames));
        }
        if (oldWaystones.length > 0) {
            WaystoneEntry oldEntry = this.data.allWaystones.get(oldWaystones[0]);
            if (editingPlayer != null && !oldEntry.hasThePermissionToEdit(editingPlayer)) {
                editingPlayer.method_7353((class_2561)class_2561.method_43471((String)"signpost.no_permission_to_edit_waystone"), false);
                return Optional.empty();
            }
            if (editingPlayer != null && !WaystoneData.hasSecurityPermissions(editingPlayer, location)) {
                isLocked = oldEntry.isLocked;
            }
            for (WaystoneHandle.Vanilla oldId : oldWaystones) {
                this.data.allWaystones.remove(oldId);
            }
        }
        if (!this.validateNameDoesNotExist(newName, editingPlayer)) {
            return Optional.empty();
        }
        WaystoneHandle.Vanilla id2 = oldWaystones.length > 0 ? oldWaystones[0] : new WaystoneHandle.Vanilla(UUID.randomUUID());
        this.data.allWaystones.put(id2, new WaystoneEntry(newName, location, isLocked));
        Optional<String> oldName = oldNames.length > 0 ? Optional.of(oldNames[0]) : Optional.empty();
        WaystoneUpdatedEvent updatedEvent = WaystoneUpdatedEvent.fromUpdated(location, newName, oldName, isLocked, id2);
        this._updateEventDispatcher.dispatch(updatedEvent, false);
        PacketHandler.getInstance().sendToAll(new WaystoneUpdatedEventEvent.Packet(updatedEvent));
        this.markDirty();
        WaystoneBlock.discover(PlayerHandle.from((class_1297)editingPlayer), new WaystoneData(id2, newName, location, isLocked));
        return oldName;
    }

    public boolean tryAddNew(String newName, WaystoneLocationData location, class_3222 editingPlayer, Optional<WaystoneHandle.Vanilla> handle) {
        if (handle.map(h -> !this.validateHandleDoesNotExist((WaystoneHandle.Vanilla)h, (class_1657)editingPlayer)).orElse(false).booleanValue()) {
            return false;
        }
        if (!this.validateNameDoesNotExist(newName, (class_1657)editingPlayer)) {
            return false;
        }
        if (this.data.allWaystones.values().stream().anyMatch(entry -> entry.locationData.block().equals(location.block()))) {
            Signpost.LOGGER.error("Waystone at " + String.valueOf(location) + " (new name: " + newName + ") was already present. This indicates invalid state.");
            return false;
        }
        WaystoneHandle.Vanilla id = handle.orElseGet(() -> new WaystoneHandle.Vanilla(UUID.randomUUID()));
        boolean isLocked = false;
        this.data.allWaystones.put(id, new WaystoneEntry(newName, location, isLocked));
        WaystoneUpdatedEvent updatedEvent = WaystoneUpdatedEvent.fromUpdated(location, newName, Optional.empty(), isLocked, id);
        this._updateEventDispatcher.dispatch(updatedEvent, false);
        PacketHandler.getInstance().sendToAll(new WaystoneUpdatedEventEvent.Packet(updatedEvent));
        this.markDirty();
        WaystoneBlock.discover(PlayerHandle.from((class_1297)editingPlayer), new WaystoneData(id, newName, location, isLocked));
        return true;
    }

    private boolean validateHandleDoesNotExist(WaystoneHandle.Vanilla handle, class_1657 editingPlayer) {
        if (this.data.allWaystones.containsKey(handle)) {
            editingPlayer.method_7353((class_2561)class_2561.method_43471((String)"signpost.duplicate_waystone_id"), false);
            return false;
        }
        return true;
    }

    private boolean validateNameDoesNotExist(String newName, class_1657 editingPlayer) {
        if (this.data.allWaystones.values().stream().anyMatch(entry -> entry.name.equals(newName))) {
            if (editingPlayer != null) {
                editingPlayer.method_7353((class_2561)class_2561.method_43469((String)"signpost.duplicate_waystone_name", (Object[])new Object[]{newName}), true);
            } else {
                Signpost.LOGGER.error("Tried to automatically name a waystone \"" + newName + "\", which already existed.");
            }
            return false;
        }
        return true;
    }

    public boolean remove(String name, PlayerHandle playerHandle) {
        assert (Signpost.getServerType().isServer);
        Optional<Map.Entry<WaystoneHandle.Vanilla, WaystoneEntry>> oldEntry = this.getByName(name);
        return oldEntry.isPresent() && this.remove(oldEntry.get().getKey(), playerHandle);
    }

    public boolean removeAt(WorldLocation location, PlayerHandle playerHandle) {
        assert (Signpost.getServerType().isServer);
        Optional<Map.Entry<WaystoneHandle.Vanilla, WaystoneEntry>> oldEntry = this.getByLocation(location);
        return oldEntry.isPresent() && this.remove(oldEntry.get().getKey(), playerHandle);
    }

    public boolean remove(WaystoneHandle.Vanilla handle, PlayerHandle playerHandle) {
        assert (Signpost.getServerType().isServer);
        WaystoneEntry oldEntry = this.data.allWaystones.remove(handle);
        if (oldEntry == null) {
            return false;
        }
        this._updateEventDispatcher.dispatch(new WaystoneRemovedEvent(oldEntry.locationData, oldEntry.name, handle), false);
        PacketHandler.getInstance().sendToAll(new WaystoneUpdatedEventEvent.Packet(new WaystoneRemovedEvent(oldEntry.locationData, oldEntry.name, handle)));
        this.markDirty();
        return true;
    }

    public boolean updateLocation(WorldLocation oldLocation, WorldLocation newLocation) {
        assert (Signpost.getServerType().isServer);
        Optional<Map.Entry<WaystoneHandle.Vanilla, WaystoneEntry>> oldEntry = this.getByLocation(oldLocation);
        if (!oldEntry.isPresent()) {
            return false;
        }
        this.data.allWaystones.remove(oldEntry.get().getKey());
        Vector3 newSpawnLocation = oldEntry.get().getValue().locationData.spawn().add(Vector3.fromBlockPos(newLocation.blockPos().method_10059((class_2382)oldLocation.blockPos())));
        this.data.allWaystones.put(oldEntry.get().getKey(), new WaystoneEntry(oldEntry.get().getValue().name, new WaystoneLocationData(newLocation, newSpawnLocation), oldEntry.get().getValue().isLocked));
        this._updateEventDispatcher.dispatch(new WaystoneMovedEvent(oldEntry.get().getValue().locationData, newLocation, oldEntry.get().getValue().name, oldEntry.get().getKey()), false);
        this.markDirty();
        return true;
    }

    public Optional<WaystoneHandle.Vanilla> getHandleByName(String name) {
        assert (Signpost.getServerType().isServer);
        return this.getByName(name).map(e -> (WaystoneHandle.Vanilla)e.getKey());
    }

    public Optional<WaystoneHandle.Vanilla> getHandleByLocation(WorldLocation location) {
        assert (Signpost.getServerType().isServer);
        return this.getByLocation(location).map(e -> (WaystoneHandle.Vanilla)e.getKey());
    }

    private Optional<Map.Entry<WaystoneHandle.Vanilla, WaystoneEntry>> getByName(String name) {
        assert (Signpost.getServerType().isServer);
        return this.data.allWaystones.entrySet().stream().filter(e -> ((WaystoneEntry)e.getValue()).name.equals(name)).findFirst();
    }

    private Optional<Map.Entry<WaystoneHandle.Vanilla, WaystoneEntry>> getByLocation(WorldLocation location) {
        assert (Signpost.getServerType().isServer);
        return this.data.allWaystones.entrySet().stream().filter(e -> ((WaystoneEntry)e.getValue()).locationData.block().equals(location)).findFirst();
    }

    public void requestAllWaystoneNames(Consumer<Map<WaystoneHandle.Vanilla, String>> onReply, Optional<PlayerHandle> onlyKnownBy, boolean isClient) {
        if (isClient) {
            this.requestedAllNamesEventDispatcher.addListener(onReply);
            PacketHandler.getInstance().sendToServer(new RequestAllWaystoneNamesEvent.Packet(onlyKnownBy));
        } else {
            onReply.accept(this.getAllWaystoneNamesAndHandles(onlyKnownBy));
        }
    }

    public void requestAllWaystones(Consumer<Map<WaystoneHandle.Vanilla, Tuple<String, WaystoneLocationData>>> onReply, Optional<PlayerHandle> onlyKnownBy, boolean isClient) {
        if (isClient) {
            this.requestedAllWaystonesEventDispatcher.addListener(onReply);
            PacketHandler.getInstance().sendToServer(new RequestAllWaystonesEvent.Packet(onlyKnownBy));
        } else {
            onReply.accept(this.getAllWaystones(onlyKnownBy));
        }
    }

    public void requestWaystoneAt(WorldLocation location, Consumer<Optional<WaystoneData>> onReply, boolean isClient) {
        if (isClient) {
            this.requestedWaystoneAtLocationEventDispatcher.addListener(packet -> {
                if (packet.waystoneLocation.equals(location)) {
                    onReply.accept(packet.data);
                    return true;
                }
                return false;
            });
            PacketHandler.getInstance().sendToServer(RequestWaystoneAtLocationEvent.Packet.from(location));
        } else {
            onReply.accept(this.tryGetWaystoneDataAt(location));
        }
    }

    private Optional<WaystoneHandle.Vanilla> getHandleFor(String name) {
        return this.data.allWaystones.entrySet().stream().filter(e -> ((WaystoneEntry)e.getValue()).name.equals(name)).map(Map.Entry::getKey).findFirst();
    }

    private Map<WaystoneHandle.Vanilla, String> getAllWaystoneNamesAndHandles(Optional<PlayerHandle> onlyKnownBy) {
        assert (Signpost.getServerType().isServer);
        Map<WaystoneHandle.Vanilla, String> ret = WaystoneLibrary.getInstance().data.allWaystones.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((WaystoneEntry)e.getValue()).name));
        if (this.isWaystoneNameCacheDirty) {
            this.cachedWaystoneNames.clear();
            this.cachedWaystoneNames.addAll(ret.values());
            this.isWaystoneNameCacheDirty = false;
        }
        if (onlyKnownBy.isPresent() && IConfig.IServer.getInstance().teleport().enforceDiscovery()) {
            Set known = this.data.playerMemory.computeIfAbsent(onlyKnownBy.get(), h -> new HashSet());
            return ret.entrySet().stream().filter(e -> known.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        return ret;
    }

    private Map<WaystoneHandle.Vanilla, Tuple<String, WaystoneLocationData>> getAllWaystones(Optional<PlayerHandle> onlyKnownBy) {
        assert (Signpost.getServerType().isServer);
        Map<WaystoneHandle.Vanilla, Tuple<String, WaystoneLocationData>> ret = WaystoneLibrary.getInstance().data.allWaystones.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Tuple.of(((WaystoneEntry)e.getValue()).name, ((WaystoneEntry)e.getValue()).locationData.withoutExplicitLevel())));
        if (onlyKnownBy.isPresent() && IConfig.IServer.getInstance().teleport().enforceDiscovery()) {
            PlayerHandle player = onlyKnownBy.get();
            Set known = this.data.playerMemory.computeIfAbsent(player, h -> new HashSet());
            return ret.entrySet().stream().filter(e -> known.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        return ret;
    }

    public Optional<Set<String>> getAllWaystoneNames(boolean isClient) {
        if (this.isWaystoneNameCacheDirty) {
            this.requestAllWaystoneNames(c -> {}, Optional.empty(), isClient);
        }
        return this.isWaystoneNameCacheDirty ? Optional.empty() : Optional.of(new HashSet<String>(this.cachedWaystoneNames));
    }

    public Set<WaystoneInfo> getAllWaystoneInfo() {
        assert (Signpost.getServerType().isServer);
        return this.data.allWaystones.entrySet().stream().map(entry -> new WaystoneInfo(((WaystoneEntry)entry.getValue()).name, ((WaystoneEntry)entry.getValue()).locationData, (WaystoneHandle.Vanilla)entry.getKey())).collect(Collectors.toSet());
    }

    private Optional<WaystoneData> tryGetWaystoneDataAt(WorldLocation location) {
        assert (Signpost.getServerType().isServer);
        return WaystoneLibrary.getInstance().data.allWaystones.entrySet().stream().filter(e -> ((WaystoneEntry)e.getValue()).locationData.block().equals(location)).findFirst().map(entry -> new WaystoneData((WaystoneHandle.Vanilla)entry.getKey(), ((WaystoneEntry)entry.getValue()).name, ((WaystoneEntry)entry.getValue()).locationData, ((WaystoneEntry)entry.getValue()).isLocked));
    }

    public boolean addDiscovered(PlayerHandle player, WaystoneHandle.Vanilla waystone) {
        assert (Signpost.getServerType().isServer);
        if (this.data.playerMemory.computeIfAbsent(player, p -> new HashSet()).add(waystone)) {
            this.markDirty();
            return true;
        }
        return false;
    }

    public boolean isDiscovered(PlayerHandle player, WaystoneHandle.Vanilla waystone) {
        if (!this.data.playerMemory.containsKey(player)) {
            this.data.playerMemory.put(player, new HashSet());
        }
        return this.data.playerMemory.get(player).contains(waystone);
    }

    public boolean contains(WaystoneHandle.Vanilla waystone) {
        assert (Signpost.getServerType().isServer);
        if (!this.data.allWaystones.containsKey(waystone)) {
            return false;
        }
        WaystoneEntry entry = this.data.allWaystones.get(waystone);
        return this.assertTileEntityExists(entry);
    }

    private boolean assertTileEntityExists(WaystoneEntry entry) {
        Map cache = this.checkedTileEntities.computeIfAbsent(entry.locationData.block().world().rightOr(l -> l.method_27983().method_29177()), key -> new HashMap());
        long time = System.currentTimeMillis();
        class_2338 blockPos = entry.locationData.block().blockPos();
        Long lastChecked = (Long)cache.get(blockPos);
        if (lastChecked != null && lastChecked + 600000L >= time) {
            return true;
        }
        Optional level = TileEntityUtils.toWorld(entry.locationData.block().world(), false).flatMap(lv -> lv instanceof class_3218 ? Optional.of((class_3218)lv) : Optional.empty());
        if (level.isEmpty()) {
            return true;
        }
        if (((LevelAccessor)level.get()).getThread() != Thread.currentThread()) {
            IDelay.onServerForFrames(1, () -> WaystoneLibrary.checkEntity((class_3218)level.get(), blockPos, cache));
            return true;
        }
        return WaystoneLibrary.checkEntity((class_3218)level.get(), blockPos, cache);
    }

    private static boolean checkEntity(class_3218 level, class_2338 blockPos, Map<class_2338, Long> cache) {
        Optional entity = level.method_35230(blockPos, WaystoneTile.getBlockEntityType());
        if (entity.isEmpty()) {
            entity = level.method_35230(blockPos, PostTile.getBlockEntityType());
        }
        if (entity.isPresent()) {
            cache.put(blockPos, System.currentTimeMillis());
            return true;
        }
        WaystoneTile.onRemoved(level, blockPos);
        return false;
    }

    public void markDirty() {
        this.data.method_80();
    }

    public record WaystoneEntry(String name, WaystoneLocationData locationData, boolean isLocked) {
        public static final MapCodec<WaystoneEntry> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("Name").forGetter(WaystoneEntry::name), (App)WaystoneLocationData.CODEC.fieldOf("Location").forGetter(WaystoneEntry::locationData), (App)Codec.BOOL.fieldOf("IsLocked").forGetter(WaystoneEntry::isLocked)).apply((Applicative)instance, WaystoneEntry::new));

        public boolean hasThePermissionToEdit(class_1657 player) {
            return WaystoneData.hasThePermissionToEdit(player, this.locationData, this.isLocked);
        }
    }

    public static final class WaystoneUpdatedEventEvent
    implements PacketHandler.Event<Packet> {
        @Override
        public class_9139<class_9129, Packet> codec() {
            return Packet.STREAM_CODEC;
        }

        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void handle(Packet message, PacketHandler.Context context) {
            if (context instanceof PacketHandler.Context.Server) {
                PacketHandler.Context.Server serverContext = (PacketHandler.Context.Server)context;
                class_3222 player = serverContext.sender();
                switch (message.event.getType()) {
                    case Added: {
                        if (!TileEntityUtils.findTileEntityAt(message.event.location.block(), WaystoneContainer.class, false).isPresent()) {
                            Signpost.LOGGER.error("Tried to add a waystone where no compatible TileEntity was present: " + String.valueOf(message.event.location.block()));
                            return;
                        }
                    }
                    case Renamed: {
                        WaystoneLibrary.getInstance().update(message.event.name, message.event.location, (class_1657)player, ((WaystoneAddedOrRenamedEvent)message.event).isLocked);
                        break;
                    }
                    case Removed: {
                        WaystoneLibrary.getInstance().remove(message.event.name, PlayerHandle.from((class_1297)player));
                        break;
                    }
                    case Moved: {
                        WaystoneLibrary.getInstance().updateLocation(message.event.location.block(), ((WaystoneMovedEvent)message.event).newLocation);
                    }
                    default: {
                        throw new RuntimeException("Type " + String.valueOf((Object)message.event.getType()) + " is not supported");
                    }
                }
            } else {
                WaystoneLibrary.getInstance()._updateEventDispatcher.dispatch(message.event, false);
            }
        }

        public record Packet(WaystoneUpdatedEvent event) {
            public static final class_9139<class_9129, Packet> STREAM_CODEC = WaystoneUpdatedEvent.Serializer.INSTANCE.method_56432(Packet::new, Packet::event).method_56439(b -> b);
        }
    }

    public static final class RequestAllWaystoneNamesEvent
    implements PacketHandler.Event.ForServer<Packet> {
        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public class_9139<class_9129, Packet> codec() {
            return Packet.STREAM_CODEC;
        }

        @Override
        public void handle(Packet message, PacketHandler.Context.Server context) {
            PacketHandler.getInstance().sendToPlayer(context.sender(), new DeliverAllWaystoneNamesEvent.Packet(WaystoneLibrary.getInstance().getAllWaystoneNamesAndHandles(message.onlyKnownBy)));
        }

        public record Packet(Optional<PlayerHandle> onlyKnownBy) {
            public static final class_9139<class_9129, Packet> STREAM_CODEC = class_9139.method_56434((class_9139)class_9135.method_56382(PlayerHandle.STREAM_CODEC), Packet::onlyKnownBy, Packet::new);
        }
    }

    public static final class RequestAllWaystonesEvent
    implements PacketHandler.Event.ForServer<Packet> {
        @Override
        public class_9139<class_9129, Packet> codec() {
            return Packet.STREAM_CODEC;
        }

        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void handle(Packet message, PacketHandler.Context.Server context) {
            PacketHandler.getInstance().sendToPlayer(context.sender(), new DeliverAllWaystonesEvent.Packet(WaystoneLibrary.getInstance().getAllWaystones(message.onlyKnownBy)));
        }

        public record Packet(Optional<PlayerHandle> onlyKnownBy) {
            public static final class_9139<class_9129, Packet> STREAM_CODEC = class_9139.method_56434((class_9139)class_9135.method_56382(PlayerHandle.STREAM_CODEC), Packet::onlyKnownBy, Packet::new);
        }
    }

    public static final class RequestWaystoneAtLocationEvent
    implements PacketHandler.Event.ForServer<Packet> {
        @Override
        public class_9139<class_9129, Packet> codec() {
            return Packet.STREAM_CODEC;
        }

        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void handle(Packet message, PacketHandler.Context.Server context) {
            Optional<WaystoneData> dataAt = WaystoneLibrary.getInstance().tryGetWaystoneDataAt(message.waystoneLocation);
            PacketHandler.getInstance().sendToPlayer(context.sender(), DeliverWaystoneAtLocationEvent.Packet.from(message.waystoneLocation, dataAt));
        }

        public record Packet(WorldLocation waystoneLocation) {
            public static final class_9139<class_9129, Packet> STREAM_CODEC = WorldLocation.STREAM_CODEC.method_56432(Packet::new, Packet::waystoneLocation).method_56439(b -> b);

            public static Packet from(WorldLocation waystoneLocation) {
                return new Packet(waystoneLocation.withoutExplicitLevel());
            }
        }
    }

    public record WaystoneInfo(String name, WaystoneLocationData locationData, WaystoneHandle.Vanilla handle) {
    }

    public static final class DeliverWaystoneAtLocationEvent
    implements PacketHandler.Event<Packet> {
        @Override
        public class_9139<class_9129, Packet> codec() {
            return Packet.STREAM_CODEC;
        }

        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void handle(Packet message, PacketHandler.Context context) {
            WaystoneLibrary.getInstance().requestedWaystoneAtLocationEventDispatcher.dispatch(message, false);
        }

        private record Packet(WorldLocation waystoneLocation, Optional<WaystoneData> data) {
            public static final class_9139<class_9129, Packet> STREAM_CODEC = class_9139.method_56435(WorldLocation.STREAM_CODEC, Packet::waystoneLocation, (class_9139)class_9135.method_56382(WaystoneData.STREAM_CODEC), Packet::data, Packet::new);

            private static Packet from(WorldLocation waystoneLocation, Optional<WaystoneData> data) {
                return new Packet(waystoneLocation.withoutExplicitLevel(), data.map(WaystoneData::withoutExplicitLevel));
            }
        }
    }

    public static final class DeliverIdEvent
    implements PacketHandler.Event<Packet> {
        @Override
        public class_9139<class_9129, Packet> codec() {
            return Packet.STREAM_CODEC;
        }

        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void handle(Packet message, PacketHandler.Context context) {
            WaystoneLibrary.getInstance().requestedIdEventDispatcher.dispatch(message.waystone, true);
        }

        private record Packet(Optional<WaystoneHandle.Vanilla> waystone) {
            public static final class_9139<class_9129, Packet> STREAM_CODEC = class_9135.method_56382(WaystoneHandle.Vanilla.STREAM_CODEC).method_56432(Packet::new, Packet::waystone).method_56439(b -> b);
        }
    }

    public static final class RequestIdEvent
    implements PacketHandler.Event.ForServer<Packet> {
        @Override
        public class_9139<class_9129, Packet> codec() {
            return Packet.STREAM_CODEC;
        }

        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void handle(Packet message, PacketHandler.Context.Server context) {
            PacketHandler.getInstance().sendToPlayer(context.sender(), new DeliverIdEvent.Packet(WaystoneLibrary.getInstance().getHandleFor(message.name)));
        }

        public record Packet(String name) {
            public static final class_9139<class_9129, Packet> STREAM_CODEC = class_9135.field_48554.method_56432(Packet::new, Packet::name).method_56439(b -> b);
        }
    }

    public static final class DeliverWaystoneLocationEvent
    implements PacketHandler.Event<Packet> {
        @Override
        public class_9139<class_9129, Packet> codec() {
            return Packet.STREAM_CODEC;
        }

        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void handle(Packet message, PacketHandler.Context context) {
            WaystoneLibrary.getInstance().requestedWaystoneLocationEventDispatcher.dispatch(message, false);
        }

        private record Packet(String name, Optional<WaystoneLocationData> data) {
            public static final class_9139<class_9129, Packet> STREAM_CODEC = class_9139.method_56435((class_9139)class_9135.field_48554, Packet::name, (class_9139)class_9135.method_56382(WaystoneLocationData.STREAM_CODEC), Packet::data, Packet::new);

            private static Packet from(String name, Optional<WaystoneLocationData> data) {
                return new Packet(name, data.map(WaystoneLocationData::withoutExplicitLevel));
            }
        }
    }

    public static final class RequestWaystoneLocationEvent
    implements PacketHandler.Event.ForServer<Packet> {
        @Override
        public class_9139<class_9129, Packet> codec() {
            return Packet.STREAM_CODEC;
        }

        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void handle(Packet message, PacketHandler.Context.Server context) {
            Optional<WaystoneLocationData> dataAt = WaystoneLibrary.getInstance().getByName(message.name).map(e -> ((WaystoneEntry)e.getValue()).locationData);
            PacketHandler.getInstance().sendToPlayer(context.sender(), DeliverWaystoneLocationEvent.Packet.from(message.name, dataAt));
        }

        public record Packet(String name) {
            public static final class_9139<class_9129, Packet> STREAM_CODEC = class_9135.field_48554.method_56432(Packet::new, Packet::name).method_56439(b -> b);
        }
    }

    public static final class DeliverAllWaystonesEvent
    implements PacketHandler.Event<Packet> {
        @Override
        public class_9139<class_9129, Packet> codec() {
            return Packet.STREAM_CODEC;
        }

        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void handle(Packet message, PacketHandler.Context context) {
            WaystoneLibrary.getInstance().requestedAllWaystonesEventDispatcher.dispatch(message.data, true);
        }

        public record Packet(Map<WaystoneHandle.Vanilla, Tuple<String, WaystoneLocationData>> data) {
            public static final class_9139<class_9129, Packet> STREAM_CODEC = class_9135.method_56377(HashMap::new, WaystoneHandle.Vanilla.STREAM_CODEC, Tuple.streamCodec(class_9135.field_48554, WaystoneLocationData.STREAM_CODEC)).method_56432(Packet::new, Packet::data);
        }
    }

    public static final class DeliverAllWaystoneNamesEvent
    implements PacketHandler.Event<Packet> {
        @Override
        public class_9139<class_9129, Packet> codec() {
            return Packet.STREAM_CODEC;
        }

        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void handle(Packet message, PacketHandler.Context context) {
            WaystoneLibrary.getInstance().cachedWaystoneNames.clear();
            WaystoneLibrary.getInstance().cachedWaystoneNames.addAll(message.names.values());
            WaystoneLibrary.getInstance().isWaystoneNameCacheDirty = false;
            WaystoneLibrary.getInstance().requestedAllNamesEventDispatcher.dispatch(message.names, true);
        }

        public record Packet(Map<WaystoneHandle.Vanilla, String> names) {
            public static final class_9139<class_9129, Packet> STREAM_CODEC = class_9135.method_56377(HashMap::new, WaystoneHandle.Vanilla.STREAM_CODEC, (class_9139)class_9135.field_48554).method_56432(Packet::new, Packet::names);
        }
    }
}

