/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blockpartdata;

import com.mojang.serialization.Codec;
import gollorum.signpost.Signpost;
import gollorum.signpost.blockpartdata.types.LargeSignBlockPart;
import gollorum.signpost.blockpartdata.types.SignBlockPart;
import gollorum.signpost.blockpartdata.types.SmallShortSignBlockPart;
import gollorum.signpost.blockpartdata.types.SmallWideSignBlockPart;
import gollorum.signpost.minecraft.gui.utils.TextureResource;
import gollorum.signpost.minecraft.utils.tints.FoliageTint;
import gollorum.signpost.minecraft.utils.tints.GrassTint;
import gollorum.signpost.utils.Tint;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_4730;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public abstract class Overlay {
    private static final Map<String, Overlay> overlayRegistry = new HashMap<String, Overlay>();
    public final Optional<Tint> tint;
    public final String id;
    public static final Overlay Gras = new Overlay(Optional.of(GrassTint.INSTANCE), "gras"){

        @Override
        public class_4730 materialFor(Class<? extends SignBlockPart> signClass) {
            return new class_4730(TextureResource.blockAtlas, signClass.equals(SmallWideSignBlockPart.class) ? class_2960.method_60655((String)"signpost", (String)"block/sign_overlay_grass") : (signClass.equals(SmallShortSignBlockPart.class) ? class_2960.method_60655((String)"signpost", (String)"block/sign_overlay_grass_short") : (signClass.equals(LargeSignBlockPart.class) ? class_2960.method_60655((String)"signpost", (String)"block/sign_overlay_grass_large") : Overlay.logErrorAndReturn("Sign class " + String.valueOf(signClass) + " is not supported by " + String.valueOf(this), this.materialFor(SmallWideSignBlockPart.class).method_24147()))));
        }
    };
    public static final Overlay Vine = new Overlay(Optional.of(FoliageTint.INSTANCE), "vine"){

        @Override
        public class_4730 materialFor(Class<? extends SignBlockPart> signClass) {
            return new class_4730(TextureResource.blockAtlas, signClass.equals(SmallWideSignBlockPart.class) ? class_2960.method_60655((String)"signpost", (String)"block/sign_overlay_vine") : (signClass.equals(SmallShortSignBlockPart.class) ? class_2960.method_60655((String)"signpost", (String)"block/sign_overlay_vine_short") : (signClass.equals(LargeSignBlockPart.class) ? class_2960.method_60655((String)"signpost", (String)"block/sign_overlay_vine_large") : Overlay.logErrorAndReturn("Sign class " + String.valueOf(signClass) + " is not supported by " + String.valueOf(this), this.materialFor(SmallWideSignBlockPart.class).method_24147()))));
        }
    };
    public static final Overlay Snow = new Overlay(Optional.empty(), "snow"){

        @Override
        public class_4730 materialFor(Class<? extends SignBlockPart> signClass) {
            return new class_4730(TextureResource.blockAtlas, signClass.equals(SmallWideSignBlockPart.class) ? class_2960.method_60655((String)"signpost", (String)"block/sign_overlay_snow") : (signClass.equals(SmallShortSignBlockPart.class) ? class_2960.method_60655((String)"signpost", (String)"block/sign_overlay_snow_short") : (signClass.equals(LargeSignBlockPart.class) ? class_2960.method_60655((String)"signpost", (String)"block/sign_overlay_snow_large") : Overlay.logErrorAndReturn("Sign class " + String.valueOf(signClass) + " is not supported by " + String.valueOf(this), this.materialFor(SmallWideSignBlockPart.class).method_24147()))));
        }
    };
    public static final Overlay Mycelium = new Overlay(Optional.empty(), "mycelium"){

        @Override
        public class_4730 materialFor(Class<? extends SignBlockPart> signClass) {
            return new class_4730(TextureResource.blockAtlas, signClass.equals(SmallWideSignBlockPart.class) ? class_2960.method_60655((String)"signpost", (String)"block/sign_overlay_mycelium") : (signClass.equals(SmallShortSignBlockPart.class) ? class_2960.method_60655((String)"signpost", (String)"block/sign_overlay_mycelium_short") : (signClass.equals(LargeSignBlockPart.class) ? class_2960.method_60655((String)"signpost", (String)"block/sign_overlay_mycelium_large") : Overlay.logErrorAndReturn("Sign class " + String.valueOf(signClass) + " is not supported by " + String.valueOf(this), this.materialFor(SmallWideSignBlockPart.class).method_24147()))));
        }
    };
    public static final Codec<Overlay> CODEC;
    public static final class_9139<ByteBuf, Overlay> STREAM_CODEC;

    public static void register(Overlay overlay) {
        overlayRegistry.put(overlay.id, overlay);
    }

    public static Collection<Overlay> getAllOverlays() {
        return overlayRegistry.values();
    }

    protected Overlay(Optional<Tint> tint, String id) {
        this.tint = tint;
        this.id = id;
    }

    public abstract class_4730 materialFor(Class<? extends SignBlockPart> var1);

    private static <T> T logErrorAndReturn(String error, T t) {
        Signpost.LOGGER.error(error);
        return t;
    }

    static {
        Overlay.register(Gras);
        Overlay.register(Vine);
        Overlay.register(Snow);
        Overlay.register(Mycelium);
        CODEC = Codec.STRING.xmap(id -> {
            if (!overlayRegistry.containsKey(id)) {
                Signpost.LOGGER.error("Tried to read overlay with id " + id + ", but it was not registered.");
                return Gras;
            }
            return overlayRegistry.get(id);
        }, overlay -> overlay.id);
        STREAM_CODEC = class_9135.field_48554.method_56432(id -> {
            if (!overlayRegistry.containsKey(id)) {
                Signpost.LOGGER.error("Tried to read overlay with id " + id + ", but it was not registered.");
                return Gras;
            }
            return overlayRegistry.get(id);
        }, overlay -> overlay.id);
    }
}

