/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blockpartdata.types;

import gollorum.signpost.Signpost;
import gollorum.signpost.blockpartdata.types.LargeSignBlockPart;
import gollorum.signpost.blockpartdata.types.PostBlockPart;
import gollorum.signpost.blockpartdata.types.SmallShortSignBlockPart;
import gollorum.signpost.blockpartdata.types.SmallWideSignBlockPart;
import gollorum.signpost.blockpartdata.types.WaystoneBlockPart;
import gollorum.signpost.blockpartdata.types.renderers.LargeSignRenderer;
import gollorum.signpost.blockpartdata.types.renderers.PostRenderer;
import gollorum.signpost.blockpartdata.types.renderers.ShortSignRenderer;
import gollorum.signpost.blockpartdata.types.renderers.WaystoneRenderer;
import gollorum.signpost.blockpartdata.types.renderers.WideSignRenderer;
import gollorum.signpost.utils.BlockPart;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11701;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_4587;

public abstract class BlockPartRenderer<T extends BlockPart<T>> {
    private static final Map<Class<?>, BlockPartRenderer<?>> renderers = new ConcurrentHashMap();

    public static <T extends BlockPart<T>> void register(Class<T> blockPartClass, BlockPartRenderer<T> renderer) {
        renderers.put(blockPartClass, renderer);
    }

    private static <T extends BlockPart<T>> Optional<BlockPartRenderer<T>> getFor(Class<T> blockPartClass) {
        BlockPartRenderer<?> renderer = renderers.get(blockPartClass);
        return renderer == null ? Optional.empty() : Optional.of(renderer);
    }

    public static <T extends BlockPart<T>> void renderDynamic(T part, class_1937 level, class_2338 pos, class_4587 blockToView, class_11659 nodeCollector, class_11701 materials, int combinedLights, int combinedOverlay, Function<class_2960, class_1921> renderTypeFactory, class_11683.class_11792 crumblingOverlay) {
        Optional<BlockPartRenderer<?>> renderer = BlockPartRenderer.getFor(part.getClass());
        if (renderer.isPresent()) {
            renderer.get().render(part, level, pos, blockToView, nodeCollector, materials, combinedLights, combinedOverlay, renderTypeFactory, crumblingOverlay);
        } else {
            Signpost.LOGGER.error("Block part renderer was not found for " + String.valueOf(part.getClass()));
        }
    }

    public abstract void render(T var1, class_1937 var2, class_2338 var3, class_4587 var4, class_11659 var5, class_11701 var6, int var7, int var8, Function<class_2960, class_1921> var9, class_11683.class_11792 var10);

    static {
        BlockPartRenderer.register(PostBlockPart.class, new PostRenderer());
        BlockPartRenderer.register(SmallWideSignBlockPart.class, new WideSignRenderer());
        BlockPartRenderer.register(SmallShortSignBlockPart.class, new ShortSignRenderer());
        BlockPartRenderer.register(LargeSignBlockPart.class, new LargeSignRenderer());
        BlockPartRenderer.register(WaystoneBlockPart.class, new WaystoneRenderer());
    }
}

