/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blockpartdata.types;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.blockpartdata.Overlay;
import gollorum.signpost.blockpartdata.types.SignBlockPart;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.utils.CoordinatesUtil;
import gollorum.signpost.minecraft.utils.Texture;
import gollorum.signpost.utils.AngleProvider;
import gollorum.signpost.utils.BlockPartMetadata;
import gollorum.signpost.utils.NameProvider;
import gollorum.signpost.utils.math.geometry.AABB;
import gollorum.signpost.utils.math.geometry.Matrix4x4;
import gollorum.signpost.utils.math.geometry.TransformedBox;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_9139;

public class LargeSignBlockPart
extends SignBlockPart<LargeSignBlockPart> {
    private static final AABB LOCAL_BOUNDS = new AABB(new Vector3(-9.0f, -14.0f, 2.0f), new Vector3(12.0f, -2.0f, 3.0f)).map(CoordinatesUtil::voxelToLocal);
    public static final BlockPartMetadata<LargeSignBlockPart> METADATA = new BlockPartMetadata<LargeSignBlockPart>("large_sign", version -> RecordCodecBuilder.mapCodec(i -> i.group((App)SignBlockPart.CoreData.codec(version).fieldOf("CoreData").forGetter(sign -> sign.coreData), (App)NameProvider.CODEC.fieldOf("Text0").forGetter(sign -> sign.text[0]), (App)NameProvider.CODEC.fieldOf("Text1").forGetter(sign -> sign.text[1]), (App)NameProvider.CODEC.fieldOf("Text2").forGetter(sign -> sign.text[2]), (App)NameProvider.CODEC.fieldOf("Text3").forGetter(sign -> sign.text[3])).apply((Applicative)i, LargeSignBlockPart::new)), class_9139.method_56906(SignBlockPart.CoreData.STREAM_CODEC, sign -> sign.coreData, NameProvider.STREAM_CODEC, sign -> sign.text[0], NameProvider.STREAM_CODEC, sign -> sign.text[1], NameProvider.STREAM_CODEC, sign -> sign.text[2], NameProvider.STREAM_CODEC, sign -> sign.text[3], LargeSignBlockPart::new), LargeSignBlockPart.class);
    private NameProvider[] text;

    public LargeSignBlockPart(SignBlockPart.CoreData coreData, NameProvider text0, NameProvider text1, NameProvider text2, NameProvider text3) {
        super(coreData);
        this.text = new NameProvider[]{text0, text1, text2, text3};
    }

    public LargeSignBlockPart(SignBlockPart.CoreData coreData, NameProvider[] text) {
        super(coreData);
        assert (text.length == 4);
        this.text = text;
    }

    public LargeSignBlockPart(AngleProvider angle, NameProvider[] text, boolean flip, Texture mainTexture, Texture secondaryTexture, Optional<Overlay> overlay, int color, Optional<WaystoneHandle> destination, Optional<class_1799> itemToDropOnBreak, PostBlock.ModelType modelType, boolean isLocked, boolean isMarkedForGeneration) {
        this(new SignBlockPart.CoreData(angle, flip, mainTexture, secondaryTexture, overlay, color, destination, modelType, itemToDropOnBreak, isLocked, isMarkedForGeneration), text);
    }

    public void setText(NameProvider[] text) {
        this.text = text;
    }

    public NameProvider[] getText() {
        return this.text;
    }

    @Override
    protected NameProvider[] getNameProviders() {
        return this.text;
    }

    @Override
    protected void regenerateTransformedBox() {
        this.transformedBounds = new TransformedBox(LOCAL_BOUNDS).rotateAlong(Matrix4x4.Axis.Y, this.coreData.angleProvider.get());
        if (this.coreData.flip) {
            this.transformedBounds = this.transformedBounds.scale(new Vector3(1.0f, 1.0f, -1.0f));
        }
    }

    @Override
    public LargeSignBlockPart copy() {
        return new LargeSignBlockPart(this.coreData.copy(), this.text);
    }

    @Override
    public BlockPartMetadata<LargeSignBlockPart> getMeta() {
        return METADATA;
    }
}

