/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blockpartdata.types;

import gollorum.signpost.PlayerHandle;
import gollorum.signpost.Signpost;
import gollorum.signpost.blockpartdata.types.SignBlockPart;
import gollorum.signpost.blockpartdata.types.WaystoneBlockPart;
import gollorum.signpost.interactions.Interactable;
import gollorum.signpost.interactions.InteractionInfo;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.block.WaystoneBlock;
import gollorum.signpost.minecraft.gui.PaintPostGui;
import gollorum.signpost.minecraft.gui.RequestWaystoneGui;
import gollorum.signpost.minecraft.gui.SignGui;
import gollorum.signpost.minecraft.items.Brush;
import gollorum.signpost.minecraft.utils.CoordinatesUtil;
import gollorum.signpost.minecraft.utils.SideUtils;
import gollorum.signpost.minecraft.utils.Texture;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.security.WithOwner;
import gollorum.signpost.utils.BlockPart;
import gollorum.signpost.utils.BlockPartInstance;
import gollorum.signpost.utils.BlockPartMetadata;
import gollorum.signpost.utils.WorldLocation;
import gollorum.signpost.utils.math.geometry.AABB;
import gollorum.signpost.utils.math.geometry.Intersectable;
import gollorum.signpost.utils.math.geometry.Ray;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_8162;

public class PostBlockPart
implements BlockPart<PostBlockPart> {
    private static final int maxSignCount = 10;
    private static final AABB BOUNDS = new AABB(new Vector3(-2.0f, -8.0f, -2.0f), new Vector3(2.0f, 8.0f, 2.0f)).map(CoordinatesUtil::voxelToLocal);
    public static final BlockPartMetadata<PostBlockPart> METADATA = new BlockPartMetadata<PostBlockPart>("Post", version -> Texture.codec(version).fieldOf("texture").xmap(PostBlockPart::new, PostBlockPart::getTexture), Texture.STREAM_CODEC.method_56439(it -> it).method_56432(PostBlockPart::new, PostBlockPart::getTexture), PostBlockPart.class);
    private Texture texture;

    public PostBlockPart(Texture texture) {
        this.setTexture(texture);
    }

    public void setTexture(Texture texture) {
        this.texture = texture;
    }

    public Texture getTexture() {
        return this.texture;
    }

    @Override
    public Intersectable<Ray, Float> getIntersection() {
        return BOUNDS;
    }

    @Override
    public Interactable.InteractionResult interact(InteractionInfo info) {
        class_1799 heldItem = info.player.method_5998(info.hand);
        PlayerHandle playerHandle = PlayerHandle.from((class_1297)info.player);
        if (PostBlockPart.isValidSign(heldItem, (class_7225.class_7874)info.player.method_56673())) {
            return this.attachSign(info, heldItem);
        }
        if (PostBlockPart.isWaystone(heldItem)) {
            return this.attachWaystone(info, heldItem, playerHandle);
        }
        if (PostBlockPart.isBrush(heldItem)) {
            return this.paint(info);
        }
        return Interactable.InteractionResult.Ignored;
    }

    private Interactable.InteractionResult attachWaystone(InteractionInfo info, class_1799 heldItem, PlayerHandle playerHandle) {
        if (info.tile.getParts().stream().noneMatch(p -> p.blockPart() instanceof WaystoneBlockPart)) {
            if (!info.isRemote) {
                info.tile.addPart(new BlockPartInstance(new WaystoneBlockPart(playerHandle), Vector3.ZERO), new class_1799((class_1935)heldItem.method_7909()), PlayerHandle.from((class_1297)info.player));
                info.tile.method_5431();
                SideUtils.makePlayerPay(info.player, new class_1799((class_1935)WaystoneBlock.getInstance()));
                if (info.player instanceof class_3222) {
                    PacketHandler.getInstance().sendToPlayer((class_3222)info.player, new RequestWaystoneGui.Package(WorldLocation.from(info.tile.method_11016(), info.player.method_73183()), Optional.empty()));
                } else {
                    Signpost.LOGGER.error("Tried to ask sender to open the waystone GUI, but it was a " + info.player.getClass().getName());
                }
            }
            return Interactable.InteractionResult.Accepted;
        }
        return Interactable.InteractionResult.Ignored;
    }

    private Interactable.InteractionResult attachSign(InteractionInfo info, class_1799 heldItem) {
        if (info.isRemote && info.tile.getParts().stream().filter(i -> i.blockPart() instanceof SignBlockPart).count() < 10L) {
            SignGui.display(info.tile, PostBlock.ModelType.from(info.player.method_5998(info.hand).method_7909(), (class_7225.class_7874)info.player.method_56673()).get(), info.traceResult.hitPos, Optional.of(new class_1799((class_1935)heldItem.method_7909(), 1)));
        }
        return Interactable.InteractionResult.Accepted;
    }

    private Interactable.InteractionResult paint(InteractionInfo info) {
        if (info.isRemote) {
            PaintPostGui.display(info.tile, this, info.traceResult.id);
        }
        return Interactable.InteractionResult.Accepted;
    }

    private static boolean isValidSign(class_1799 itemStack, class_7225.class_7874 registryAccess) {
        if (itemStack == null || itemStack.method_7947() < 1) {
            return false;
        }
        class_1792 item = itemStack.method_7909();
        return PostBlock.ModelType.from(item, registryAccess).isPresent();
    }

    private static boolean isWaystone(class_1799 itemStack) {
        if (itemStack == null || itemStack.method_7947() < 1) {
            return false;
        }
        class_1792 item = itemStack.method_7909();
        return item.equals(WaystoneBlock.getInstance().method_8389());
    }

    private static boolean isBrush(class_1799 itemStack) {
        if (itemStack == null || itemStack.method_7947() < 1) {
            return false;
        }
        class_1792 item = itemStack.method_7909();
        return item instanceof Brush || item instanceof class_8162;
    }

    @Override
    public BlockPartMetadata<PostBlockPart> getMeta() {
        return METADATA;
    }

    @Override
    public boolean hasThePermissionToEdit(WithOwner owner, class_1657 player) {
        return true;
    }

    @Override
    public Collection<class_1799> getDrops() {
        return Collections.emptySet();
    }

    @Override
    public Collection<Texture> getAllTextures() {
        return Collections.singleton(this.getTexture());
    }
}

