/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blockpartdata.types;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gollorum.signpost.Teleport;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.blockpartdata.Overlay;
import gollorum.signpost.blockpartdata.types.renderers.BlockPartWaystoneUpdateListener;
import gollorum.signpost.events.WaystoneUpdatedEvent;
import gollorum.signpost.interactions.Interactable;
import gollorum.signpost.interactions.InteractionInfo;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.config.IConfig;
import gollorum.signpost.minecraft.gui.PaintSignGui;
import gollorum.signpost.minecraft.gui.RequestSignGui;
import gollorum.signpost.minecraft.items.Brush;
import gollorum.signpost.minecraft.items.GenerationWand;
import gollorum.signpost.minecraft.utils.Texture;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.security.WithOwner;
import gollorum.signpost.utils.AngleProvider;
import gollorum.signpost.utils.BlockPart;
import gollorum.signpost.utils.Either;
import gollorum.signpost.utils.NameProvider;
import gollorum.signpost.utils.Tuple;
import gollorum.signpost.utils.WaystoneHandleUtils;
import gollorum.signpost.utils.math.Angle;
import gollorum.signpost.utils.math.geometry.Intersectable;
import gollorum.signpost.utils.math.geometry.Ray;
import gollorum.signpost.utils.math.geometry.TransformedBox;
import gollorum.signpost.utils.math.geometry.Vector3;
import gollorum.signpost.utils.serialization.ItemStackSerializer;
import gollorum.signpost.utils.serialization.OptionalSerializerV1;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_8162;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public abstract class SignBlockPart<Self extends SignBlockPart<Self>>
implements BlockPart<Self> {
    protected CoreData coreData;
    protected TransformedBox transformedBounds;

    public static Angle pointingAt(class_2338 block, class_2338 target) {
        class_2338 diff = target.method_10059((class_2382)block);
        return Angle.between(diff.method_10263(), diff.method_10260(), 1.0f, 0.0f);
    }

    public Optional<WaystoneHandle> getDestination() {
        return this.coreData.destination;
    }

    protected SignBlockPart(CoreData coreData) {
        this.coreData = coreData;
        this.setAngle(coreData.angleProvider);
        this.setTextures(coreData.mainTexture, coreData.secondaryTexture);
        this.setOverlay(coreData.overlay);
        this.setFlip(coreData.flip);
    }

    public void setAngle(AngleProvider angleProvider) {
        this.coreData.angleProvider = angleProvider;
        this.regenerateTransformedBox();
    }

    protected abstract NameProvider[] getNameProviders();

    @Override
    public void attachTo(PostTile tile) {
        class_2338 myBlockPos = tile.method_11016();
        BlockPartWaystoneUpdateListener.getInstance().addListener(this, (self, event) -> SignBlockPart.onWaystoneUpdated(myBlockPos, self, event));
    }

    private static void onWaystoneUpdated(class_2338 myBlockPos, SignBlockPart<?> self, WaystoneUpdatedEvent event) {
        self.getDestination().ifPresent(handle -> {
            if (handle.equals(event.handle)) {
                if (self.getAngle() instanceof AngleProvider.WaystoneTarget) {
                    ((AngleProvider.WaystoneTarget)self.getAngle()).setCachedAngle(SignBlockPart.pointingAt(myBlockPos, event.location.block().blockPos()));
                }
                for (NameProvider np : self.getNameProviders()) {
                    if (!(np instanceof NameProvider.WaystoneTarget)) continue;
                    ((NameProvider.WaystoneTarget)np).setCachedName(event.name);
                }
            }
        });
    }

    public void setFlip(boolean flip) {
        this.coreData.flip = flip;
        this.setTextures(this.coreData.mainTexture, this.coreData.secondaryTexture);
        this.setOverlay(this.coreData.overlay);
        this.regenerateTransformedBox();
    }

    public void setColor(int color) {
        this.coreData.color = color;
    }

    public void setDestination(Optional<WaystoneHandle> destination) {
        this.coreData.destination = destination;
    }

    public void setItemToDropOnBreak(Optional<class_1799> itemToDropOnBreak) {
        this.coreData.itemToDropOnBreak = itemToDropOnBreak;
    }

    private void setModelType(PostBlock.ModelType modelType) {
        this.coreData.modelType = modelType;
    }

    public Optional<class_1799> getItemToDropOnBreak() {
        return this.coreData.itemToDropOnBreak;
    }

    public boolean isFlipped() {
        return this.coreData.flip;
    }

    public int getColor() {
        return this.coreData.color;
    }

    public PostBlock.ModelType getModelType() {
        return this.coreData.modelType;
    }

    public boolean isLocked() {
        return this.coreData.isLocked;
    }

    public boolean isMarkedForGeneration() {
        return this.coreData.isMarkedForGeneration;
    }

    @Override
    public boolean hasThePermissionToEdit(WithOwner tile, class_1657 player) {
        return !(tile instanceof WithOwner.OfSignpost) || !this.coreData.isLocked || player == null || ((WithOwner.OfSignpost)tile).getSignpostOwner().map(o -> o.id().equals(player.method_5667())).orElse(true) != false || player.method_64475(IConfig.IServer.getInstance().permissions().editLockedSignCommandPermissionLevel());
    }

    private void setTextures(Texture texture, Texture textureDark) {
        this.coreData.mainTexture = texture;
        this.coreData.secondaryTexture = textureDark;
    }

    public Texture getMainTexture() {
        return this.coreData.mainTexture;
    }

    public Texture getSecondaryTexture() {
        return this.coreData.secondaryTexture;
    }

    public void setMainTexture(Texture tex) {
        this.coreData.mainTexture = tex;
    }

    public void setSecondaryTexture(Texture tex) {
        this.coreData.secondaryTexture = tex;
    }

    private void setOverlay(Optional<Overlay> overlay) {
        this.coreData.overlay = overlay;
    }

    public Optional<Overlay> getOverlay() {
        return this.coreData.overlay;
    }

    protected abstract void regenerateTransformedBox();

    @Override
    public Intersectable<Ray, Float> getIntersection() {
        return this.isMarkedForGeneration() && !IConfig.IServer.getInstance().worldGen().debugMode() ? new Intersectable.Not() : this.transformedBounds;
    }

    @Override
    public Interactable.InteractionResult interact(InteractionInfo info) {
        class_1799 heldItem = info.player.method_5998(info.hand);
        if (!info.isRemote) {
            if (this.holdsAngleTool(info)) {
                if (info.player.method_18276()) {
                    this.setFlip(!this.isFlipped());
                    this.notifyChange(info);
                } else {
                    Vector3 diff = info.traceResult.ray.start.negated().add(0.5f, 0.5f, 0.5f).withY(0.0f).normalized();
                    Vector3 rayDir = info.traceResult.ray.dir.withY(0.0f).normalized();
                    Angle angleToPost = Angle.between(rayDir.x(), rayDir.z(), diff.x(), diff.z()).normalized();
                    this.setAngle(new AngleProvider.Literal(this.coreData.angleProvider.get().add(Angle.fromDegrees(angleToPost.radians() < 0.0f ? 15.0f : -15.0f))));
                    this.notifyChange(info);
                }
            } else if (SignBlockPart.isGenerationWand(heldItem)) {
                this.coreData.isMarkedForGeneration = !this.coreData.isMarkedForGeneration;
                this.notifyChange(info);
            } else if (!SignBlockPart.isBrush(heldItem)) {
                this.tryTeleport((class_3222)info.player, info.getTilePartInfo());
            }
        } else if (SignBlockPart.isBrush(heldItem)) {
            this.paint(info);
        }
        return Interactable.InteractionResult.Accepted;
    }

    private void tryTeleport(class_3222 player, PostTile.TilePartInfo tilePartInfo) {
        if (IConfig.IServer.getInstance().teleport().enableTeleport() && this.coreData.destination.isPresent() && (!(this.coreData.destination.get() instanceof WaystoneHandle.Vanilla) || WaystoneLibrary.getInstance().contains((WaystoneHandle.Vanilla)this.coreData.destination.get()))) {
            WaystoneHandle dest = this.coreData.destination.get();
            PacketHandler.getInstance().sendToPlayer(player, new Teleport.RequestGui.Package(Either.rightIfPresent(WaystoneLibrary.getInstance().getData(dest), () -> "signpost.waystone_not_found").mapRight(data -> {
                Optional<class_2561> cannotTeleportBecause = WaystoneHandleUtils.cannotTeleportToBecause((class_1657)player, dest, data.name());
                int distance = (int)data.loc().spawn().distanceTo(Vector3.fromVec3d(player.method_73189()));
                return new Teleport.RequestGui.Package.Info(IConfig.IServer.getInstance().teleport().maximumDistance(), distance, cannotTeleportBecause, data.name(), Teleport.getCost(player, Vector3.fromVec3d(player.method_73189()), data.loc().spawn()), Optional.of(data.handle()));
            }), Optional.of(tilePartInfo)));
        } else {
            PacketHandler.getInstance().sendToPlayer(player, new RequestSignGui.Package(tilePartInfo));
        }
    }

    private boolean holdsAngleTool(InteractionInfo info) {
        class_1799 itemStack = info.player.method_5998(info.hand);
        return !itemStack.method_7960() && PostTile.isAngleTool(itemStack.method_7909());
    }

    private static boolean isBrush(class_1799 itemStack) {
        if (itemStack == null || itemStack.method_7947() < 1) {
            return false;
        }
        class_1792 item = itemStack.method_7909();
        return item instanceof Brush || item instanceof class_8162;
    }

    private static boolean isGenerationWand(class_1799 itemStack) {
        if (itemStack == null || itemStack.method_7947() < 1) {
            return false;
        }
        class_1792 item = itemStack.method_7909();
        return item instanceof GenerationWand;
    }

    private Interactable.InteractionResult paint(InteractionInfo info) {
        if (info.isRemote) {
            PaintSignGui.display(info.tile, this, info.traceResult.id);
        }
        return Interactable.InteractionResult.Accepted;
    }

    protected void notifyChange(InteractionInfo info) {
        info.mutationDistributor.run();
    }

    @Override
    public Collection<class_1799> getDrops() {
        return this.coreData.itemToDropOnBreak.stream().toList();
    }

    public AngleProvider getAngle() {
        return this.coreData.angleProvider;
    }

    public abstract Self copy();

    @Override
    public Collection<Texture> getAllTextures() {
        return Arrays.asList(this.getMainTexture(), this.getSecondaryTexture());
    }

    public static final class CoreData {
        public AngleProvider angleProvider;
        public boolean flip;
        public Texture mainTexture;
        public Texture secondaryTexture;
        public Optional<Overlay> overlay;
        public int color;
        public Optional<WaystoneHandle> destination;
        public PostBlock.ModelType modelType;
        public Optional<class_1799> itemToDropOnBreak;
        public boolean isLocked;
        public boolean isMarkedForGeneration;
        public static final class_9139<class_9129, CoreData> STREAM_CODEC = class_9139.method_67079(AngleProvider.STREAM_CODEC, coreData -> coreData.angleProvider, (class_9139)class_9135.field_48547, coreData -> coreData.flip, Tuple.streamCodec(Texture.STREAM_CODEC, Texture.STREAM_CODEC), coreData -> Tuple.of(coreData.mainTexture, coreData.secondaryTexture), Tuple.streamCodec(class_9135.method_56382(Overlay.STREAM_CODEC), class_9135.field_49675), coreData -> Tuple.of(coreData.overlay, coreData.color), (class_9139)class_9135.method_56382(WaystoneHandle.STREAM_CODEC), coreData -> coreData.destination, PostBlock.ModelType.STREAM_CODEC, coreData -> coreData.modelType, (class_9139)class_9135.method_56382((class_9139)class_1799.field_49268), coreData -> coreData.itemToDropOnBreak, (class_9139)class_9135.field_48547, coreData -> coreData.isLocked, (class_9139)class_9135.field_48547, coreData -> coreData.isMarkedForGeneration, (angleProvider, flip, txts, overlayAndColor, destination, modelType, itemToDropOnBreak, isLocked, isMarkedForGeneration) -> new CoreData((AngleProvider)angleProvider, (boolean)flip, (Texture)txts._1(), (Texture)txts._2(), (Optional)overlayAndColor._1(), (Integer)overlayAndColor._2(), (Optional<WaystoneHandle>)destination, (PostBlock.ModelType)modelType, (Optional<class_1799>)itemToDropOnBreak, (boolean)isLocked, (boolean)isMarkedForGeneration));

        public CoreData(AngleProvider angleProvider, boolean flip, Texture mainTexture, Texture secondaryTexture, Optional<Overlay> overlay, int color, Optional<WaystoneHandle> destination, PostBlock.ModelType modelType, Optional<class_1799> itemToDropOnBreak, boolean isLocked, boolean isMarkedForGeneration) {
            this.angleProvider = angleProvider;
            this.flip = flip;
            this.mainTexture = mainTexture;
            this.secondaryTexture = secondaryTexture;
            this.overlay = overlay;
            this.color = color;
            this.destination = destination;
            this.modelType = modelType;
            this.itemToDropOnBreak = itemToDropOnBreak;
            this.isLocked = isLocked;
            this.isMarkedForGeneration = isMarkedForGeneration;
        }

        public CoreData copy() {
            return new CoreData(this.angleProvider, this.flip, this.mainTexture, this.secondaryTexture, this.overlay, this.color, this.destination, this.modelType, this.itemToDropOnBreak, this.isLocked, this.isMarkedForGeneration);
        }

        public static Codec<CoreData> codec(int version) {
            MapCodec optionalOverlayCodec = version < 2 ? OptionalSerializerV1.of(Overlay.CODEC).fieldOf("Overlay") : Codec.optionalField((String)"Overlay", Overlay.CODEC, (boolean)true);
            MapCodec optionalDestinationCodec = version < 2 ? Codec.BOOL.dispatch("IsPresent", Optional::isPresent, isPresent -> isPresent != false ? WaystoneHandle.MAP_CODEC.xmap(Optional::of, Optional::get) : MapCodec.unit(Optional.empty())).fieldOf("Destination") : WaystoneHandle.MAP_CODEC.codec().optionalFieldOf("Destination");
            return RecordCodecBuilder.create(i -> i.group((App)AngleProvider.MAP_CODEC.fieldOf("Angle").forGetter(coreData -> coreData.angleProvider), (App)Codec.BOOL.fieldOf("Flip").forGetter(coreData -> coreData.flip), (App)Texture.codec(version).fieldOf("Texture").forGetter(coreData -> coreData.mainTexture), (App)Texture.codec(version).fieldOf("TextureDark").forGetter(coreData -> coreData.secondaryTexture), (App)optionalOverlayCodec.forGetter(coreData -> coreData.overlay), (App)Codec.INT.fieldOf("Color").forGetter(coreData -> coreData.color), (App)optionalDestinationCodec.forGetter(coreData -> coreData.destination), (App)PostBlock.ModelType.CODEC.fieldOf("ModelType").forGetter(coreData -> coreData.modelType), (App)Codec.optionalField((String)"ItemToDropOnBreak", (Codec)ItemStackSerializer.CODEC.codec(), (boolean)true).forGetter(coreData -> coreData.itemToDropOnBreak), (App)Codec.BOOL.fieldOf("IsLocked").forGetter(coreData -> coreData.isLocked), (App)Codec.BOOL.fieldOf("IsMarkedForGeneration").forGetter(coreData -> coreData.isMarkedForGeneration)).apply((Applicative)i, CoreData::new));
        }
    }
}

