/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blockpartdata.types;

import gollorum.signpost.PlayerHandle;
import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.events.WaystoneUpdatedEvent;
import gollorum.signpost.interactions.Interactable;
import gollorum.signpost.interactions.InteractionInfo;
import gollorum.signpost.minecraft.block.WaystoneBlock;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.gui.utils.TextureResource;
import gollorum.signpost.minecraft.utils.CoordinatesUtil;
import gollorum.signpost.minecraft.utils.Texture;
import gollorum.signpost.security.WithOwner;
import gollorum.signpost.utils.BlockPart;
import gollorum.signpost.utils.BlockPartMetadata;
import gollorum.signpost.utils.EventDispatcher;
import gollorum.signpost.utils.IDelay;
import gollorum.signpost.utils.WaystoneData;
import gollorum.signpost.utils.WorldLocation;
import gollorum.signpost.utils.math.geometry.AABB;
import gollorum.signpost.utils.math.geometry.Intersectable;
import gollorum.signpost.utils.math.geometry.Ray;
import gollorum.signpost.utils.math.geometry.Vector3;
import gollorum.signpost.utils.serialization.OptionalSerializerV1;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_9135;

public class WaystoneBlockPart
implements BlockPart<WaystoneBlockPart>,
WithOwner.OfWaystone {
    private Optional<PlayerHandle> owner;
    private Optional<WaystoneHandle.Vanilla> handle = Optional.empty();
    private Optional<String> name = Optional.empty();
    private static final AABB BOUNDS = new AABB(new Vector3(-3.0f, -8.0f, -3.0f), new Vector3(3.0f, -2.0f, 3.0f)).map(CoordinatesUtil::voxelToLocal);
    public static final BlockPartMetadata<WaystoneBlockPart> METADATA = new BlockPartMetadata<WaystoneBlockPart>("Waystone", version -> (version < 2 ? OptionalSerializerV1.of(PlayerHandle.WRAPPED_CODEC).fieldOf("owner") : PlayerHandle.DIRECT_CODEC.optionalFieldOf("owner")).xmap(WaystoneBlockPart::new, w -> w.owner), class_9135.method_56382(PlayerHandle.STREAM_CODEC).method_56432(WaystoneBlockPart::new, w -> w.owner).method_56439(it -> it), WaystoneBlockPart.class);
    private EventDispatcher.Listener<WaystoneUpdatedEvent> updateListener;

    public Optional<WaystoneHandle.Vanilla> getHandle() {
        return this.handle;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public WaystoneBlockPart(Optional<PlayerHandle> owner) {
        this.owner = owner;
    }

    public WaystoneBlockPart(PlayerHandle owner) {
        this.owner = Optional.of(owner);
    }

    public void initialize(class_1937 level, class_2338 position) {
        if (this.updateListener != null) {
            return;
        }
        WorldLocation location = WorldLocation.from(position, level);
        this.updateListener = event -> {
            if (location.equals(event.location.block())) {
                this.name = Optional.of(event.name);
                this.handle = Optional.of(event.handle);
            }
            return false;
        };
        IDelay.forFrames(10, level.method_8608(), () -> {
            WaystoneLibrary.getInstance().requestWaystoneAt(location, data -> {
                this.handle = data.map(WaystoneData::handle);
                this.name = data.map(WaystoneData::name);
            }, level.method_8608());
            WaystoneLibrary.getInstance().updateEventDispatcher.addListener(this.updateListener);
        });
    }

    @Override
    public void attachTo(PostTile tile) {
        this.initialize(tile.method_10997(), tile.method_11016());
    }

    @Override
    public Intersectable<Ray, Float> getIntersection() {
        return BOUNDS;
    }

    @Override
    public Interactable.InteractionResult interact(InteractionInfo info) {
        WaystoneBlock.onRightClick(info.player.method_73183(), info.tile.method_11016(), info.player);
        return Interactable.InteractionResult.Accepted;
    }

    @Override
    public BlockPartMetadata<WaystoneBlockPart> getMeta() {
        return METADATA;
    }

    @Override
    public boolean hasThePermissionToEdit(WithOwner tile, class_1657 player) {
        return true;
    }

    @Override
    public Collection<class_1799> getDrops() {
        return Collections.singleton(new class_1799((class_1935)WaystoneBlock.getInstance().method_8389()));
    }

    @Override
    public void removeFrom(PostTile tile) {
        if (tile.method_11002() && !tile.method_10997().method_8608()) {
            Optional<WorldLocation> location = WorldLocation.from(tile);
            if (location.isPresent()) {
                WaystoneLibrary.getInstance().removeAt(location.get(), PlayerHandle.Invalid);
            } else {
                Signpost.LOGGER.error("Waystone tile at {} was removed but world was null. This means that the waystone has not been cleaned up correctly.", (Object)tile.method_11016());
            }
        }
        WaystoneLibrary.getInstance().updateEventDispatcher.removeListener(this.updateListener);
    }

    @Override
    public Optional<PlayerHandle> getWaystoneOwner() {
        return this.owner;
    }

    @Override
    public void setWaystoneOwner(Optional<PlayerHandle> owner) {
        this.owner = owner;
    }

    @Override
    public Collection<Texture> getAllTextures() {
        return Collections.singleton(TextureResource.waystoneTextureLocation);
    }
}

