/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blockpartdata.types.renderers;

import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.blockpartdata.Overlay;
import gollorum.signpost.blockpartdata.types.LargeSignBlockPart;
import gollorum.signpost.blockpartdata.types.renderers.SignRenderer;
import gollorum.signpost.minecraft.gui.utils.Colors;
import gollorum.signpost.minecraft.models.LargeSignModel;
import gollorum.signpost.minecraft.models.modelGeneration.QuadModel;
import gollorum.signpost.minecraft.rendering.RenderingUtil;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_11659;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_4587;

public class LargeSignRenderer
extends SignRenderer<LargeSignBlockPart> {
    private static final float TEXT_OFFSET_RIGHT = 0.4375f;
    private static final float TEXT_OFFSET_LEFT_SHORT = 0.5625f;
    private static final float TEXT_OFFSET_LEFT_LONG = 0.625f;
    private static final float MAXIMUM_TEXT_WIDTH_SHORT = 1.0f;
    private static final float MAXIMUM_TEXT_WIDTH_LONG = 1.0625f;
    private static final float TEXT_RATIO = 1.3f;
    private static final float FONT_SIZE_VOXELS = 1.5384616f;

    @Override
    protected QuadModel makeMainModel(LargeSignBlockPart sign) {
        return sign.isFlipped() ? LargeSignModel.MODEL_MAIN_FLIPPED : LargeSignModel.MODEL_MAIN;
    }

    @Override
    protected QuadModel makeSecondaryModel(LargeSignBlockPart sign) {
        return sign.isFlipped() ? LargeSignModel.MODEL_SECONDARY_FLIPPED : LargeSignModel.MODEL_SECONDARY;
    }

    @Override
    protected QuadModel makeBakedOverlayModel(LargeSignBlockPart sign, Overlay overlay) {
        return sign.isFlipped() ? LargeSignModel.MODEL_OVERLAY_FLIPPED : LargeSignModel.MODEL_OVERLAY;
    }

    @Override
    public void renderText(LargeSignBlockPart sign, class_4587 matrix, class_327 fontRenderer, class_11659 nodeCollector, int combinedLights) {
        RenderingUtil.wrapInMatrixEntry(matrix, () -> {
            matrix.method_22904(0.0, 0.21875, -0.1878125);
            RenderingUtil.wrapInMatrixEntry(matrix, () -> this.render(sign, fontRenderer, sign.getText()[3].get(), matrix, nodeCollector, combinedLights, false));
            matrix.method_46416(0.0f, -0.14583333f, 0.0f);
            RenderingUtil.wrapInMatrixEntry(matrix, () -> this.render(sign, fontRenderer, sign.getText()[2].get(), matrix, nodeCollector, combinedLights, false));
            matrix.method_46416(0.0f, -0.14583333f, 0.0f);
            RenderingUtil.wrapInMatrixEntry(matrix, () -> this.render(sign, fontRenderer, sign.getText()[1].get(), matrix, nodeCollector, combinedLights, false));
            matrix.method_46416(0.0f, -0.14583333f, 0.0f);
            RenderingUtil.wrapInMatrixEntry(matrix, () -> this.render(sign, fontRenderer, sign.getText()[0].get(), matrix, nodeCollector, combinedLights, false));
        });
    }

    private void render(LargeSignBlockPart sign, class_327 fontRenderer, String txt, class_4587 matrix, class_11659 nodeCollector, int combinedLights, boolean isLong) {
        RenderingUtil.wrapInMatrixEntry(matrix, () -> {
            Optional overrideName;
            String text = txt;
            if (sign.isMarkedForGeneration() && (overrideName = WaystoneLibrary.getInstance().getAllWaystoneNames(true).flatMap(s -> s.stream().skip(new Random().nextInt(s.size() - 1)).findFirst())).isPresent()) {
                text = (String)overrideName.get();
            }
            float scale = 0.012019231f;
            float MAX_WIDTH_FRAC = (float)fontRenderer.method_1727(text) * scale / (isLong ? 1.0625f : 1.0f);
            float offset = 0.4375f * Math.min(1.0f, MAX_WIDTH_FRAC);
            matrix.method_46416(sign.isFlipped() ? offset - (float)fontRenderer.method_1727(text) * (scale /= Math.max(1.0f, MAX_WIDTH_FRAC)) : -offset, -scale * 4.0f * 1.3f, 0.0f);
            matrix.method_22905(scale, scale * 1.3f, scale);
            nodeCollector.method_73478(matrix, 0.0f, 0.0f, class_2561.method_43470((String)text).method_30937(), false, class_327.class_6415.field_33995, combinedLights, Colors.withAlpha(sign.getColor(), 255), 0, 0);
        });
    }
}

